----------------------------------------------------------------------------
-- @Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------

slurryRotation = {}
slurryRotation.title = "Placeable Animated Slurry Refill Script";
slurryRotation.author = "ViperGTS96";
slurryRotation.rotSpeed = 0.001;
slurryRotation.duplex = 0;

BuyingStationPlaceable.load = function(self, xmlFilename, x,y,z, rx,ry,rz, initRandom)

	if not BuyingStationPlaceable:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, initRandom) then
        return false;
    end;

	local xmlFile = loadXMLFile("TempXML", xmlFilename)
    self.buyingStation = BuyingStation:new(self.isServer, self.isClient)
    self.buyingStation:load(self.nodeId, xmlFile, "placeable.buyingStation", self.customEnvironment)
    self.buyingStation.owningPlaceable = self
	if hasXMLProperty(xmlFile, "placeable.slurry#rotNode") then
		if slurryRotation.duplex ~= 1 then	
			if g_currentMission.slurryRotNodes == nil then
				g_currentMission.slurryRotNodes = {};
			end;
			local newNode = I3DUtil.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.slurry#rotNode"));
			g_currentMission.slurryRotNodes[#g_currentMission.slurryRotNodes+1] = newNode;	
			self.buyingStation.slurryRotNode = newNode;
		else
			slurryRotation.duplex = slurryRotation.duplex+1;
		end;
	end;
    delete(xmlFile);
    return true;

end;

BuyingStationPlaceable.delete = function(self)
    if self.buyingStation ~= nil then
		if g_currentMission.slurryRotNodes ~= nil and #g_currentMission.slurryRotNodes > 0 then
			for i, node in pairs(g_currentMission.slurryRotNodes) do
				local rotNode = self.buyingStation.slurryRotNode;
				if self.buyingStation.slurryRotNode ~= nil and self.buyingStation.slurryRotNode == node then
					table.remove(g_currentMission.slurryRotNodes, i);
				end;
			end;
		end;
		self.buyingStation:delete();
    end;
    unregisterObjectClassName(self);
    BuyingStationPlaceable:superClass().delete(self);
	slurryRotation.duplex = 0;
end;

addModEventListener(slurryRotation);

function slurryRotation:update(dt)

	if g_currentMission.slurryRotNodes ~= nil and #g_currentMission.slurryRotNodes > 0 then
		for i=1, #g_currentMission.slurryRotNodes do
			if g_currentMission.slurryRotNodes[i] ~= nil then
				local xR,yR,zR = getRotation(g_currentMission.slurryRotNodes[i]);
				yR = yR + slurryRotation.rotSpeed;
				setRotation(g_currentMission.slurryRotNodes[i], xR,yR,zR);
			else
				table.remove(g_currentMission.slurryRotNodes, i);
			end;
		end;
	end;

	if g_gui:getIsGuiVisible() and slurryRotation.duplex < 1 then
		slurryRotation.duplex = 1;
	elseif not g_gui:getIsGuiVisible() and slurryRotation.duplex > 0 then
		slurryRotation.duplex = 0;
	end;
	
end;