--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 17.07.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 17.07.2019 - Release Version

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


APE_UniversalPlacement = {}
local APE_UniversalPlacement_mt = Class(APE_UniversalPlacement)

function APE_UniversalPlacement:new(isServer, isClient)
    local self = {}
    setmetatable(self, APE_UniversalPlacement_mt)

    self.isServer = isServer
    self.isClient = isClient

    self.target = nil
    self.parts = nil

    self.selectedPart = nil
    self.selectedPartId = 1

    self.allowMovementModifier = false
    self.allowMovement = false

    self.positionValid = true

    self.lastInputValues = {}
    self.lastInputValues.upDown = 0
    self.lastInputValues.leftRight = 0
    self.lastInputValues.rotate = 0
    self.lastInputValues.raiseLower = 0

    self.originalY = nil
    self.movementDirection = 1
    self.selectedPartCamera = {}

    self.cameraStep = -2
    self.modifierActive = false

    self.camera = createCamera("camera", math.rad(60), 1, 4000)
    self.cameraBaseNode = createTransformGroup("cameraBaseNode")
    link(self.cameraBaseNode, self.camera)

    setRotation(self.camera, 0, math.rad(180), 0)
    setTranslation(self.camera, 0, 0, -6)
    setRotation(self.cameraBaseNode, math.rad(45), 0, 0)

    self.cameraMainBaseNode = createTransformGroup("cameraMainBaseNode")
    link(self.cameraMainBaseNode, self.cameraBaseNode)

    self.enabled = false

    FSBaseMission.draw = Utils.appendedFunction(FSBaseMission.draw, function(self)
        if g_animalPenExtensionManager ~= nil and g_animalPenExtensionManager.universalPlacement ~= nil then
            if g_animalPenExtensionManager.universalPlacement.enabled then
                g_animalPenExtensionManager.universalPlacement:draw()

                if self.controlledVehicle ~= nil then
                    g_animalPenExtensionManager.universalPlacement:cancelOrDelete(false, true)
                end
            end
        end
    end)

    return self
end

function APE_UniversalPlacement:delete()
    self.enabled = false

    self:cancelOrDelete(true, false)
    delete(self.cameraMainBaseNode)

    self.camera = nil
    self.cameraBaseNode = nil
    self.cameraMainBaseNode = nil
end

function APE_UniversalPlacement:activate(target, parts)
    self.target = target
    self.parts = parts

    self.originalY = {}
    self.cameraStep = -2

    if self.target ~= nil and self.parts ~= nil and #self.parts == 2 then
        link(self.target.waterLinkNode, self.cameraMainBaseNode)

        self.movementDirection = 1

        setTranslation(self.camera, 0, 0, -6)
        setRotation(self.cameraBaseNode, math.rad(45), 0, 0)
        setRotation(self.cameraMainBaseNode, 0, math.rad(180), 0)

        for id, part in pairs (self.parts) do
            if id == 1 then
                self:selectCurrentPart(part, id)
            end

            local _, y, _ = getTranslation(part.node)
            self.originalY[id] = y

            removeFromPhysics(part.node)
        end

        self.backUpCamera = getCamera()
        g_currentMission.player:setWalkingLock(true)
        self:registerActionEvents()

        setCamera(self.camera)

        self.enabled = true
    else
        self:reset()
    end

    return self.enabled
end

function APE_UniversalPlacement:confirmPositions(confirm)
    if confirm and self.target ~= nil then
        self:removeActionEvents()

        local valve = self.parts[1].node
        local vX, vY, vZ = getTranslation(valve)
        local _, vRY, _ = getRotation(valve)

        local spout = self.parts[2].node
        local sX, sY, sZ = getTranslation(spout)
        local _, sRY, _ = getRotation(spout)

        if g_server ~= nil then
            if self.target:setUniversalParts(vX, vY, vZ, vRY, sX, sY, sZ, sRY) then
                g_server:broadcastEvent(AnimalPenExtensionUniversalPartsEvent:new(self.target, vX, vY, vZ, vRY, sX, sY, sZ, sRY))
            end
        else
            g_client:getServerConnection():sendEvent(AnimalPenExtensionUniversalPartsEvent:new(self.target, vX, vY, vZ, vRY, sX, sY, sZ, sRY))
        end

        addToPhysics(valve)
        addToPhysics(spout)

        self:reset()

        if g_currentMission.player ~= nil then
            g_currentMission.player:setWalkingLock(false)
        end

        if self.backUpCamera ~= nil then
            setCamera(self.backUpCamera)
        else
            if g_currentMission.player ~= nil then
                setCamera(g_currentMission.player.cameraNode)
            end
        end

        link(getRootNode(), self.cameraMainBaseNode)
    end
end

function APE_UniversalPlacement:reset()
    self.enabled = false
    self.allowMovement = false

    if self.target ~= nil then
        self.target.waterPlacementActive = false
        self.target = nil
    end

    self.selectedPart = nil
    self.selectedPartId = 1

    self.parts = nil
    self.backUpCamera = nil
    self.selectedPartCamera = {}
end

function APE_UniversalPlacement:selectCurrentPart(part, id)
    self.allowMovementModifier = false

    if part ~= nil and id ~= nil then
        self.selectedPart = part
        self.selectedPartId = id
    else
        self.selectedPartId = self.selectedPartId + 1
        if self.selectedPartId > #self.parts then
            self.selectedPartId = 1
        end

        self.selectedPart = self.parts[self.selectedPartId]
    end

    local x, y, z = getTranslation(self.selectedPart.node)
    local rx, ry, rz = getRotation(self.selectedPart.node)

    self.lastInputValues.upDown = z
    self.lastInputValues.leftRight = x
    self.lastInputValues.raiseLower = y
    self.lastInputValues.rotate = ry

    self.modifierActive = false

    setTranslation(self.cameraMainBaseNode, x, y, z)

    local cam = self.selectedPartCamera[self.selectedPartId]
    rx, _, rz = getRotation(self.cameraMainBaseNode)

    if cam ~= nil then
        if cam.ry ~= nil then
            self.cameraStep = cam.cameraStep
            self.movementDirection = cam.movementDirection

            setRotation(self.cameraMainBaseNode, rx, cam.ry, rz)
        end
    else
        self.cameraStep = -2
        self.movementDirection = 1
        local startRy = math.rad(180)
        self.selectedPartCamera[self.selectedPartId] = {ry = startRy, cameraStep = -2, movementDirection = 1}

        setRotation(self.cameraMainBaseNode, rx, startRy, rz)
    end

    self.allowMovementModifier = true
end

function APE_UniversalPlacement:registerActionEvents()
    local _, actionEventId = g_inputBinding:registerActionEvent(InputAction.AXIS_LOOK_UPDOWN_VEHICLE, self, self.actionEventMoveZ, false, false, true, true, nil)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.AXIS_LOOK_LEFTRIGHT_VEHICLE, self, self.actionEventMoveX, false, false, true, true, nil)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.MOUSE_ALT_COMMAND2_BUTTON, self, self.actionEventRotate, false, false, true, true, nil)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.AXIS_PLACEMENT_ROTATE_CAMERA, self, self.actionEventRotateCameraX, false, false, true, true, nil)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.AXIS_PLACEMENT_CHANGE_HEIGHT, self, self.actionEventZoomCamera, false, false, true, true, nil)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.SNAP_PLACEABLE, self, self.actionEventFlipCamera, true, false, false, true, nil)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.MENU_ACCEPT, self, self.actionEventAccept, true, false, false, true, nil)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.MOUSE_ALT_COMMAND_BUTTON, self, self.actionEventMovmentModifier, false, false, true, true, nil)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.SWITCH_IMPLEMENT, self, self.actionEventNextPart, true, false, false, true, nil)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.MENU_CANCEL, self, self.actionEventCancel, true, false, false, true, nil)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.CAMERA_ZOOM_IN, self, self.actionEventMoveY, false, false, true, true, 1)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.CAMERA_ZOOM_OUT, self, self.actionEventMoveY, false, false, true, true, -1)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)

    g_currentMission.hud:addCustomInputHelpEntry(InputAction.MENU_ACCEPT, nil, g_i18n:getText("button_confirm"), true)
    g_currentMission.hud:addCustomInputHelpEntry(InputAction.MENU_CANCEL, nil, g_i18n:getText("button_cancel"), true)
    g_currentMission.hud:addCustomInputHelpEntry(InputAction.SWITCH_IMPLEMENT, nil, g_i18n:getText("button_select"), true)
    g_currentMission.hud:addCustomInputHelpEntry(InputAction.MOUSE_ALT_COMMAND_BUTTON, nil, g_i18n:getText("ui_movePlaceable"), true)
    g_currentMission.hud:addCustomInputHelpEntry(InputAction.MOUSE_ALT_COMMAND2_BUTTON, nil, g_i18n:getText("action_rotate"), true)
    g_currentMission.hud:addCustomInputHelpEntry(InputAction.CAMERA_ZOOM_IN, nil, g_i18n:getText("action_changePlacementHeight"), true)
    g_currentMission.hud:addCustomInputHelpEntry(InputAction.SNAP_PLACEABLE, nil, g_i18n:getText("input_CAMERA_SWITCH"), true)
    g_currentMission.hud:addCustomInputHelpEntry(InputAction.AXIS_PLACEMENT_ROTATE_CAMERA, nil, g_i18n:getText("action_rotateCamera"), true)
    g_currentMission.hud:addCustomInputHelpEntry(InputAction.AXIS_PLACEMENT_CHANGE_HEIGHT, nil, g_i18n:getText("action_cameraZoom"), true)

end

function APE_UniversalPlacement:removeActionEvents(isForced)
    g_inputBinding:removeActionEventsByTarget(self)

    if isForced == nil or isForced == false then
        g_currentMission.hud:clearCustomInputHelpEntries()
    else
        local inputHelp = g_currentMission.hud.inputHelp
        if inputHelp ~= nil and inputHelp.customHelpElements ~= nil then
            if inputHelp.customHelpElements[Player.INPUT_CONTEXT_NAME] ~= nil then
                inputHelp.customHelpElements[Player.INPUT_CONTEXT_NAME] = nil
            end
        end
    end
end

function APE_UniversalPlacement:getPositionIsValid()
    if self.parts == nil or self.parts[1] == nil then
        return false
    end

    local x, y, z = getWorldTranslation(self.parts[1].node)
    local _, rotY, _ = getRotation(self.parts[1].node)

    self.positionValid = true
    self.animalLoadingTrigger = nil

    local animalsModule = self.target.owner:getModuleByName("animals")
    if animalsModule ~= nil then
        self.animalLoadingTrigger = animalsModule.animalLoadingTrigger.triggerNode
    end

    if self.animalLoadingTrigger ~= nil then
        local n = overlapBox(x, y, z, 0, rotY, 0, 1.5, 3, 1.5, "objectOverlapCallback", self, nil, true, true, true)
    end

    return self.positionValid
end

function APE_UniversalPlacement:objectOverlapCallback(transformId)
    if transformId == self.animalLoadingTrigger then
        self.positionValid = false
    end
end

function APE_UniversalPlacement:draw()
    if self.selectedPart == nil or self.selectedPart.node == nil then
        return
    end

    if self.selectedPartId == 1 and not self:getPositionIsValid() then
        local text = g_i18n:getText("warning_placeable_error_spawnPlace")
        g_currentMission:addExtraPrintText(text)
        g_currentMission:showBlinkingWarning(text, 1000)
    end

    local _, rotY, _ = getRotation(self.selectedPart.node)
    g_currentMission:addExtraPrintText("Rotation: " .. string.format(g_i18n:getText("setting_fovyDegree"), math.deg(rotY)))

    local _, y, _ = getTranslation(self.selectedPart.node)
    g_currentMission:addExtraPrintText(string.format("Height: %.2f  ( Default: %.2f )", y, self.originalY[self.selectedPartId]))
end

function APE_UniversalPlacement:actionEventMovmentModifier(actionName, inputValue, callbackState, isAnalog, isMouse)
    self.allowMovement = self.allowMovementModifier and inputValue > 0
end

function APE_UniversalPlacement:actionEventAccept(actionName, inputValue, callbackState, isAnalog, isMouse)
    if self:getPositionIsValid() then
        local title = g_i18n:getText("button_confirm")

        local text = "Are you sure you want to save these part positions? This action can not be undone!"
        if g_i18n:hasText("animalPenExtension_universalConfirm") then
            text = g_i18n:getText("animalPenExtension_universalConfirm")
        end

        g_gui:showYesNoDialog({text = text, title = title, callback = self.confirmPositions, target = self})
    else
        g_currentMission:showBlinkingWarning(g_i18n:getText("warning_placeable_error_spawnPlace") .. " (VALVE)", 2000)
    end
end

function APE_UniversalPlacement:actionEventRotateCameraX(actionName, inputValue, callbackState, isAnalog, isMouse)
    if self.cameraBaseNode == nil then
        return
    end

    local rx, ry, rz = getRotation(self.cameraBaseNode)
    inputValue = -inputValue * 0.001 * g_currentDt
    setRotation(self.cameraBaseNode, MathUtil.clamp(rx + inputValue, 0.6, 1.56), ry, rz)
end

function APE_UniversalPlacement:actionEventFlipCamera(actionName, inputValue, callbackState, isAnalog, isMouse)
    if self.cameraMainBaseNode == nil then
        return
    end

    local rx, ry, rz = getRotation(self.cameraMainBaseNode)

    self.cameraStep = self.cameraStep - 1

    self.movementDirection = -1
    if self.cameraStep == -2 then
        self.movementDirection = 1
    elseif self.cameraStep < -3 then
        self.cameraStep = 0
    end

    ry = (math.pi / 2) * self.cameraStep

    local selectedCam = self.selectedPartCamera[self.selectedPartId]
    selectedCam.ry = ry
    selectedCam.cameraStep = self.cameraStep
    selectedCam.movementDirection = self.movementDirection

    setRotation(self.cameraMainBaseNode, rx, ry, rz)
end

function APE_UniversalPlacement:actionEventZoomCamera(actionName, inputValue, callbackState, isAnalog, isMouse)
    if self.camera == nil then
        return
    end

    local x, y, z = getTranslation(self.camera)
    inputValue = -inputValue * 0.001 * g_currentDt

    setTranslation(self.camera, x, y, MathUtil.clamp(z + inputValue, -18.0, -3.0))
end

function APE_UniversalPlacement:actionEventRotate(actionName, inputValue, callbackState, isAnalog, isMouse)
    self.modifierActive = inputValue > 0
end

function APE_UniversalPlacement:actionEventMoveY(actionName, inputValue, callbackState, isAnalog, isMouse)
    if self.selectedPart == nil or self.selectedPart.node == nil or not self.allowMovementModifier then
        return
    end

    if not self.modifierActive then
        if isMouse then
            inputValue = (inputValue * 0.001 * 16.666) * callbackState
        else
            inputValue = (inputValue * 0.001 * g_currentDt) * callbackState
        end

        self.lastInputValues.raiseLower = self.lastInputValues.raiseLower + inputValue

        local _, y, _ = getTranslation(self.selectedPart.node)
        setTranslation(self.selectedPart.node, self.lastInputValues.leftRight, self.lastInputValues.raiseLower, self.lastInputValues.upDown)
        setTranslation(self.cameraMainBaseNode, self.lastInputValues.leftRight, y, self.lastInputValues.upDown)
    end
end

function APE_UniversalPlacement:actionEventMoveZ(actionName, inputValue, callbackState, isAnalog, isMouse)
    if self.selectedPart == nil or self.selectedPart.node == nil or not self.allowMovement then
        return
    end

    if not self.modifierActive then
        if isMouse then
            inputValue = (inputValue * 0.001 * 16.666) * self.movementDirection
        else
            inputValue = (inputValue * 0.001 * g_currentDt) * self.movementDirection
        end

        if (self.cameraStep == -1) or (self.cameraStep == -3) then
            if self.cameraStep == -1 then
                inputValue = -inputValue
            end

            self.lastInputValues.leftRight = self.lastInputValues.leftRight + inputValue
        else
            self.lastInputValues.upDown = self.lastInputValues.upDown + inputValue
        end

        local _, y, _ = getTranslation(self.selectedPart.node)
        setTranslation(self.selectedPart.node, self.lastInputValues.leftRight, self.lastInputValues.raiseLower, self.lastInputValues.upDown)
        setTranslation(self.cameraMainBaseNode, self.lastInputValues.leftRight, y, self.lastInputValues.upDown)
    end
end

function APE_UniversalPlacement:actionEventMoveX(actionName, inputValue, callbackState, isAnalog, isMouse)
    if self.selectedPart == nil or self.selectedPart.node == nil then
        return
    end

    if isMouse then
        inputValue = (inputValue * 0.001 * 16.666) * self.movementDirection
    else
        inputValue = (inputValue * 0.001 * g_currentDt) * self.movementDirection
    end

    if self.modifierActive then
        self.lastInputValues.rotate = self.lastInputValues.rotate + inputValue

        local rx, _, rz = getRotation(self.selectedPart.node)
        setRotation(self.selectedPart.node, rx, self.lastInputValues.rotate, rz)
    elseif self.allowMovement then
        if (self.cameraStep == -1) or (self.cameraStep == -3) then
            if self.cameraStep == -3 then
                inputValue = -inputValue
            end

            self.lastInputValues.upDown = self.lastInputValues.upDown + inputValue
        else
            self.lastInputValues.leftRight = self.lastInputValues.leftRight + inputValue
        end

        setTranslation(self.selectedPart.node, self.lastInputValues.leftRight, self.lastInputValues.raiseLower, self.lastInputValues.upDown)
    end
end

function APE_UniversalPlacement:actionEventNextPart(actionName, inputValue, callbackState, isAnalog, isMouse)
    if not self.allowMovementModifier then
        return
    end

    self:selectCurrentPart()
end

function APE_UniversalPlacement:actionEventCancel(actionName, inputValue, callbackState, isAnalog, isMouse)
    self:cancelOrDelete(false, false)
end

function APE_UniversalPlacement:cancelOrDelete(isDelete, isForced)
    self:removeActionEvents(isForced)

    self.allowMovementModifier = false

    if self.parts ~= nil then
        for id, part in pairs (self.parts) do
            setTranslation(part.node, 0, self.originalY[id], 0)
            setRotation(part.node, 0, 0, 0)
            addToPhysics(part.node)
        end
    end

    local player = g_currentMission.player
    if player ~= nil then
        player:setWalkingLock(false)
    end

    if isForced == nil or isForced == false then
        if self.backUpCamera ~= nil then
            setCamera(self.backUpCamera)
        elseif player ~= nil then
            setCamera(player.cameraNode)
        end
    end

    self:reset()

    if not isDelete and self.cameraMainBaseNode ~= nil then
        link(getRootNode(), self.cameraMainBaseNode)
    end
end
