--[[
Interface: 1.3.0.1 b4007

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 09.12.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 0.1.0.0 @ 09.12.2018 - Internal Beta
V 0.1.1.0 @ 17.02.2019 - Test Version
V 1.0.0.0 @ 02.05.2019 - Release Version

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


APE_ConsoleCommands = {}
g_animalPenExtensionManager.consoleCommands = APE_ConsoleCommands

function APE_ConsoleCommands:load()
    if g_animalPenExtensionManager == nil then
        return
    end

    if g_currentMission:getIsServer() then
        -- These are server only commands for hosted games or SP only.
        -- It is basically for testing so no need to add to dedicated server MP.
        addConsoleCommand("apeSetRandomDelay", "Activate or deactivate a Milk Sale random delay", "consoleCommandSetRandomDelay", g_animalPenExtensionManager.consoleCommands)
        addConsoleCommand("apeSetRandomDelayPercent", "Set the random delay percent factor", "consoleCommandSetRandomDelayPercent", g_animalPenExtensionManager.consoleCommands)
    end

    -- Client or Server: This lets you check current settings or states.
    addConsoleCommand("apeGetCurrentState", "Print the current state of the 'AnimalPenExtensionManager'. Option: [true] If 'true' the this information will be also printed to the log file.", "consoleCommandGetCurrentState", g_animalPenExtensionManager.consoleCommands)
end

function APE_ConsoleCommands:delete()
    if g_currentMission:getIsServer() then
        removeConsoleCommand("apeSetRandomDelay")
        removeConsoleCommand("apeSetRandomDelayPercent")
    end

    removeConsoleCommand("apeGetCurrentState")
end

function APE_ConsoleCommands:consoleCommandGetCurrentState(doPrint)
    local manager = g_animalPenExtensionManager

    local scale = '\n'
    local waterPriceActive = manager.waterPriceScaleOverride > -1
    if waterPriceActive then
        scale = '  |  Scale Set = ' .. tostring(manager.waterPriceScaleOverride) .. '\n'
    end

    local price = '\n\n'
    local maintenanceActive = manager.maintenancePerDayOverride > -1
    if maintenanceActive then
        price = '  |  Price Set = ' .. tostring(manager.maintenancePerDayOverride) .. '\n\n'
    end

    local info = '\n- Animal Pen Extension Manager - Version ' .. AnimalPenExtensionManager.versionString .. ' -\n\n' ..
        'Settings:\n    Water Addon:  Active = ' .. tostring(manager.waterAddonActive) .. '\n        - Purchase Override: Active = ' .. tostring(manager.purchaseOverride) .. '\n' ..
        '        - Water Price Override:  Active = ' .. tostring(waterPriceActive) .. scale ..
        '        - Maintenance Price Override:  Active = ' .. tostring(maintenanceActive) ..  price ..
        '    Milk Addon:  Active = ' .. tostring(manager.milkAddonActive) .. '\n\n' ..
        '    Chicken Addon:  Active = ' .. tostring(manager.chickenAddonActive) .. '\n\n' ..
        'Save Game:\n    Milk Addon:\n' ..
        '        - Random Delay:  Active = ' .. tostring(manager.randomDelayActive) .. '  |  Chance Of Delay = ' .. tostring(manager.chanceOfDelay) .. '%  |  Text ID = ' .. tostring(manager.delayTextId) .. '\n\n'

    if doPrint ~= nil and doPrint:lower() == "true" then
        print(info)
    else
        return info
    end

    return
end

function APE_ConsoleCommands:consoleCommandSetRandomDelay()
    if not g_currentMission:getIsServer() then
        return "AnimalPenExtension: 'consoleCommandSetRandomDelay' is a SERVER only command!"
    end

    if g_animalPenExtensionManager.randomDelayActive then
        g_animalPenExtensionManager:setDelayData(false, g_animalPenExtensionManager:getRandomTextId(), true, true)
        return "AnimalPenExtension: (Milk Addon) Random Delay Deactivated!"
    else
        g_animalPenExtensionManager:setDelayData(true, g_animalPenExtensionManager:getRandomTextId(), true, true)
        return "AnimalPenExtension: (Milk Addon) Random Delay Activated!"
    end
end

function APE_ConsoleCommands:consoleCommandSetRandomDelayPercent(value)
    if not g_currentMission:getIsServer() then
        return "AnimalPenExtension: 'consoleCommandSetRandomDelayPercent' is a SERVER only command!"
    end

    local percent = tonumber(value)
    if percent == nil then
        g_animalPenExtensionManager.chanceOfDelay = 25

        return "AnimalPenExtension: (Milk Addon) No percent value given! Chance of Random Delay updated to 25%."
    else
        g_animalPenExtensionManager.chanceOfDelay = math.floor(math.max(math.min(percent, 100), 0))

        return "AnimalPenExtension: (Milk Addon) Chance of Random Delay updated to " .. tostring(g_animalPenExtensionManager.chanceOfDelay) .. "%."
    end
end
