--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 09.12.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 0.1.0.0 @ 09.12.2018 - Internal Beta
V 0.1.1.0 @ 17.02.2019 - Test Version
V 1.0.0.0 @ 02.05.2019 - Release Version
V 1.1.0.0 @ 17.07.2019 - Add support to position 'waterAddon' parts on unsupported mods.

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


APE_ChangedFunctions = {}
APE_ChangedFunctions.LOADED = false

g_animalPenExtensionManager.changedFunctions = APE_ChangedFunctions

function APE_ChangedFunctions.initFunctions()
    if not APE_ChangedFunctions.LOADED then
        APE_ChangedFunctions.LOADED = true

        FSBaseMission.loadMapFinished = Utils.prependedFunction(FSBaseMission.loadMapFinished, APE_ChangedFunctions.loadMapFinished)
        FSBaseMission.delete = Utils.appendedFunction(FSBaseMission.delete, APE_ChangedFunctions.delete)
        FSCareerMissionInfo.saveToXMLFile = Utils.appendedFunction(FSCareerMissionInfo.saveToXMLFile, APE_ChangedFunctions.saveToXMLFile)
        Server.sendObjects = Utils.prependedFunction(Server.sendObjects, APE_ChangedFunctions.sendObjects)
    end
end

function APE_ChangedFunctions:loadMapFinished()
    if g_animalPenExtensionManager ~= nil then
        if g_animalPenExtensionManager:load() then
            AnimalHusbandry.load = Utils.overwrittenFunction(AnimalHusbandry.load, APE_ChangedFunctions.husbandryLoad)
            AnimalHusbandry.delete = Utils.prependedFunction(AnimalHusbandry.delete, APE_ChangedFunctions.husbandryDelete)

            AnimalHusbandry.saveToXMLFile = Utils.appendedFunction(AnimalHusbandry.saveToXMLFile, APE_ChangedFunctions.husbandrySaveToXMLFile)
            AnimalHusbandry.setOwnerFarmId = Utils.appendedFunction(AnimalHusbandry.setOwnerFarmId, APE_ChangedFunctions.husbandrySetOwnerFarmId)
            AnimalHusbandry.loadFromXMLFile = Utils.overwrittenFunction(AnimalHusbandry.loadFromXMLFile, APE_ChangedFunctions.husbandryLoadFromXMLFile)

            AnimalHusbandry.readStream = Utils.appendedFunction(AnimalHusbandry.readStream, APE_ChangedFunctions.husbandryReadStream)
            AnimalHusbandry.writeStream = Utils.appendedFunction(AnimalHusbandry.writeStream, APE_ChangedFunctions.husbandryWriteStream)
        end
    end
end

function APE_ChangedFunctions:delete()
    if g_animalPenExtensionManager ~= nil then
        g_animalPenExtensionManager:finalDelete()
    end
end

function APE_ChangedFunctions:saveToXMLFile()
    if g_animalPenExtensionManager ~= nil then
        if self.isValid then
            g_animalPenExtensionManager:saveToXMLFile(self.savegameDirectory .. "/animalPenExtension.xml")
        end
    end
end

function APE_ChangedFunctions:sendObjects(connection, x, y, z, viewDistanceCoeff)
    if g_animalPenExtensionManager ~= nil then
        g_animalPenExtensionManager:syncSettings(connection)
    end
end

function APE_ChangedFunctions:husbandryLoad(superFunc, xmlFilename, x, y, z, rx, ry, rz, initRandom)
    if not superFunc(self, xmlFilename, x, y, z, rx, ry, rz, initRandom) then
        return false
    end

    if g_animalPenExtensionManager ~= nil then
        local manager = g_animalPenExtensionManager
        local isMod = true
        local key = "placeable.animalPenExtension"

        if self.customEnvironment == nil or self.customEnvironment == "" then
            local i3dFilenameLower = self.i3dFilename:lower()
            key = manager.baseBuildings[i3dFilenameLower]
            if key ~= nil then
                isMod = false
                xmlFilename = manager.baseBuildingsXMLFilename
            else
                key = "placeable.animalPenExtension"
            end
        end

        local xmlFile = loadXMLFile("TempXML", xmlFilename)
        if xmlFile ~= nil and xmlFile ~= 0 then
            if hasXMLProperty(xmlFile, key) then
                local extension = manager.animalPenExtension:new(self.isServer, self.isClient)
                extension:setOwnerFarmId(self:getOwnerFarmId(), false)
                if extension:load(self, xmlFile, key, isMod, false, manager.baseDirectory, manager.texts) then
                    extension:register(true)
                    self.animalPenExtension = extension
                else
                    extension:delete()
                    extension = nil
                end
            else
                delete(xmlFile)

                if self.modulesByName["water"] ~= nil then
                    xmlFile = loadXMLFile("TempUniversalXML", g_animalPenExtensionManager.universalPartsXMLFilename)
                    if xmlFile ~= nil and xmlFile ~= 0 then
                        local extension = manager.animalPenExtension:new(self.isServer, self.isClient)
                        extension:setOwnerFarmId(self:getOwnerFarmId(), false)
                        if extension:load(self, xmlFile, "animalPenExtension.universalParts", false, true, manager.baseDirectory, manager.texts) then
                            extension:register(true)
                            self.animalPenExtension = extension
                        else
                            extension:delete()
                            extension = nil
                        end

                        delete(xmlFile)
                    end
                end
            end
        end
    end

    return true
end

function APE_ChangedFunctions:husbandrySetOwnerFarmId(farmId, noEventSend)
    if self.animalPenExtension ~= nil then
        self.animalPenExtension:setOwnerFarmId(farmId, noEventSend)
    end
end

function APE_ChangedFunctions:husbandryDelete()
    if self.animalPenExtension ~= nil then
        self.animalPenExtension:delete()
        self.animalPenExtension = nil
    end
end

function APE_ChangedFunctions:husbandryReadStream(streamId, connection)
    if self.animalPenExtension ~= nil then
        if connection:getIsServer() then
            self.animalPenExtension:readStream(streamId, connection)
        end
    end
end

function APE_ChangedFunctions:husbandryWriteStream(streamId, connection)
    if self.animalPenExtension ~= nil then
        if not connection:getIsServer() then
            self.animalPenExtension:writeStream(streamId, connection)
        end
    end
end

function APE_ChangedFunctions:husbandrySaveToXMLFile(xmlFile, key, usedModNames)
    if self.animalPenExtension ~= nil then
        self.animalPenExtension:saveToXMLFile(xmlFile, key .. ".animalPenExtension", usedModNames)
    end
end

function APE_ChangedFunctions:husbandryLoadFromXMLFile(superFunc, xmlFile, key)
    if superFunc(self, xmlFile, key) then
        if self.animalPenExtension ~= nil then
            return self.animalPenExtension:loadFromXMLFile(xmlFile, key .. ".animalPenExtension")
        end

        return true
    end

    return false
end
