--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 17.07.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 17.07.2019 - Release Version

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


AnimalPenExtensionUniversalPartsEvent = {}
AnimalPenExtensionUniversalPartsEvent_mt = Class(AnimalPenExtensionUniversalPartsEvent, Event)
InitEventClass(AnimalPenExtensionUniversalPartsEvent, "AnimalPenExtensionUniversalPartsEvent")

function AnimalPenExtensionUniversalPartsEvent:emptyNew()
    local self = Event:new(AnimalPenExtensionUniversalPartsEvent_mt)
    return self
end

function AnimalPenExtensionUniversalPartsEvent:new(animalPen, vX, vY, vZ, vRY, sX, sY, sZ, sRY)
    local self = AnimalPenExtensionUniversalPartsEvent:emptyNew()
    self.animalPen = animalPen

    self.vX = vX
    self.vY = vY
    self.vZ = vZ
    self.vRY = vRY

    self.sX = sX
    self.sY = sY
    self.sZ = sZ
    self.sRY = sRY

    return self
end

function AnimalPenExtensionUniversalPartsEvent:readStream(streamId, connection)
    local animalPen = NetworkUtil.readNodeObject(streamId)

    local vX = streamReadFloat32(streamId)
    local vY = streamReadFloat32(streamId)
    local vZ = streamReadFloat32(streamId)
    local vRY = NetworkUtil.readCompressedAngle(streamId)

    local sX = streamReadFloat32(streamId)
    local sY = streamReadFloat32(streamId)
    local sZ = streamReadFloat32(streamId)
    local sRY = NetworkUtil.readCompressedAngle(streamId)

    if animalPen ~= nil then
        if animalPen:setUniversalParts(vX, vY, vZ, vRY, sX, sY, sZ, sRY) and g_server ~= nil then
            g_server:broadcastEvent(AnimalPenExtensionUniversalPartsEvent:new(animalPen, vX, vY, vZ, vRY, sX, sY, sZ, sRY))
        end
    end
end

function AnimalPenExtensionUniversalPartsEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.animalPen)

    streamWriteFloat32(streamId, self.vX)
    streamWriteFloat32(streamId, self.vY)
    streamWriteFloat32(streamId, self.vZ)
    NetworkUtil.writeCompressedAngle(streamId, self.vRY)

    streamWriteFloat32(streamId, self.sX)
    streamWriteFloat32(streamId, self.sY)
    streamWriteFloat32(streamId, self.sZ)
    NetworkUtil.writeCompressedAngle(streamId, self.sRY)
end

function AnimalPenExtensionUniversalPartsEvent:run(connection)
    print("'AnimalPenExtensionUniversalPartsEvent' is not allowed to be executed on a local client.")
end
