--[[
Interface: 1.4.1.0 b5334

Author: GtX | Andy
Date: 02.02.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 02.02.2019 - Release Version

About:
Simple loader script for placeables. This saves having 2 or 3 loader scripts in maps or mods for custom scripts.
Unfortunately not supported in modDesc as it should be, but now it is. ;-)

Example:

<modDesc>
    <placeables>
        <placeable typeName="myPlaceable" className="MyPlaceableClass" filename="scripts/MyPlaceableScript.lua"/>
    </placeables>
</modDesc>
]]


PlaceableLoader = {}

local modName = g_currentModName
local modDirectory = g_currentModDirectory

function PlaceableLoader.init()
    PlaceableLoader.loaded = {}

    local xmlFile = loadXMLFile("modDesc_placeableLoader", modDirectory .. "modDesc.xml")
    if xmlFile ~= 0 then

        local i = 0
        while true do
            local key = string.format("modDesc.placeables.placeable(%d)", i)
            if not hasXMLProperty(xmlFile, key) then
                break
            end

            local isValid = true

            local typeName = getXMLString(xmlFile, key .. "#typeName")
            if typeName == nil then
                isValid = PlaceableLoader.errorPrint("typeName", modName, key)
            end

            local className = getXMLString(xmlFile, key .. "#className")
            if className == nil then
                isValid = PlaceableLoader.errorPrint("className", modName, key)
            end

            local filename = getXMLString(xmlFile, key .. "#filename")
            if filename == nil then
                isValid = PlaceableLoader.errorPrint("filename", modName, key)
            end

            if isValid and not PlaceableLoader.loaded[typeName] then
                local placeablePath = modDirectory .. filename

                if fileExists(placeablePath) then
                    g_placeableTypeManager:addPlaceableType(typeName, className, placeablePath)

                    PlaceableLoader.loaded[typeName] = true
                else
                    print(string.format("  Error: [%s] File %s could not be found!", modName, placeablePath))
                end
            end

            i = i + 1
        end

        delete(xmlFile)
        xmlFile = nil
    end
end

function PlaceableLoader.errorPrint(name, modName, key)
    print(string.format("  Error: [%s] Missing '%s' at %s. Placeable will not be added!", modName, name, key))
    return false
end

PlaceableLoader.init()
