-- author: DD ModPassion
-- date: 04.10.2019
-- copyright (C): DD ModPassion, All Rights Reserved
-- version: farming simulator 19
TrailerAddon = {} TrailerAddon.modDir = g_currentModDirectory TrailerAddon.MOD_NAME = g_currentModName function TrailerAddon.prerequisitesPresent(specializations) return true end function TrailerAddon.registerFunctions(vehicleType) SpecializationUtil.registerFunction(vehicleType, "setLimiteRetromarcia", TrailerAddon.setLimiteRetromarcia) end function TrailerAddon.registerEventListeners(vehicleType) SpecializationUtil.registerEventListener(vehicleType, "onLoad", TrailerAddon) SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", TrailerAddon) SpecializationUtil.registerEventListener(vehicleType, "onReadStream", TrailerAddon) SpecializationUtil.registerEventListener(vehicleType, "onWriteStream", TrailerAddon) SpecializationUtil.registerEventListener(vehicleType, "onUpdate", TrailerAddon) SpecializationUtil.registerEventListener(vehicleType, "onUpdateTick", TrailerAddon) SpecializationUtil.registerEventListener(vehicleType, "onDraw", TrailerAddon) SpecializationUtil.registerEventListener(vehicleType, "onPostAttach", TrailerAddon) SpecializationUtil.registerEventListener(vehicleType, "onPreDetach", TrailerAddon) SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", TrailerAddon) end function TrailerAddon:onLoad(savegame) self.spec_trailerAddon = self[string.format("spec_%s.trailerAddon", TrailerAddon.MOD_NAME)] local spec = self.spec_trailerAddon spec.attacherVehicle = nil spec.maxBackwardSpeedBackup = 0 spec.limiteRetromarciaEvent = "" spec.limiteRetromarcia = 4 spec.limiteRetromarciaZero = 0 spec.emptySpeedBackup = 0 spec.emptySpeedChange = 6 spec.movingDirectionBackup = 0 end function TrailerAddon:onPostLoad(savegame) local spec = self.spec_trailerAddon spec.maxBackwardSpeedBackup = 0 self:setLimiteRetromarcia(spec.limiteRetromarcia, spec.emptySpeedChange, true) end function TrailerAddon:onReadStream(streamId, connection) if connection:getIsServer() then local limiteRetromarcia = streamReadInt8(streamId) local emptySpeedChange = streamReadInt8(streamId) self:setLimiteRetromarcia(limiteRetromarcia, emptySpeedChange, true) end end function TrailerAddon:onWriteStream(streamId, connection) if not connection:getIsServer() then local spec = self.spec_trailerAddon streamWriteInt8(streamId, spec.limiteRetromarcia) streamWriteInt8(streamId, spec.emptySpeedChange) end end function TrailerAddon:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected) local spec = self.spec_trailerAddon if spec.attacherVehicle ~= nil then local specDischargeable = self.spec_dischargeable if specDischargeable ~= nil then if self.movingDirection < 0 and spec.attacherVehicle.movingDirection < 0 and specDischargeable.currentDischargeState == 0 then spec.attacherVehicle:getMotor().maxBackwardSpeed = spec.limiteRetromarcia/3.6 elseif specDischargeable.currentDischargeState > 0 then spec.attacherVehicle:getMotor().maxBackwardSpeed = 0 if self:getAnimationTime("sponda") < 1 then specDischargeable.currentDischargeNode.emptySpeed = spec.emptySpeedBackup*(1-self:getAnimationTime("sponda")*0.9) else if spec.movingDirectionBackup > self.movingDirection then specDischargeable.currentDischargeNode.emptySpeed = spec.emptySpeedBackup*spec.emptySpeedChange elseif specDischargeable.currentDischargeNode.emptySpeed > spec.emptySpeedBackup*self:getAnimationTime("tipAnimationBack") then specDischargeable.currentDischargeNode.emptySpeed = specDischargeable.currentDischargeNode.emptySpeed-spec.emptySpeedChange/3 else specDischargeable.currentDischargeNode.emptySpeed = spec.emptySpeedBackup*self:getAnimationTime("tipAnimationBack") end end spec.movingDirectionBackup = self.movingDirection else specDischargeable.currentDischargeNode.emptySpeed = spec.emptySpeedBackup end elseif self.movingDirection < 0 and spec.attacherVehicle.movingDirection < 0 then spec.attacherVehicle:getMotor().maxBackwardSpeed = spec.limiteRetromarcia/3.6 else spec.attacherVehicle:getMotor().maxBackwardSpeed = spec.maxBackwardSpeedBackup end end end function TrailerAddon:onUpdateTick(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected) local spec = self.spec_trailerAddon local specDischargeable = self.spec_dischargeable if spec.attacherVehicle ~= nil and specDischargeable ~= nil then if self.isClient then TrailerAddon.updateActionEvents(self) end local nameFillType = Utils.getNoNil(g_fillTypeManager:getFillTypeNameByIndex(self:getDischargeFillType(specDischargeable.currentDischargeNode)), "unknown") if nameFillType == "CHAFF" or nameFillType == "DRYGRASS" or nameFillType == "GRASS" or nameFillType == "MANURE" or nameFillType == "POTATO" or nameFillType == "SILAGE" or nameFillType == "STRAW" or nameFillType == "SUGARBEET" or nameFillType == "WOODCHIPS" then spec.emptySpeedChange = 12*self:getAnimationTime("tipAnimationBack") else spec.emptySpeedChange = 6*self:getAnimationTime("tipAnimationBack") end self:setLimiteRetromarcia(spec.limiteRetromarcia, spec.emptySpeedChange) end end function TrailerAddon:onDraw(isActiveForInput, isActiveForInputIgnoreSelection, isSelected) local spec = self.spec_trailerAddon if spec.limiteRetromarciaEvent ~= nil then local specDischargeable = self.spec_dischargeable if specDischargeable ~= nil then if specDischargeable.currentDischargeState > 0 then g_currentMission:addExtraPrintText(string.format(g_i18n:getText("limiteRetro")..": "..spec.limiteRetromarciaZero.." "..g_i18n:getText("unit_kmh"))) end end end end function TrailerAddon:onPostAttach(attacherVehicle, inputJointDescIndex, jointDescIndex) local spec = self.spec_trailerAddon spec.attacherVehicle = self:getRootVehicle() if spec.attacherVehicle ~= nil then spec.maxBackwardSpeedBackup = spec.attacherVehicle:getMotor().maxBackwardSpeed else spec.attacherVehicle = nil end local specDischargeable = self.spec_dischargeable if specDischargeable ~= nil then spec.emptySpeedBackup = specDischargeable.currentDischargeNode.emptySpeed end end function TrailerAddon:onPreDetach(attacherVehicle, implement) local spec = self.spec_trailerAddon if spec.attacherVehicle ~= nil then spec.attacherVehicle:getMotor().maxBackwardSpeed = spec.maxBackwardSpeedBackup spec.maxBackwardSpeedBackup = 0 spec.attacherVehicle = nil local specDischargeable = self.spec_dischargeable if specDischargeable ~= nil then specDischargeable.currentDischargeNode.emptySpeed = spec.emptySpeedBackup end end end function TrailerAddon:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection) if self.isClient then local spec = self.spec_trailerAddon spec.limiteRetromarciaEvent = nil self:clearActionEventsTable(spec.actionEvents) if isActiveForInput then local specDischargeable = self.spec_dischargeable if specDischargeable ~= nil then if specDischargeable.currentDischargeState > 0 then g_inputBinding:setActionEventActive(spec.limiteRetromarciaEvent, false) else local _, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.TRAILER_CONTROL, self, TrailerAddon.actionEventCruise, false, true, false, true, nil) g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH) local text = string.format(g_i18n:getText("action_changeCruiseControlLevel")..": "..spec.limiteRetromarcia.." "..g_i18n:getText("unit_kmh")) spec.limiteRetromarciaEvent = actionEventId g_inputBinding:setActionEventActive(spec.limiteRetromarciaEvent, true) g_inputBinding:setActionEventText(spec.limiteRetromarciaEvent, text) end else local _, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.TRAILER_CONTROL, self, TrailerAddon.actionEventCruise, false, true, false, true, nil) g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH) local text = string.format(g_i18n:getText("action_changeCruiseControlLevel")..": "..spec.limiteRetromarcia.." "..g_i18n:getText("unit_kmh")) spec.limiteRetromarciaEvent = actionEventId g_inputBinding:setActionEventActive(spec.limiteRetromarciaEvent, true) g_inputBinding:setActionEventText(spec.limiteRetromarciaEvent, text) end end end end function TrailerAddon.actionEventCruise(self, actionName, inputValue, callbackState, isAnalog) local spec = self.spec_trailerAddon local limiteRetromarcia = math.floor(math.max(math.min(spec.maxBackwardSpeedBackup, spec.limiteRetromarcia+inputValue), 1)) local emptySpeedChange = spec.emptySpeedChange self:setLimiteRetromarcia(limiteRetromarcia, emptySpeedChange) end function TrailerAddon:setLimiteRetromarcia(limiteRetromarcia, emptySpeedChange, noEventSend) local spec = self.spec_trailerAddon SetLimiteRetromarciaEvent.sendEvent(self, limiteRetromarcia, emptySpeedChange, noEventSend) spec.limiteRetromarcia = limiteRetromarcia spec.emptySpeedChange = emptySpeedChange end function TrailerAddon.updateActionEvents(self) local spec = self.spec_trailerAddon if spec.limiteRetromarciaEvent ~= nil then local specDischargeable = self.spec_dischargeable if specDischargeable ~= nil then if specDischargeable.currentDischargeState > 0 then g_inputBinding:setActionEventActive(spec.limiteRetromarciaEvent, false) else local text = string.format(g_i18n:getText("action_changeCruiseControlLevel")..": "..spec.limiteRetromarcia.." "..g_i18n:getText("unit_kmh")) g_inputBinding:setActionEventActive(spec.limiteRetromarciaEvent, true) g_inputBinding:setActionEventText(spec.limiteRetromarciaEvent, text) end else local text = string.format(g_i18n:getText("action_changeCruiseControlLevel")..": "..spec.limiteRetromarcia.." "..g_i18n:getText("unit_kmh")) g_inputBinding:setActionEventActive(spec.limiteRetromarciaEvent, true) g_inputBinding:setActionEventText(spec.limiteRetromarciaEvent, text) end end end SetLimiteRetromarciaEvent = {} SetLimiteRetromarciaEvent_mt = Class(SetLimiteRetromarciaEvent, Event) InitEventClass(SetLimiteRetromarciaEvent, "SetLimiteRetromarciaEvent") function SetLimiteRetromarciaEvent:emptyNew() local self = Event:new(SetLimiteRetromarciaEvent_mt) return self end function SetLimiteRetromarciaEvent:new(object, limiteRetromarcia, emptySpeedChange) local self = SetLimiteRetromarciaEvent:emptyNew() self.object = object self.limiteRetromarcia = limiteRetromarcia self.emptySpeedChange = emptySpeedChange return self end function SetLimiteRetromarciaEvent:readStream(streamId, connection) self.object = NetworkUtil.readNodeObject(streamId) self.limiteRetromarcia = streamReadInt8(streamId) self.emptySpeedChange = streamReadInt8(streamId) self:run(connection) end function SetLimiteRetromarciaEvent:writeStream(streamId, connection) NetworkUtil.writeNodeObject(streamId, self.object) streamWriteInt8(streamId, self.limiteRetromarcia) streamWriteInt8(streamId, self.emptySpeedChange) end function SetLimiteRetromarciaEvent:run(connection) if not connection:getIsServer() then g_server:broadcastEvent(self, false, connection, self.object) end if self.object ~= nil then self.object:setLimiteRetromarcia(self.limiteRetromarcia, self.emptySpeedChange, true) end end function SetLimiteRetromarciaEvent.sendEvent(vehicle, limiteRetromarcia, emptySpeedChange, noEventSend) if limiteRetromarcia ~= vehicle.spec_trailerAddon.limiteRetromarcia or emptySpeedChange ~= vehicle.spec_trailerAddon.emptySpeedChange then if noEventSend == nil or noEventSend == false then if g_server ~= nil then g_server:broadcastEvent(SetLimiteRetromarciaEvent:new(vehicle, limiteRetromarcia, emptySpeedChange), nil, nil, vehicle) else g_client:getServerConnection():sendEvent(SetLimiteRetromarciaEvent:new(vehicle, limiteRetromarcia, emptySpeedChange)) end end end end