-- ToDi_Attachment
--
-- Version 1.1
-- Autor Ralf08
-- 
-- Change log:
-- V1.0 / 27.01.2019 / Ralf08 / first release -> replacment for LS17 FrontloaderDisplay
-- V1.1 / 17.03.2019 / Ralf08 / save to XML; synchronize in multiplayer; event for adjust to zero; on off; tool active deactive; fix for multiplayer onAttached changed to onActivate



--local FirstRun
ToDi_Attachment = {}
source(g_currentModDirectory .. "scripts/SetToDiZeroEvent.lua")


function ToDi_Attachment.prerequisitesPresent(specializations)
	-- print("ToDi_Attachment.prerequisitesPresent(specializations)")
	return true
end


function ToDi_Attachment.registerFunctions(vehicleType)
	-- print("ToDi_Attachment.registerFunctions")
    SpecializationUtil.registerFunction(vehicleType, "setToDiZero", ToDi_Attachment.setToDiZero)
end


function ToDi_Attachment.registerEventListeners(vehicleType)
	-- print("ToDi_Attachment.registerEventListeners(vehicleType)")
	for i, v in ipairs({"onLoad","onPostLoad","onActivate","onDeactivate","onUpdate","onRegisterActionEvents","saveToXMLFile","onReadStream","onWriteStream"}) do
		SpecializationUtil.registerEventListener(vehicleType, v, ToDi_Attachment)
	end
end


function ToDi_Attachment:onLoad()
	-- print("ToDi_Attachment:onLoad")
	-- print(self.typeName)
	self.ToDi = {}
	self.ToDi.corAngle = 0
	self.ToDi.corHeight = 0
	self.ToDi.active = true
	self.ToDi.latch = false
	self.ToDi.parentVehicle = self
	self.ToDi.xL = 0
	self.ToDi.yL = 0
	self.ToDi.zL = 0
	self.ToDi.dir = 1
	
	self.ToDi.node = self.rootNode
			

	--Dischargeable
	if SpecializationUtil.hasSpecialization(Dischargeable, self.specializations) then
		-- print("ToDi DISCHARGEABLE")
		if self.spec_dischargeable.currentDischargeNode.node ~= nil then
			-- print("ToDi currentDischargeNode")
			self.ToDi.node = self.spec_shovel.shovelDischargeInfo.node
		end
	end
	

	--stumpCutter
	if SpecializationUtil.hasSpecialization(StumpCutter, self.specializations) then
		-- print("ToDi stumpCutter")
		if self.i3dMappings.cutNdeRefFrame ~= nil then
			-- print("ToDi cutNdeRefFrame")
			self.ToDi.node = I3DUtil.indexToObject(self.components,self.i3dMappings.cutNdeRefFrame)
		elseif self.i3dMappings.cutNodeRefFrame ~= nil then
			-- print("ToDi cutNodeRefFrame")
			self.ToDi.node = I3DUtil.indexToObject(self.components,self.i3dMappings.cutNodeRefFrame)
		elseif self.i3dMappings.cutNode ~= nil then
			-- print("ToDi cutNode")
			self.ToDi.node = I3DUtil.indexToObject(self.components,self.i3dMappings.cutNode)
		end
	end

	--TreeSaw
	if SpecializationUtil.hasSpecialization(TreeSaw, self.specializations) then
		-- print("ToDi TREESAW")
		if self.spec_treeSaw.cutNode ~= nil then
			-- print("ToDi cutNode")
			self.ToDi.node = self.spec_treeSaw.cutNode
		end
	end
	
	local __,yX,__ = localDirectionToLocal(self.ToDi.node,self.components[1].node, 1, 0, 0)
	local __,yY,__ = localDirectionToLocal(self.ToDi.node,self.components[1].node, 0, 1, 0)
	local __,yZ,__ = localDirectionToLocal(self.ToDi.node,self.components[1].node, 0, 0, 1)
	
	yX = math.abs(yX) - 1
	yY = math.abs(yY) - 1
	yZ = math.abs(yZ) - 1
	
	if yX > yY and yX > yZ then
		-- print("xL")
		self.ToDi.xL = 1
	elseif yY > yX and yY > yZ then
		-- print("yL")
		self.ToDi.yL = 1
	elseif yZ > yX and yZ > yY then
		-- print("zL")
		self.ToDi.zL = 1
	else
		-- print("ToDi Error, standard configuration")
		self.ToDi.zL = 1
	end
end


function ToDi_Attachment:onPostLoad(savegame)
	-- print("ToDi_Attachment:onPostLoad")
	if savegame ~= nil then
		local xmlFile = savegame.xmlFile
		local key = savegame.key ..".ToDi_Attachment"
		
		self.ToDi.corAngle = Utils.getNoNil(getXMLInt(xmlFile, key.."#corAngle"),0)
		self.ToDi.corHeight = Utils.getNoNil(getXMLFloat(xmlFile, key.."#corHeight"),0)
		self.ToDi.active = Utils.getNoNil(getXMLBool(xmlFile, key.."#active"),true)
	end
end


function ToDi_Attachment:onUpdate(dt, isActiveForInput)
	if isActiveForInput and ToDi_Vehicle.ToDi_OnOff and self.ToDi.active and self.ToDi.parentVehicle ~= nil then
		-- -- print("ToDi_Attachment:onUpdate() "..self.typeName.." "..dt) end
		local x,y,z = localToLocal(self.ToDi.node,self.ToDi.parentVehicle.components[1].node, 0, 0, 0)
		local xD,yD,zD = localDirectionToLocal(self.ToDi.node,self.ToDi.parentVehicle.components[1].node, self.ToDi.xL, self.ToDi.yL, self.ToDi.zL)
						
		self.ToDi.parentVehicle.ToDi.ToDi_HoT = round((y + self.ToDi.corHeight)*100)/100
		self.ToDi.parentVehicle.ToDi.ToDi_ang = self.ToDi.dir * (round(math.deg(math.atan2(yD,zD))) - 90 + self.ToDi.corAngle)
				
		self.ToDi.parentVehicle.ToDi.show = true
		self.ToDi.latch = true
		
	elseif self.ToDi.latch and self.ToDi.parentVehicle ~= nil then	
		self.ToDi.parentVehicle.ToDi.show = false
		self.ToDi.latch = false
	end
end


function ToDi_Attachment:onActivate()
	-- print("ToDi_Attachment:onActivate")
	self.ToDi.parentVehicle = self:getRootVehicle()
	local __,__,z = localToLocal(self.ToDi.node,self.ToDi.parentVehicle.components[1].node, 0, 0, 0)
	if z > 0 then
		self.ToDi.dir = 1
	else
		self.ToDi.dir = -1
	end
end


function ToDi_Attachment:onDeactivate()
	-- print("ToDi_Attachment:onDeactivate")
	if self.ToDi.parentVehicle ~= nil and self.ToDi.parentVehicle.ToDi ~= nil then
		self.ToDi.parentVehicle.ToDi.show = false
	end
	self.ToDi.latch = false
	self.ToDi.parentVehicle = nil
	self.ToDi.dir = 1
end


function ToDi_Attachment:onRegisterActionEvents(isActiveForInputIgnoreSelection)
    -- print("ToDi_Attachment:onRegisterActionEvents")
	local spec = self.spec_ToDi_Attachment
	if self.isClient then
		self:clearActionEventsTable(spec.actionEvents)
		if isActiveForInputIgnoreSelection then
			local actionEventId
			_, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.ToDi_OnOff, self, ToDi_Attachment.actionEventOnOff, false, true, false, true, nil)
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_LOW)
			
			_, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.ToDi_SetHeight, self, ToDi_Attachment.actionEventSetHeight, false, true, false, true, nil)
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_LOW)
			
			_, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.ToDi_SetAngle, self, ToDi_Attachment.actionEventSetAngle, false, true, false, true, nil)
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_LOW)
			
			_, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.ToDi_Active, self, ToDi_Attachment.actionEventActive, false, true, false, true, nil)
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_LOW)

			_, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.ToDi_PLUS, self, ToDi_Attachment.actionEventPLUS, false, true, false, true, nil)
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW)
			
			_, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.ToDi_MINUS, self, ToDi_Attachment.actionEventMINUS, false, true, false, true, nil)
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW)
        end
	end
end


function ToDi_Attachment:saveToXMLFile(xmlFile, key)
	-- print("ToDi_Attachment:saveToXMLFile")
	setXMLInt(xmlFile, key.."#corAngle", self.ToDi.corAngle)
	setXMLFloat(xmlFile, key.."#corHeight", self.ToDi.corHeight)
	setXMLBool(xmlFile, key.."#active", self.ToDi.active)
end


function ToDi_Attachment.actionEventSetHeight(self, actionName, inputValue, callbackState, isAnalog)
	-- print("ToDi_Attachment.actionEventSetHeight")
 	if ToDi_Vehicle.ToDi_OnOff then
		if self.ToDi.parentVehicle.ToDi.ToDi_HoT ~= 0 then
			local corHeight = round((self.ToDi.corHeight - self.ToDi.parentVehicle.ToDi.ToDi_HoT)*100)/100
			self:setToDiZero(self.ToDi.corAngle, corHeight, self.ToDi.active)
		end
	end
end


function ToDi_Attachment.actionEventSetAngle(self, actionName, inputValue, callbackState, isAnalog)
	-- print("ToDi_Attachment.actionEventSetAngle")
	if ToDi_Vehicle.ToDi_OnOff then
		if self.ToDi.parentVehicle.ToDi.ToDi_ang ~= 0 then
			local corAngle = round(self.ToDi.corAngle - (self.ToDi.dir*self.ToDi.parentVehicle.ToDi.ToDi_ang))
			self:setToDiZero(corAngle, self.ToDi.corHeight, self.ToDi.active)
		end
	end
end


function ToDi_Attachment.actionEventActive(self, actionName, inputValue, callbackState, isAnalog)
	-- print("ToDi_Attachment.actionEventSetAngle")
	if ToDi_Vehicle.ToDi_OnOff then
		local active = not self.ToDi.active
		self:setToDiZero(self.ToDi.corAngle, self.ToDi.corHeight, active)
	else
		ToDi_Vehicle.ToDi_OnOff = true
		if not self.ToDi.active then
			self:setToDiZero(self.ToDi.corAngle, self.ToDi.corHeight, true)
		end
	end
end

function ToDi_Attachment.actionEventPLUS(self, actionName, inputValue, callbackState, isAnalog)
	-- print("ToDi_Attachment.actionEventPLUS")
	if ToDi_Vehicle.ToDi_OnOff then
		ToDi_Vehicle.ToDi_size = ToDi_Vehicle.ToDi_size * 1.1
	end
end


function ToDi_Attachment.actionEventMINUS(self, actionName, inputValue, callbackState, isAnalog)
	-- print("ToDi_Attachment.actionEventMINUS")
	if ToDi_Vehicle.ToDi_OnOff then
		ToDi_Vehicle.ToDi_size = ToDi_Vehicle.ToDi_size / 1.1
	end
end

function ToDi_Attachment.actionEventOnOff(self, actionName, inputValue, callbackState, isAnalog)
	-- print("ToolDisplay:ToolDisplay_OnOff")
	if self.ToDi.active then
		ToDi_Vehicle.ToDi_OnOff = not ToDi_Vehicle.ToDi_OnOff
	else
		self:setToDiZero(self.ToDi.corAngle, self.ToDi.corHeight, true)
		if not ToDi_Vehicle.ToDi_OnOff then
			ToDi_Vehicle.ToDi_OnOff = true
		end
	end
end


function ToDi_Attachment:onReadStream(streamId, connection)
    -- print("ToDi_Attachment:onReadStream")
	self.ToDi.corAngle = streamReadInt16(streamId)
	self.ToDi.corHeight = streamReadInt16(streamId)/100
end


function ToDi_Attachment:onWriteStream(streamId, connection)
	-- print("ToDi_Attachment:onWriteStream")
    streamWriteInt16(streamId, math.floor(self.ToDi.corAngle))
    streamWriteInt16(streamId, math.floor(self.ToDi.corHeight*100))
end


function ToDi_Attachment:setToDiZero(corAngle, corHeight, active, noEventSend)
	-- print("ToDi_Attachment:setToDiZero")
	SetToDiZeroEvent.sendEvent(self, corAngle, corHeight, active, noEventSend)
	
	local spec = self.spec_ToDi_Attachment

	if corAngle ~= nil then
		self.ToDi.corAngle = corAngle
	end
	if corHeight ~= nil then
		self.ToDi.corHeight = corHeight
	end
	if active ~= nil then
		self.ToDi.active = active
	end
end


function round(n)
	-- -- print("round")
	return math.floor(n+0.5)
end
