--
-- AdditionalSpecializations
-- Load additional specializations to existing ones, so we don't have issues with renamed vehicleTypes for AI
--
-- @author  Stefan Maurus
-- @date  01/07/2019
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

local additionals = {
    mower = {
        "workMode"
    }
}

local oldFinalizeVehicleTypes = VehicleTypeManager.finalizeVehicleTypes
VehicleTypeManager.finalizeVehicleTypes = function(self, ...)
    for typeName, typeEntry in pairs(self:getVehicleTypes()) do
        for name, specs in pairs(additionals) do
            if typeName == name then
                for i=1, #specs do
                    if typeEntry.specializationsByName[specs[i]] == nil then
                        self:addSpecialization(typeName, specs[i])
                    end
                end
            end
        end
    end

    oldFinalizeVehicleTypes(self, ...)
end
