--[[ changeObjectByDistance 

Author: 		HoFFi (modding-welt.com)

Description: 	script to animate an object according to distance between to nodes

Version: 		1.0.0.1

Changelog: 		2019-03-27 - initial release
				2019-03-29 - added simple text hud with current length of pipe

--------------------------------------------------------------------------------------------------

XML:
	<changeObjectByDistance>
		<roll CheckNode="1>4|0|0|1|2|1" CheckNodeRef="0>20|2|1|0" objectToChange="0>0"/>
	</changeObjectByDistance>
	
Explaination:
	CheckNode = TG or object in one part of mod
	CheckNodeRef = TG or object in another part of mod
	objectToChange = object which gets scaled/rotated according to distance

]]


changeObjectByDistance = {};

changeObjectByDistance.modDir = g_currentModDirectory;
changeObjectByDistance.currentModName = g_currentModName;

function changeObjectByDistance.prerequisitesPresent(specializations)
    return true; 
end;

function changeObjectByDistance.registerEventListeners(vehicleType)
	for _, spec in pairs({"onLoad", "onDelete", "onUpdate", "onDraw", "onReadStream", "onWriteStream"}) do
		SpecializationUtil.registerEventListener(vehicleType, spec, changeObjectByDistance)
	end
end

function changeObjectByDistance:onLoad(savegame)
	self.COBD = {};
	self.COBD.roll = {};
	self.COBD.roll.CheckNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.changeObjectByDistance.roll#CheckNode"), self.i3dMappings);
	self.COBD.roll.CheckNodeRef = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.changeObjectByDistance.roll#CheckNodeRef"), self.i3dMappings);
	self.COBD.roll.objectToChange = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.changeObjectByDistance.roll#objectToChange"), self.i3dMappings);
	self.COBD.roll.workingWidth1 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.workAreas.workArea.area#startNode"), self.i3dMappings);
	self.COBD.roll.workingWidth2 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.workAreas.workArea.area#widthNode"), self.i3dMappings);
	self.COBD.roll.maxHoseLenght = getXMLInt(self.xmlFile, "vehicle.changeObjectByDistance.roll#maxHoseLenght");
	self.COBD.roll.hoseObjectCount = getXMLInt(self.xmlFile, "vehicle.changeObjectByDistance.roll#hoseObjectCount");
	self.COBD.roll.speedScale = getXMLInt(self.xmlFile, "vehicle.changeObjectByDistance.roll#speedScale");
	self.COBD.distance = {};
	self.COBD.workingWidth = {};
	self.COBD.textsize = g_currentMission.hud.speedMeter.cruiseControlTextSize * 1.5
	
	self.COBD.roll1 = I3DUtil.indexToObject(self.components, "Schlauch1_vis", self.i3dMappings);
	self.COBD.roll2 = I3DUtil.indexToObject(self.components, "Schlauch2_vis", self.i3dMappings);
	self.COBD.roll3 = I3DUtil.indexToObject(self.components, "Schlauch3_vis", self.i3dMappings);
	self.COBD.roll4 = I3DUtil.indexToObject(self.components, "Schlauch4_vis", self.i3dMappings);
	self.COBD.roll5 = I3DUtil.indexToObject(self.components, "Schlauch5_vis", self.i3dMappings);
	self.COBD.roll6 = I3DUtil.indexToObject(self.components, "Schlauch6_vis", self.i3dMappings);
	self.COBD.roll7 = I3DUtil.indexToObject(self.components, "Schlauch7_vis", self.i3dMappings);
	self.COBD.roll8 = I3DUtil.indexToObject(self.components, "Schlauch8_vis", self.i3dMappings);
	self.COBD.roll9 = I3DUtil.indexToObject(self.components, "Schlauch9_vis", self.i3dMappings);
	self.COBD.roll10 = I3DUtil.indexToObject(self.components, "Schlauch10_vis", self.i3dMappings);
	self.COBD.roll11 = I3DUtil.indexToObject(self.components, "Schlauch11_vis", self.i3dMappings);
	self.COBD.roll12 = I3DUtil.indexToObject(self.components, "Schlauch12_vis", self.i3dMappings);
	self.COBD.roll13 = I3DUtil.indexToObject(self.components, "Schlauch13_vis", self.i3dMappings);
	self.COBD.Halter = I3DUtil.indexToObject(self.components, "Strebe2_vis", self.i3dMappings);
	
	
	self.COBD.HudPressure1 = I3DUtil.indexToObject(self.components, "HudPressure1", self.i3dMappings);
	self.COBD.HudPressure2 = I3DUtil.indexToObject(self.components, "HudPressure2", self.i3dMappings);
	self.COBD.HudLength1 = I3DUtil.indexToObject(self.components, "HudLength1", self.i3dMappings);
	self.COBD.HudLength2 = I3DUtil.indexToObject(self.components, "HudLength2", self.i3dMappings);
	
	self.COBD.scaleAmount13 = 1;
	self.COBD.scaleAmount12 = 1;
	self.COBD.scaleAmount11 = 1;
	self.COBD.scaleAmount10 = 1;
	self.COBD.scaleAmount9 = 1;
	self.COBD.scaleAmount8 = 1;
	self.COBD.scaleAmount7 = 1;
	self.COBD.scaleAmount6 = 1;
	self.COBD.scaleAmount5 = 1;
	self.COBD.scaleAmount4 = 1;
	self.COBD.scaleAmount3 = 1;
	self.COBD.scaleAmount2 = 1;
	self.COBD.scaleAmount1 = 1;
	self.COBD.transAmount1 = 0;
end;


function changeObjectByDistance:onUpdate(dt)

	local x, y, z = localToLocal(self.COBD.roll.CheckNode, self.COBD.roll.CheckNodeRef, 0, 0, 0)
	if z < 0 then
		self.COBD.distance = z * -1;
	else
		self.COBD.distance = z;
	end
	
	local x2, y2, z2 = localToLocal(self.COBD.roll.workingWidth1, self.COBD.roll.workingWidth2, 0, 0, 0)
	self.COBD.workingWidth = x2;
	
	--set rotation to Drum
	setRotation(self.COBD.roll.objectToChange, 0, 0, z * self.COBD.roll.speedScale);
	
	--get length steps of each roll
	local roll1MaxLenght = self.COBD.roll.maxHoseLenght / 36
	
	
	
	if self.COBD.distance < roll1MaxLenght then
		self.COBD.scaleAmount1 = 1 - ((self.COBD.distance / roll1MaxLenght) / 8)
	elseif self.COBD.distance >= roll1MaxLenght*1 and self.COBD.distance < roll1MaxLenght*2 then
		self.COBD.scaleAmount2 = 1 - (((self.COBD.distance - (roll1MaxLenght * 1)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount1 = 0.875
	elseif self.COBD.distance >= roll1MaxLenght*2 and self.COBD.distance < roll1MaxLenght*3 then
		self.COBD.scaleAmount3 = 1 - (((self.COBD.distance - (roll1MaxLenght * 2)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount2 = 0.875
		self.COBD.scaleAmount1 = 0.875
	elseif self.COBD.distance >= roll1MaxLenght*3 and self.COBD.distance < roll1MaxLenght*4 then
		self.COBD.scaleAmount4 = 1 - (((self.COBD.distance - (roll1MaxLenght * 3)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount3 = 0.875
		self.COBD.scaleAmount2 = 0.875
		self.COBD.scaleAmount1 = 0.875
	elseif self.COBD.distance >= roll1MaxLenght*4 and self.COBD.distance < roll1MaxLenght*5 then
		self.COBD.scaleAmount5 = 1 - (((self.COBD.distance - (roll1MaxLenght * 4)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount4 = 0.875
		self.COBD.scaleAmount3 = 0.875
		self.COBD.scaleAmount2 = 0.875
		self.COBD.scaleAmount1 = 0.875
	elseif self.COBD.distance >= roll1MaxLenght*5 and self.COBD.distance < roll1MaxLenght*6 then
		self.COBD.scaleAmount6 = 1 - (((self.COBD.distance - (roll1MaxLenght * 5)) / roll1MaxLenght) / 4)
		self.COBD.scaleAmount5 = 0.875
		self.COBD.scaleAmount4 = 0.875
		self.COBD.scaleAmount3 = 0.875
		self.COBD.scaleAmount2 = 0.875
		self.COBD.scaleAmount1 = 0.875
	elseif self.COBD.distance >= roll1MaxLenght*6 and self.COBD.distance < roll1MaxLenght*7 then
		self.COBD.scaleAmount5 = 0.875 - (((self.COBD.distance - (roll1MaxLenght * 6)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount4 = 0.875
		self.COBD.scaleAmount3 = 0.875
		self.COBD.scaleAmount2 = 0.875
		self.COBD.scaleAmount1 = 0.875
	elseif self.COBD.distance >= roll1MaxLenght*7 and self.COBD.distance < roll1MaxLenght*8 then
		self.COBD.scaleAmount4 = 0.875 - (((self.COBD.distance - (roll1MaxLenght * 7)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount3 = 0.875
		self.COBD.scaleAmount2 = 0.875
		self.COBD.scaleAmount1 = 0.875
	elseif self.COBD.distance >= roll1MaxLenght*8 and self.COBD.distance < roll1MaxLenght*9 then
		self.COBD.scaleAmount3 = 0.875 - (((self.COBD.distance - (roll1MaxLenght * 8)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount2 = 0.875
		self.COBD.scaleAmount1 = 0.875
	elseif self.COBD.distance >= roll1MaxLenght*9 and self.COBD.distance < roll1MaxLenght*10 then
		self.COBD.scaleAmount2 = 0.875 - (((self.COBD.distance - (roll1MaxLenght * 9)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount3 = 0.75
		self.COBD.scaleAmount1 = 0.875
	elseif self.COBD.distance >= roll1MaxLenght*10 and self.COBD.distance < roll1MaxLenght*11 then
		self.COBD.scaleAmount1 = 0.875 - (((self.COBD.distance - (roll1MaxLenght * 10)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount3 = 0.75
		self.COBD.scaleAmount2 = 0.75
	elseif self.COBD.distance >= roll1MaxLenght*11 and self.COBD.distance < roll1MaxLenght*12 then
		self.COBD.scaleAmount7 = 1 - (((self.COBD.distance - (roll1MaxLenght * 11)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount3 = 0.75
		self.COBD.scaleAmount2 = 0.75
		self.COBD.scaleAmount1 = 0.75
	elseif self.COBD.distance >= roll1MaxLenght*12 and self.COBD.distance < roll1MaxLenght*13 then
		self.COBD.scaleAmount8 = 1 - (((self.COBD.distance - (roll1MaxLenght * 12)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount7 = 0.875
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount3 = 0.75
		self.COBD.scaleAmount2 = 0.75
		self.COBD.scaleAmount1 = 0.75
	elseif self.COBD.distance >= roll1MaxLenght*13 and self.COBD.distance < roll1MaxLenght*14 then
		self.COBD.scaleAmount9 = 1 - (((self.COBD.distance - (roll1MaxLenght * 13)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount8 = 0.875
		self.COBD.scaleAmount7 = 0.875
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount3 = 0.75
		self.COBD.scaleAmount2 = 0.75
		self.COBD.scaleAmount1 = 0.75
	elseif self.COBD.distance >= roll1MaxLenght*14 and self.COBD.distance < roll1MaxLenght*15 then
		self.COBD.scaleAmount10 = 1 - (((self.COBD.distance - (roll1MaxLenght * 14)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount9 = 0.875
		self.COBD.scaleAmount8 = 0.875
		self.COBD.scaleAmount7 = 0.875
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount3 = 0.75
		self.COBD.scaleAmount2 = 0.75
		self.COBD.scaleAmount1 = 0.75
	elseif self.COBD.distance >= roll1MaxLenght*15 and self.COBD.distance < roll1MaxLenght*16 then
		self.COBD.scaleAmount11 = 1 - (((self.COBD.distance - (roll1MaxLenght * 15)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount10 = 0.875
		self.COBD.scaleAmount9 = 0.875
		self.COBD.scaleAmount8 = 0.875
		self.COBD.scaleAmount7 = 0.875
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount3 = 0.75
		self.COBD.scaleAmount2 = 0.75
		self.COBD.scaleAmount1 = 0.75
	elseif self.COBD.distance >= roll1MaxLenght*16 and self.COBD.distance < roll1MaxLenght*17 then
		self.COBD.scaleAmount12 = 1 - (((self.COBD.distance - (roll1MaxLenght * 16)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount11 = 0.875
		self.COBD.scaleAmount10 = 0.875
		self.COBD.scaleAmount9 = 0.875
		self.COBD.scaleAmount8 = 0.875
		self.COBD.scaleAmount7 = 0.875
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount3 = 0.75
		self.COBD.scaleAmount2 = 0.75
		self.COBD.scaleAmount1 = 0.75
	elseif self.COBD.distance >= roll1MaxLenght*17 and self.COBD.distance < roll1MaxLenght*18 then
		self.COBD.scaleAmount13 = 1 - (((self.COBD.distance - (roll1MaxLenght * 17)) / roll1MaxLenght) / 4)
		self.COBD.scaleAmount12 = 0.875
		self.COBD.scaleAmount11 = 0.875
		self.COBD.scaleAmount10 = 0.875
		self.COBD.scaleAmount9 = 0.875
		self.COBD.scaleAmount8 = 0.875
		self.COBD.scaleAmount7 = 0.875
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount3 = 0.75
		self.COBD.scaleAmount2 = 0.75
		self.COBD.scaleAmount1 = 0.75
	elseif self.COBD.distance >= roll1MaxLenght*18 and self.COBD.distance < roll1MaxLenght*19 then
		self.COBD.scaleAmount12 = 0.875 - (((self.COBD.distance - (roll1MaxLenght * 18)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount11 = 0.875
		self.COBD.scaleAmount10 = 0.875
		self.COBD.scaleAmount9 = 0.875
		self.COBD.scaleAmount8 = 0.875
		self.COBD.scaleAmount7 = 0.875
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount3 = 0.75
		self.COBD.scaleAmount2 = 0.75
		self.COBD.scaleAmount1 = 0.75
	elseif self.COBD.distance >= roll1MaxLenght*19 and self.COBD.distance < roll1MaxLenght*20 then
		self.COBD.scaleAmount11 = 0.875 - (((self.COBD.distance - (roll1MaxLenght * 19)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount10 = 0.875
		self.COBD.scaleAmount9 = 0.875
		self.COBD.scaleAmount8 = 0.875
		self.COBD.scaleAmount7 = 0.875
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount3 = 0.75
		self.COBD.scaleAmount2 = 0.75
		self.COBD.scaleAmount1 = 0.75
	elseif self.COBD.distance >= roll1MaxLenght*20 and self.COBD.distance < roll1MaxLenght*21 then
		self.COBD.scaleAmount10 = 0.875 - (((self.COBD.distance - (roll1MaxLenght * 20)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount11 = 0.75
		self.COBD.scaleAmount9 = 0.875
		self.COBD.scaleAmount8 = 0.875
		self.COBD.scaleAmount7 = 0.875
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount3 = 0.75
		self.COBD.scaleAmount2 = 0.75
		self.COBD.scaleAmount1 = 0.75
	elseif self.COBD.distance >= roll1MaxLenght*21 and self.COBD.distance < roll1MaxLenght*22 then
		self.COBD.scaleAmount9 = 0.875 - (((self.COBD.distance - (roll1MaxLenght * 21)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount11 = 0.75
		self.COBD.scaleAmount10 = 0.75
		self.COBD.scaleAmount8 = 0.875
		self.COBD.scaleAmount7 = 0.875
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount3 = 0.75
		self.COBD.scaleAmount2 = 0.75
		self.COBD.scaleAmount1 = 0.75
	elseif self.COBD.distance >= roll1MaxLenght*22 and self.COBD.distance < roll1MaxLenght*23 then
		self.COBD.scaleAmount8 = 0.875 - (((self.COBD.distance - (roll1MaxLenght * 22)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount11 = 0.75
		self.COBD.scaleAmount10 = 0.75
		self.COBD.scaleAmount9 = 0.75
		self.COBD.scaleAmount7 = 0.875
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount3 = 0.75
		self.COBD.scaleAmount2 = 0.75
		self.COBD.scaleAmount1 = 0.75
	elseif self.COBD.distance >= roll1MaxLenght*23 and self.COBD.distance < roll1MaxLenght*24 then
		self.COBD.scaleAmount7 = 0.875 - (((self.COBD.distance - (roll1MaxLenght * 23)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount11 = 0.75
		self.COBD.scaleAmount10 = 0.75
		self.COBD.scaleAmount9 = 0.75
		self.COBD.scaleAmount8 = 0.75
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount3 = 0.75
		self.COBD.scaleAmount2 = 0.75
		self.COBD.scaleAmount1 = 0.75
	elseif self.COBD.distance >= roll1MaxLenght*24 and self.COBD.distance < roll1MaxLenght*25 then
		self.COBD.scaleAmount1 = 0.75 - (((self.COBD.distance - (roll1MaxLenght * 24)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount11 = 0.75
		self.COBD.scaleAmount10 = 0.75
		self.COBD.scaleAmount9 = 0.75
		self.COBD.scaleAmount8 = 0.75
		self.COBD.scaleAmount7 = 0.75
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount3 = 0.75
		self.COBD.scaleAmount2 = 0.75
	elseif self.COBD.distance >= roll1MaxLenght*25 and self.COBD.distance < roll1MaxLenght*26 then
		self.COBD.scaleAmount2 = 0.75 - (((self.COBD.distance - (roll1MaxLenght * 25)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount11 = 0.75
		self.COBD.scaleAmount10 = 0.75
		self.COBD.scaleAmount9 = 0.75
		self.COBD.scaleAmount8 = 0.75
		self.COBD.scaleAmount7 = 0.75
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount3 = 0.75
		self.COBD.scaleAmount1 = 0.625
	elseif self.COBD.distance >= roll1MaxLenght*26 and self.COBD.distance < roll1MaxLenght*27 then
		self.COBD.scaleAmount3 = 0.75 - (((self.COBD.distance - (roll1MaxLenght * 26)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount11 = 0.75
		self.COBD.scaleAmount10 = 0.75
		self.COBD.scaleAmount9 = 0.75
		self.COBD.scaleAmount8 = 0.75
		self.COBD.scaleAmount7 = 0.75
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount4 = 0.75
		self.COBD.scaleAmount2 = 0.625
		self.COBD.scaleAmount1 = 0.625
	elseif self.COBD.distance >= roll1MaxLenght*27 and self.COBD.distance < roll1MaxLenght*28 then
		self.COBD.scaleAmount4 = 0.75 - (((self.COBD.distance - (roll1MaxLenght * 27)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount11 = 0.75
		self.COBD.scaleAmount10 = 0.75
		self.COBD.scaleAmount9 = 0.75
		self.COBD.scaleAmount8 = 0.75
		self.COBD.scaleAmount7 = 0.75
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount5 = 0.75
		self.COBD.scaleAmount3 = 0.625
		self.COBD.scaleAmount2 = 0.625
		self.COBD.scaleAmount1 = 0.625
	elseif self.COBD.distance >= roll1MaxLenght*28 and self.COBD.distance < roll1MaxLenght*29 then
		self.COBD.scaleAmount5 = 0.75 - (((self.COBD.distance - (roll1MaxLenght * 28)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount11 = 0.75
		self.COBD.scaleAmount10 = 0.75
		self.COBD.scaleAmount9 = 0.75
		self.COBD.scaleAmount8 = 0.75
		self.COBD.scaleAmount7 = 0.75
		self.COBD.scaleAmount6 = 0.75
		self.COBD.scaleAmount4 = 0.625
		self.COBD.scaleAmount3 = 0.625
		self.COBD.scaleAmount2 = 0.625
		self.COBD.scaleAmount1 = 0.625
	elseif self.COBD.distance >= roll1MaxLenght*29  and self.COBD.distance < roll1MaxLenght*30 then
		self.COBD.scaleAmount6 = 0.75 - (((self.COBD.distance - (roll1MaxLenght * 29)) / roll1MaxLenght) / 4)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount11 = 0.75
		self.COBD.scaleAmount10 = 0.75
		self.COBD.scaleAmount9 = 0.75
		self.COBD.scaleAmount8 = 0.75
		self.COBD.scaleAmount7 = 0.75
		self.COBD.scaleAmount5 = 0.625
		self.COBD.scaleAmount4 = 0.625
		self.COBD.scaleAmount3 = 0.625
		self.COBD.scaleAmount2 = 0.625
		self.COBD.scaleAmount1 = 0.625
	elseif self.COBD.distance >= roll1MaxLenght*30  and self.COBD.distance < roll1MaxLenght*31 then
		self.COBD.scaleAmount5 = 0.625 - (((self.COBD.distance - (roll1MaxLenght * 30)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount11 = 0.75
		self.COBD.scaleAmount10 = 0.75
		self.COBD.scaleAmount9 = 0.75
		self.COBD.scaleAmount8 = 0.75
		self.COBD.scaleAmount7 = 0.75
		self.COBD.scaleAmount6 = 0.5
		self.COBD.scaleAmount4 = 0.625
		self.COBD.scaleAmount3 = 0.625
		self.COBD.scaleAmount2 = 0.625
		self.COBD.scaleAmount1 = 0.625
	elseif self.COBD.distance >= roll1MaxLenght*31  and self.COBD.distance < roll1MaxLenght*32 then
		self.COBD.scaleAmount4 = 0.625 - (((self.COBD.distance - (roll1MaxLenght * 31)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount11 = 0.75
		self.COBD.scaleAmount10 = 0.75
		self.COBD.scaleAmount9 = 0.75
		self.COBD.scaleAmount8 = 0.75
		self.COBD.scaleAmount7 = 0.75
		self.COBD.scaleAmount6 = 0.5
		self.COBD.scaleAmount5 = 0.5
		self.COBD.scaleAmount2 = 0.625
		self.COBD.scaleAmount3 = 0.625
		self.COBD.scaleAmount1 = 0.625
	elseif self.COBD.distance >= roll1MaxLenght*32  and self.COBD.distance < roll1MaxLenght*33 then
		self.COBD.scaleAmount3 = 0.625 - (((self.COBD.distance - (roll1MaxLenght * 32)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount11 = 0.75
		self.COBD.scaleAmount10 = 0.75
		self.COBD.scaleAmount9 = 0.75
		self.COBD.scaleAmount8 = 0.75
		self.COBD.scaleAmount7 = 0.75
		self.COBD.scaleAmount6 = 0.5
		self.COBD.scaleAmount5 = 0.5
		self.COBD.scaleAmount4 = 0.5
		self.COBD.scaleAmount2 = 0.625
		self.COBD.scaleAmount1 = 0.625
	elseif self.COBD.distance >= roll1MaxLenght*33  and self.COBD.distance < roll1MaxLenght*34 then
		self.COBD.scaleAmount2 = 0.625 - (((self.COBD.distance - (roll1MaxLenght * 33)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount11 = 0.75
		self.COBD.scaleAmount10 = 0.75
		self.COBD.scaleAmount9 = 0.75
		self.COBD.scaleAmount8 = 0.75
		self.COBD.scaleAmount7 = 0.75
		self.COBD.scaleAmount6 = 0.5
		self.COBD.scaleAmount5 = 0.5
		self.COBD.scaleAmount4 = 0.5
		self.COBD.scaleAmount3 = 0.5
		self.COBD.scaleAmount1 = 0.625
	elseif self.COBD.distance >= roll1MaxLenght*34  and self.COBD.distance < roll1MaxLenght*35 then
		self.COBD.scaleAmount15 = 0.625 - (((self.COBD.distance - (roll1MaxLenght * 34)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount11 = 0.75
		self.COBD.scaleAmount10 = 0.75
		self.COBD.scaleAmount9 = 0.75
		self.COBD.scaleAmount8 = 0.75
		self.COBD.scaleAmount7 = 0.75
		self.COBD.scaleAmount6 = 0.5
		self.COBD.scaleAmount5 = 0.5
		self.COBD.scaleAmount4 = 0.5
		self.COBD.scaleAmount3 = 0.5
		self.COBD.scaleAmount2 = 0.5
	elseif self.COBD.distance >= roll1MaxLenght*35  and self.COBD.distance < roll1MaxLenght*36 then
		self.COBD.scaleAmount6 = 0.625 - (((self.COBD.distance - (roll1MaxLenght * 35)) / roll1MaxLenght) / 8)
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount11 = 0.75
		self.COBD.scaleAmount10 = 0.75
		self.COBD.scaleAmount9 = 0.75
		self.COBD.scaleAmount8 = 0.75
		self.COBD.scaleAmount7 = 0.625
		self.COBD.scaleAmount5 = 0.5
		self.COBD.scaleAmount4 = 0.5
		self.COBD.scaleAmount3 = 0.5
		self.COBD.scaleAmount2 = 0.5
		self.COBD.scaleAmount1 = 0.5
	else
		self.COBD.scaleAmount13 = 0.75
		self.COBD.scaleAmount12 = 0.75
		self.COBD.scaleAmount11 = 0.75
		self.COBD.scaleAmount10 = 0.75
		self.COBD.scaleAmount9 = 0.75
		self.COBD.scaleAmount8 = 0.75
		self.COBD.scaleAmount7 = 0.625
		self.COBD.scaleAmount6 = 0.5
		self.COBD.scaleAmount5 = 0.5
		self.COBD.scaleAmount4 = 0.5
		self.COBD.scaleAmount3 = 0.5
		self.COBD.scaleAmount2 = 0.5
		self.COBD.scaleAmount1 = 0.5
	end
	
	
	if self.COBD.distance < roll1MaxLenght*6 then
		self.COBD.transAmount1 = -0.497 + (((self.COBD.distance - (roll1MaxLenght * 6)) / roll1MaxLenght) / -10)
	elseif self.COBD.distance >= roll1MaxLenght*6  and  self.COBD.distance < roll1MaxLenght*18 then
		self.COBD.transAmount1 = 0.503 - ((((self.COBD.distance - (roll1MaxLenght * 6)) - (roll1MaxLenght * 12)) / roll1MaxLenght) / -12)
	elseif self.COBD.distance >= roll1MaxLenght*18  and  self.COBD.distance < roll1MaxLenght*30 then
		self.COBD.transAmount1 = 0.503 + ((((self.COBD.distance - (roll1MaxLenght * 6)) - (roll1MaxLenght * 12)) / roll1MaxLenght) / -12)
	elseif self.COBD.distance >= roll1MaxLenght*30	and  self.COBD.distance < roll1MaxLenght*42 then
		self.COBD.transAmount1 = -0.997 - ((((self.COBD.distance - (roll1MaxLenght * 6)) - (roll1MaxLenght * 12)) / roll1MaxLenght) / -12)
	else
		self.COBD.transAmount1 = -0.497
	end
	
	
	setScale(self.COBD.roll1, self.COBD.scaleAmount1, self.COBD.scaleAmount1, 1);
	setScale(self.COBD.roll2, self.COBD.scaleAmount2, self.COBD.scaleAmount2, 1);
	setScale(self.COBD.roll3, self.COBD.scaleAmount3, self.COBD.scaleAmount3, 1);
	setScale(self.COBD.roll4, self.COBD.scaleAmount4, self.COBD.scaleAmount4, 1);
	setScale(self.COBD.roll5, self.COBD.scaleAmount5, self.COBD.scaleAmount5, 1);
	setScale(self.COBD.roll6, self.COBD.scaleAmount6, self.COBD.scaleAmount6, 1);
	setScale(self.COBD.roll7, self.COBD.scaleAmount7, self.COBD.scaleAmount7, 1);
	setScale(self.COBD.roll8, self.COBD.scaleAmount8, self.COBD.scaleAmount8, 1);
	setScale(self.COBD.roll9, self.COBD.scaleAmount9, self.COBD.scaleAmount9, 1);
	setScale(self.COBD.roll10, self.COBD.scaleAmount10, self.COBD.scaleAmount10, 1);
	setScale(self.COBD.roll11, self.COBD.scaleAmount11, self.COBD.scaleAmount11, 1);
	setScale(self.COBD.roll12, self.COBD.scaleAmount12, self.COBD.scaleAmount12, 1);
	setScale(self.COBD.roll13, self.COBD.scaleAmount13, self.COBD.scaleAmount13, 1);
	
	setTranslation(self.COBD.Halter, -0.674, 0.413, self.COBD.transAmount1);
	
	-- set pressure for dash hud
	self.COBD.disctanceToSplit = MathUtil.round((self.COBD.workingWidth / 55) + 7.5,1)
	if self.COBD.disctanceToSplit > 7 and self.COBD.disctanceToSplit < 8 then
		self.COBD.text1 = 7
		self.COBD.text2 = MathUtil.round((self.COBD.disctanceToSplit - 7) *10,0)
	elseif self.COBD.disctanceToSplit >= 8 and self.COBD.disctanceToSplit < 9 then
		self.COBD.text1 = 8
		self.COBD.text2 = MathUtil.round((self.COBD.disctanceToSplit - 8) *10,0)
	elseif self.COBD.disctanceToSplit >= 9 and self.COBD.disctanceToSplit < 10 then
		self.COBD.text1 = 9
		self.COBD.text2 = MathUtil.round((self.COBD.disctanceToSplit - 9) *10,0)
	else
		self.COBD.text1 = 10
		self.COBD.text2 = MathUtil.round((self.COBD.disctanceToSplit - 10) *10,0)
	end
	setShaderParameter(self.COBD.HudPressure1, "number", self.COBD.text1, 0, 0, 0, false)
	setShaderParameter(self.COBD.HudPressure2, "number", self.COBD.text2, 0, 0, 0, false)
	
	-- set distance for dash hud
	self.COBD.disctanceToSplit2 = MathUtil.round(self.COBD.workingWidth,1)
	if self.COBD.disctanceToSplit2 > 50 and self.COBD.disctanceToSplit2 < 60 then
		self.COBD.text3 = 5
		self.COBD.text4 = MathUtil.round(self.COBD.disctanceToSplit2 - 50,0)
	elseif self.COBD.disctanceToSplit2 >= 60 and self.COBD.disctanceToSplit2 < 70 then
		self.COBD.text3 = 6
		self.COBD.text4 = MathUtil.round(self.COBD.disctanceToSplit2 - 60,0)
	elseif self.COBD.disctanceToSplit2 >= 70 and self.COBD.disctanceToSplit2 < 80 then
		self.COBD.text3 = 7
		self.COBD.text4 = MathUtil.round(self.COBD.disctanceToSplit2 - 70,0)
	else
		self.COBD.text3 = 8
		self.COBD.text4 = MathUtil.round(self.COBD.disctanceToSplit2 - 80,0)
	end
	setShaderParameter(self.COBD.HudLength1, "number", self.COBD.text3, 0, 0, 0, false)
	setShaderParameter(self.COBD.HudLength2, "number", self.COBD.text4, 0, 0, 0, false)
	
end;

function changeObjectByDistance:onDelete()
end;

function changeObjectByDistance:onReadStream(streamId, connection)
end;

function changeObjectByDistance:onWriteStream(streamId, connection)
end;

function changeObjectByDistance:onDraw(isActiveForInput, isSelected)
	if self.isClient then
		if isActiveForInput then
			local aktPrintText = self.COBD.distance
			local aktPrintText2 = self.COBD.workingWidth
			local TSize = self.COBD.textsize
			
			self.COBD.aktPrintText = MathUtil.round(aktPrintText, 1)
			self.COBD.aktPrintText2 = MathUtil.round(aktPrintText2, 1)
			self.COBD.aktPrintText3 = MathUtil.round((self.COBD.aktPrintText2 / 55) + 7.5,1)
		
			g_currentMission:addExtraPrintText(g_i18n:getText("hoseLength") .. ": " .. self.COBD.aktPrintText .. "m / 220m")
			g_currentMission:addExtraPrintText(g_i18n:getText("workingWidth") .. ": " .. self.COBD.aktPrintText2 .. "m        " .. g_i18n:getText("pressure") .. ": " .. self.COBD.aktPrintText3 .. "bar")
		end
	end
end