--[[
Interface: 1.5.1.0 b6732

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 14.09.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 14.09.2019 - Release Version

Important:
No changes are to be made to this script without permission from GtX | Andy
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


SiloDisplayEvent = {}
SiloDisplayEvent_mt = Class(SiloDisplayEvent, Event)
InitEventClass(SiloDisplayEvent, "SiloDisplayEvent")

function SiloDisplayEvent:emptyNew()
    local self = Event:new(SiloDisplayEvent_mt)
    return self
end

function SiloDisplayEvent:new(siloDisplay, seekRadius, userSet, currentScreenLayout)
    local self = SiloDisplayEvent:emptyNew()

    self.siloDisplay = siloDisplay
    self.seekRadius = seekRadius
    self.userSet = userSet
    self.currentScreenLayout = currentScreenLayout

    return self
end

function SiloDisplayEvent:readStream(streamId, connection)
    self.siloDisplay = NetworkUtil.readNodeObject(streamId)
    self.seekRadius = streamReadUInt8(streamId)
    self.userSet = streamReadBool(streamId)

    if self.userSet then
        self.currentScreenLayout = {}
        local layoutCount = streamReadUInt8(streamId)

        if layoutCount > 0 then
            for i = 1, layoutCount do
                self.currentScreenLayout[i] = {}

                if streamReadBool(streamId) then
                    self.currentScreenLayout[i].fillTypeIndex = streamReadUIntN(streamId, FillTypeManager.SEND_NUM_BITS)
                end
            end
        else
            self.userSet = false
        end
    end

    self:run(connection)
end

function SiloDisplayEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.siloDisplay)
    streamWriteUInt8(streamId, self.seekRadius)
    streamWriteBool(streamId, self.userSet)

    if self.userSet and self.currentScreenLayout ~= nil then
        local layoutCount = #self.currentScreenLayout
        streamWriteUInt8(streamId, layoutCount)

        if layoutCount > 0 then
            for i = 1, layoutCount do
                if streamWriteBool(streamId, self.currentScreenLayout[i].fillTypeIndex ~= nil) then
                    streamWriteUIntN(streamId, self.currentScreenLayout[i].fillTypeIndex, FillTypeManager.SEND_NUM_BITS)
                end
            end
        end
    end
end

function SiloDisplayEvent:run(connection)
    if self.siloDisplay ~= nil then
        self.siloDisplay:updateUserConfiguration(self.seekRadius, self.userSet, self.currentScreenLayout, true)

        if not connection:getIsServer() then
            g_server:broadcastEvent(self, false, connection, self.siloDisplay)
        end
    end
end

function SiloDisplayEvent.sendEvent(siloDisplay, seekRadius, userSet, currentScreenLayout, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(SiloDisplayEvent:new(siloDisplay, seekRadius, userSet, currentScreenLayout), nil, nil, siloDisplay)
        else
            g_client:getServerConnection():sendEvent(SiloDisplayEvent:new(siloDisplay, seekRadius, userSet, currentScreenLayout))
        end
    end
end
