--[[
Interface: 1.5.1.0 b6732

Author: GtX | Andy
Date: 15.03.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 15.03.2019 - Release Version

About:
1: Allows extra 'Material Types', to be added with added so no warnings will be given if Material Holder is loaded by a map / mod trying to add support for another mod that is not available.

Important:
No changes are to be made to this script without permission from GtX | Andy!
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden!
]]


function addMaterialHolderTypesInit()
    local modDirectory = g_currentModDirectory
    local xmlFile = loadXMLFile("TempModDesc", modDirectory .. "modDesc.xml")

    if xmlFile ~= 0 then

        local i = 0
        while true do
            local key = string.format("modDesc.materialHolderTypes.materialHolderType(%d)", i)
            if not hasXMLProperty(xmlFile, key) then
                break
            end

            local name = getXMLString(xmlFile, key .. "#name")
            if name ~= nil then
                local nameUpper = string.upper(name)

                -- Remove fillType warning for material if needed so it does not look like a mod issue.
                if Utils.getNoNil(getXMLBool(xmlFile, key .. "#ignoreFillTypeWarnings"), false) then

                    -- Create table and change function so any mod can add to it if using this script.
                    if MaterialUtil.IGNORE_FILLTYPE_WARNINGS == nil then
                        MaterialUtil.IGNORE_FILLTYPE_WARNINGS = {}

                        MaterialUtil.onCreateMaterial = Utils.overwrittenFunction(MaterialUtil.onCreateMaterial, function(_, superFunc, id)
                            local materialTypeName = getUserAttribute(id, "materialType")
                            if materialTypeName ~= nil then
                                materialTypeName = materialTypeName:upper()
                                if MaterialUtil.IGNORE_FILLTYPE_WARNINGS[materialTypeName] ~= nil then
                                    local fillTypeName = getUserAttribute(id, "fillType")
                                    if fillTypeName ~= nil and g_fillTypeManager:getFillTypeIndexByName(fillTypeName) == nil then
                                        -- print("  Debug Info: FillType '" .. fillTypeName:upper() .. "' is not installed and has been ignored.")
                                        return
                                    end
                                end
                            end

                            return superFunc(_, id)
                        end)
                    end

                    MaterialUtil.IGNORE_FILLTYPE_WARNINGS[nameUpper] = true
                end

                -- Would only register once but do not want multiple mods showing 'print' more than once.
                if g_materialManager.nameToIndex[nameUpper] == nil then
                    g_materialManager:addMaterialType(nameUpper)

                    print("  Register materialType '" .. nameUpper .. "'")
                end
            end

            i = i + 1
        end

        delete(xmlFile)
        xmlFile = nil
    end
end

addMaterialHolderTypesInit()
