--
-- variableSprayUsage
--
--
-- @author monteur1
-- @date 30/12/2018
--

variableSprayUsage = {};
variableSprayUsage.g_currentModDirectory = g_currentModDirectory

function variableSprayUsage.prerequisitesPresent(specializations)
    return true
end

function variableSprayUsage.registerEventListeners(vehicleType)
    EL = vehicleType.eventListeners
    table.insert(EL.onPreLoad, variableSprayUsage)		
    table.insert(EL.onLoad, variableSprayUsage)
    table.insert(EL.onPostLoad, variableSprayUsage)	
    table.insert(EL.onUpdate, variableSprayUsage)
    table.insert(EL.onUpdateTick, variableSprayUsage)
    table.insert(EL.onDraw, variableSprayUsage)
    table.insert(EL.onRegisterActionEvents, variableSprayUsage)
    table.insert(EL.onReadStream, variableSprayUsage)
    table.insert(EL.onWriteStream, variableSprayUsage)
end

function variableSprayUsage:onPreLoad(savegame)
end

function variableSprayUsage:onLoad(savegame)
	self.variableSprayUsage = {}

	self.variableSprayUsage.WorkingWidth       = 1
	self.variableSprayUsageNewUsage            = 9999
	self.variableSprayUsage.SprayRate          = 0
	self.variableSprayUsage.HasWorkarea        = false

	self.variableSprayUsageIsManureSpreader    = false	
	self.variableSprayUsageHasWorkarea         = false
	
	local key = string.format("vehicle.workAreas.workArea");
	if hasXMLProperty(self.xmlFile, key) then
		self.variableSprayUsage.HasWorkarea    = true
		self.variableSprayUsageHasWorkarea     = true
	end
	
	if self.variableSprayUsage.HasWorkarea == true then
		self.variableSprayUsage.isSlurryTank       = false
		self.variableSprayUsage.isManureSpreader   = false
		self.variableSprayUsage.isLiquidSprayer    = false
		self.variableSprayUsage.isSolidSprayer     = false
		
		key = string.format("vehicle.fillUnit.fillUnitConfigurations.fillUnitConfiguration.fillUnits.fillUnit");
		self.variableSprayUsage.AllowedFilltype    = Utils.getNoNil(getXMLString(self.xmlFile, key.."#fillTypes"), "other")
		self.variableSprayUsage.FillTypeCategories = Utils.getNoNil(getXMLString(self.xmlFile, key.."#fillTypeCategories"), "other")
	
		local fillTypeCategories = self.variableSprayUsage.FillTypeCategories
		
		self.variableSprayUsage.Hud                = {}
		self.variableSprayUsage.Hud.offset_X       = 0.07
		self.variableSprayUsage.Hud.offset_Y       = 0.06 --0.03
		
		local currentModDirectory = variableSprayUsage.g_currentModDirectory	
		if fillTypeCategories == "slurryTank" then
			self.variableSprayUsage.isSlurryTank   = true
			self.variableSprayUsage.SprayRate      = 30000	--L/ha
		else    
			if fillTypeCategories == "manureSpreader" then
				self.variableSprayUsage.isManureSpreader = true
				self.variableSprayUsage.SprayRate        = 20000	--L/ha
			else		
				self.variableSprayUsage.SprayRate      = 300	--L/ha
				
				if fillTypeCategories == "sprayer" then
					self.variableSprayUsage.isLiquidSprayer = true
				else
					self.variableSprayUsage.isSolidSprayer   = true
				end
			end
		end
	
		self.variableSprayUsage.XMLfillType             = {}
		self.variableSprayUsage.XMLworkingWidth         = {}
		self.variableSprayUsage.XMLobjectChange         = {}
		self.variableSprayUsage.XMLsprayerHasConfig     = false
		self.variableSprayUsage.XMLsprayerNumConfig     = 0
		
		key = string.format("vehicle.sprayer.usageScales");
		if hasXMLProperty(self.xmlFile, key) then
			self.variableSprayUsage.XMLworkingWidth[0] = Utils.getNoNil(getXMLFloat(self.xmlFile, key .. "#workingWidth"), 999);
		else
			self.variableSprayUsage.XMLworkingWidth[0] = 999
		end
		
		local i=0;	
		while true do	
			key = string.format("vehicle.sprayer.sprayTypes.sprayType(%d)", i)		
			if not hasXMLProperty(self.xmlFile, key) then
				break
			end	
			
			local key2 = string.format(key..".usageScales")
			self.variableSprayUsage.XMLworkingWidth[i] = Utils.getNoNil(getXMLFloat(self.xmlFile, key2 .. "#workingWidth"), 0);	
			self.variableSprayUsage.XMLfillType[i]     = Utils.getNoNil(getXMLString(self.xmlFile, key .. "#fillTypes"), 0);	
		
			key2 = string.format(key..".objectChange")
			if hasXMLProperty(self.xmlFile, key2) then	
				if i == 1 then
					self.variableSprayUsage.XMLsprayerHasConfig = true
				end		
				self.variableSprayUsage.XMLobjectChange[i] = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, key2.."#node"), self.i3dMappings)
			end
		
			if self.variableSprayUsage.XMLsprayerHasConfig == true then
				self.variableSprayUsage.XMLsprayerNumConfig = i
			end
			
			i = i+1;
		end	

		-- Wenn keine Arbeitsbreite bei vehicle.sprayer.usageScales.workingWidth eingetragen ist, dann Arbeitsbreiten vom Shopdata laden --
		if self.variableSprayUsage.XMLworkingWidth[0] == 999 then
			self.variableSprayUsage.XMLworkingWidth[0] = getXMLFloat(self.xmlFile, "vehicle.storeData.specs.workingWidth")
		end
				
		if savegame ~= nil and not savegame.resetVehicles then
			local key2 = savegame.key ..".FS19_Variable_Spray_Usage.variableSprayUsage"		
			local sprayRate = getXMLInt(savegame.xmlFile, key2.."#sprayRate")
			if sprayRate ~= nil then
				self.variableSprayUsage.SprayRate = sprayRate
			else
				self.variableSprayUsage.SprayRate = 0	
			end
		end	
	end	
end

function variableSprayUsage:onPostLoad(savegame)
end

function variableSprayUsage:loadFromXMLFile(xmlFile, key)
end

function variableSprayUsage:saveToXMLFile(xmlFile, key, usedModNames)
	if self.variableSprayUsage.HasWorkarea == true then
		setXMLInt(xmlFile, key.."#sprayRate", self.variableSprayUsage.SprayRate)
	end
end

function variableSprayUsage:onUpdateTick(dt, isActiveForInput, isSelected)
end

function variableSprayUsage:onUpdate(dt, isActiveForInput, isSelected)
    if self:getIsActive() and self.variableSprayUsage.HasWorkarea == true then
		local sprayerEmpty = false
		local currentSpraywidth = 0 
		if SpecializationUtil.hasSpecialization(newSectionShift, self.specializations) == true then							
			-- get actual Workingwith from Sectionshift--
			currentSpraywidth = self.newSectionShift.AktWorkingWidth
		else
			if self.variableSprayUsage.XMLsprayerHasConfig == true then
				local count = self.variableSprayUsage.XMLsprayerNumConfig
				for i=0, count do
					local objectVisible = getVisibility(self.variableSprayUsage.XMLobjectChange[i])
					if objectVisible == true then
						self.variableSprayUsage.WorkingWidth = self.variableSprayUsage.XMLworkingWidth[i]
					end
				end
			else
				self.variableSprayUsage.WorkingWidth = self.variableSprayUsage.XMLworkingWidth[0]
			end	
			
			currentSpraywidth = self.variableSprayUsage.WorkingWidth
		end
		
		-- 50 = LIME
		-- 44 = LIQUIDFERTILIZER
		
		local currentFillType    = self:getFillUnitFillType(1);
		local currentSpeed       = self.lastSpeedReal*3600  -- *3600 = km/h -- math.max(3, self.lastSpeedReal*3600)
		local currentSprayRate   = self.variableSprayUsage.SprayRate
		local shiftToMeterPerMin = 16.666
		local oneHectar          = 10000
		local usageFac           = 0
		if self.variableSprayUsage.isSlurryTank == true then
			usageFac = 1759 -- 1682
		else
			if self.variableSprayUsage.isLiquidSprayer == true then
				if currentFillType == 44 then
					-- 44 = LIQUIDFERTILIZER					
					usageFac = 1900
				else
					usageFac = 1900
				end
			else
				if currentFillType == 50 then
					-- 50 = LIME					
					usageFac = 1900
				else
					usageFac = 1900
				end
			end
		end
					
		local usagePerMin        = (oneHectar/currentSpraywidth)/(shiftToMeterPerMin*currentSpeed)
		local usageFin           = (currentSprayRate/usagePerMin)/usageFac
		self.variableSprayUsageNewUsage = usageFin	
	end
end

function variableSprayUsage:onDraw(isActiveForInput, isSelected)
	if self.isClient and self.variableSprayUsage.HasWorkarea == true then	
		if isActiveForInput then	
			if self.variableSprayUsage.SprayRate ~= nil then		
				local aktPrintText = self.variableSprayUsage.SprayRate
				local unit = {}			
				if self.variableSprayUsage.isSlurryTank == true or self.variableSprayUsage.isManureSpreader == true then
					unit = "m³/Ha"
					aktPrintText = aktPrintText/1000
				else
					unit = "l/Ha"				
				end
				g_currentMission:addExtraPrintText(g_i18n:getText("current_Sprayrate") .." : ".. aktPrintText .." ".. unit)							
			end
		end
	end		
end

function variableSprayUsage:onReadStream(streamId, connection)
	if self.variableSprayUsage.HasWorkarea == true then
		self.variableSprayUsageNewUsage          = streamReadFloat32(streamId)
		self.variableSprayUsage.WorkingWidth     = streamReadFloat32(streamId)	
		self.variableSprayUsage.SprayRate        = streamReadFloat32(streamId)	
		self.variableSprayUsageHasWorkarea       = streamReadBool(streamId)			
	end
end

function variableSprayUsage:onWriteStream(streamId, connection)
	if self.variableSprayUsage.HasWorkarea == true then
		streamWriteFloat32(streamId, self.variableSprayUsageNewUsage)	
		streamWriteFloat32(streamId, self.variableSprayUsage.WorkingWidth )	
		streamWriteFloat32(streamId, self.variableSprayUsage.SprayRate )	
		streamWriteBool(streamId, self.variableSprayUsageHasWorkarea )	
	end
end

function variableSprayUsage:onDelete()
end;

function variableSprayUsage:onRegisterActionEvents(isSelected, isOnActiveVehicle)
    if isOnActiveVehicle and isSelected and self.variableSprayUsage.HasWorkarea == true then		
		if self.variableSprayUsageActionEvents == nil then 
			self.variableSprayUsageActionEvents = {}
		else	
			self:clearActionEventsTable( self.variableSprayUsageActionEvents )
		end 

		for _,actionName in pairs({ "INCREASE_SPRAYRATE", "DECREASE_SPRAYRATE" }) do
			local _, eventName = self:addActionEvent(self.variableSprayUsageActionEvents, InputAction[actionName], self, variableSprayUsage.actionCallback, false, true, false, true, nil);			
			g_inputBinding.events[eventName].displayPriority = 1
		end
    end
end

function variableSprayUsage:actionCallback(actionName, keyStatus, arg4, arg5, arg6)	
	if self.variableSprayUsage.HasWorkarea == true then 
		if actionName == "INCREASE_SPRAYRATE" or actionName == "DECREASE_SPRAYRATE" then	
			if actionName == "INCREASE_SPRAYRATE" then
				--Ausbringmenge erhöhen--
				local limit = 0
				local step  = 0
				
				if self.variableSprayUsage.isSlurryTank == true then
					limit = 45000
					step  = 1000
				else			
					if self.variableSprayUsage.isManureSpreader == true then
						limit = 30000
						step  = 1000			
					else		
						if self.variableSprayUsage.isLiquidSprayer == true then
							limit = 800
							step  = 50
						else
							--self.variableSprayUsage.isSolidSprayer == true
							limit = 9000
							step  = 50
						end
					end
				end
				
				local currentSprayrate = self.variableSprayUsage.SprayRate	
				currentSprayrate = currentSprayrate + step
				if currentSprayrate <= limit then 
					self.variableSprayUsage.SprayRate = currentSprayrate
				end				
			end
			
			if actionName == "DECREASE_SPRAYRATE" then
				--Ausbringmenge reduzieren--				
				local limit = 0
				local step  = 0
		
				if self.variableSprayUsage.isSlurryTank == true then
					limit = 10000
					step  = 1000
				else
					if self.variableSprayUsage.isManureSpreader == true then
						limit = 12000
						step  = 1000
					else
						if self.variableSprayUsage.isLiquidSprayer == true then
							limit = 100
							step  = 50
						else
							--self.variableSprayUsage.isSolidSprayer == true
							limit = 100
							step  = 50
						end
					end
				end
				
				local currentSprayrate = self.variableSprayUsage.SprayRate	
				currentSprayrate = currentSprayrate - step
				if currentSprayrate >= limit then 
					self.variableSprayUsage.SprayRate = currentSprayrate
				end		
			end
			
			if g_server ~= nil then
				g_server:broadcastEvent(variableSprayUsageChangeSprayrate_Event:new(self, self.variableSprayUsage.SprayRate), nil, nil, self);
			else
				g_client:getServerConnection():sendEvent(variableSprayUsageChangeSprayrate_Event:new(self, self.variableSprayUsage.SprayRate));
			end;				
		end
	end
end

-- Overwrite Sprayerspec --
function variableSprayUsage:getSprayerUsage(superFunc, ...)	
	local usage = superFunc( self, ... )	
	local newUsage = self.variableSprayUsageNewUsage
	
	if self:getIsActive() and self.variableSprayUsageHasWorkarea == true then
		if newUsage ~= 9999 then 
			usage = newUsage 
		else
			local speedLimit = getXMLInt(self.xmlFile, "vehicle.base.speedLimit#value")
			local speedFx = math.max(3, self.lastSpeedReal*3600)
					
			speedFx = speedFx / speedLimit
			usage = usage * speedFx
		end
	end
	
	return usage
end
Sprayer.getSprayerUsage = Utils.overwrittenFunction( Sprayer.getSprayerUsage, variableSprayUsage.getSprayerUsage )
addModEventListener(variableSprayUsage);

-- For Server Event --
variableSprayUsageChangeSprayrate_Event = {};
variableSprayUsageChangeSprayrate_Event_mt = Class(variableSprayUsageChangeSprayrate_Event, Event);

InitEventClass(variableSprayUsageChangeSprayrate_Event, "variableSprayUsageChangeSprayrate_Event");					
					
function variableSprayUsageChangeSprayrate_Event:emptyNew()
    local self = Event:new(variableSprayUsageChangeSprayrate_Event_mt);
    return self;
end;

function variableSprayUsageChangeSprayrate_Event:new(object, data)
    local self = variableSprayUsageChangeSprayrate_Event:emptyNew()
    self.object = object;
    self.data = data;
    return self;
end;

function variableSprayUsageChangeSprayrate_Event:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId);
    self.data = streamReadFloat32(streamId);
    self:run(connection);
end;

function variableSprayUsageChangeSprayrate_Event:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object);
    streamWriteFloat32(streamId, self.data);
end;

function variableSprayUsageChangeSprayrate_Event:run(connection)
    self.object.variableSprayUsage.SprayRate = self.data;
	
    if not connection:getIsServer() then
        g_server:broadcastEvent(variableSprayUsageChangeSprayrate_Event:new(self.object, self.data), nil, connection, self.object);
    end;
end;