MultipleDischargeFillUnitsEvent = {};
MultipleDischargeFillUnitsEvent_mt = Class(MultipleDischargeFillUnitsEvent, Event);
InitEventClass(MultipleDischargeFillUnitsEvent, "MultipleDischargeFillUnitsEvent");

function MultipleDischargeFillUnitsEvent:emptyNew()
    local self = Event:new(MultipleDischargeFillUnitsEvent_mt);
    self.className = "MultipleDischargeFillUnitsEvent";
    return self;
end;

function MultipleDischargeFillUnitsEvent:new(vehicle, activeDischargeUnitIndex)
    local self = MultipleDischargeFillUnitsEvent:emptyNew();
	self.vehicle = vehicle;
	self.activeDischargeUnitIndex = activeDischargeUnitIndex;
    return self;
end;

function MultipleDischargeFillUnitsEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.vehicle);
	streamWriteUInt8(streamId, self.activeDischargeUnitIndex);
end;

function MultipleDischargeFillUnitsEvent:readStream(streamId, connection)
	self.vehicle = NetworkUtil.readNodeObject(streamId);
	self.activeDischargeUnitIndex = streamReadUInt8(streamId);
	self:run(connection);
end;

function MultipleDischargeFillUnitsEvent:run(connection)
	self.vehicle:setDischargeFillUnit(self.activeDischargeUnitIndex, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(MultipleDischargeFillUnitsEvent:new(self.vehicle, self.activeDischargeUnitIndex), nil, connection, self.vehicle);
	end;
end;

function MultipleDischargeFillUnitsEvent.sendEvent(vehicle, activeDischargeUnitIndex, noEventSend)
	if not noEventSend then
		if g_server ~= nil then
			g_server:broadcastEvent(MultipleDischargeFillUnitsEvent:new(vehicle, activeDischargeUnitIndex), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(MultipleDischargeFillUnitsEvent:new(vehicle, activeDischargeUnitIndex));
		end;
	end;
end;