-- author: Raphael Greshake
-- date: 02.07.2019

-- note: we always use the current dischargeNode

MultipleDischargeFillUnits = {}


function MultipleDischargeFillUnits.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(FillUnit, specializations) and SpecializationUtil.hasSpecialization(FillVolume, specializations)
	and SpecializationUtil.hasSpecialization(Dischargeable, specializations);
end;

function MultipleDischargeFillUnits.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", MultipleDischargeFillUnits)
    SpecializationUtil.registerEventListener(vehicleType, "onReadStream", MultipleDischargeFillUnits)
	SpecializationUtil.registerEventListener(vehicleType, "onWriteStream", MultipleDischargeFillUnits)
    SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", MultipleDischargeFillUnits)
    SpecializationUtil.registerEventListener(vehicleType, "onDischargeStateChanged", MultipleDischargeFillUnits)
end;

function MultipleDischargeFillUnits.registerFunctions(vehicleType)
	SpecializationUtil.registerFunction(vehicleType, "changeDischargeFillUnit", MultipleDischargeFillUnits.changeDischargeFillUnit);
	SpecializationUtil.registerFunction(vehicleType, "setDischargeFillUnit", MultipleDischargeFillUnits.setDischargeFillUnit);
end;

function MultipleDischargeFillUnits:onLoad(savegame)
	self.spec_multipleDischargeFillUnits = {}
	local spec = self.spec_multipleDischargeFillUnits;
	spec.actionEvents = {}
	
	local activatingFillUnitConfigIndices = Utils.getNoNil(getXMLString(self.xmlFile, "vehicle.multipleDischargeFillUnits#activatingFillUnitConfigIndices"), "1");
	local activatingIndices = {StringUtil.getVectorFromString(activatingFillUnitConfigIndices)}
	
	spec.usesMultipleDischargeFillUnits = false;
	
	local fillUnitConfigurationId = Utils.getNoNil(self.configurations["fillUnit"], 1);
	for a=1, #activatingIndices do
		if activatingIndices[a] == fillUnitConfigurationId then
			spec.usesMultipleDischargeFillUnits = true;
		end;
	end;
	
	spec.dischargeFillUnits = {}
	spec.activeDischargeUnitIndex = 1;
	
	local num = 0;
	while true do
		local key = "vehicle.multipleDischargeFillUnits.dischargeFillUnit("..tostring(num)..")";
		if not hasXMLProperty(self.xmlFile, key) then
			break;
		end;
		
		local unit = {}
		unit.fillUnitIndex = Utils.getNoNil(getXMLInt(self.xmlFile, key.."#fillUnitIndex"), 1);
		unit.displayName = g_i18n:getText(getXMLString(self.xmlFile, key.."#displayName"), self.customEnvironment);
		table.insert(spec.dischargeFillUnits, unit);
		
		num = num + 1;
	end;
end;

function MultipleDischargeFillUnits:onReadStream(streamId, connection)
    local activeDischargeFillUnit = streamReadUInt8(streamId);
    self:setDischargeFillUnit(activeDischargeFillUnit, true);
end

function MultipleDischargeFillUnits:onWriteStream(streamId, connection)
    local spec = self.spec_multipleDischargeFillUnits;
    streamWriteUInt8(streamId, spec.activeDischargeUnitIndex);
end

function MultipleDischargeFillUnits.changeDischargeFillUnit(self, actionName, inputValue, callbackState, isAnalog)
	local spec = self.spec_multipleDischargeFillUnits;
	if spec.usesMultipleDischargeFillUnits and self.spec_dischargeable.currentDischargeState == Dischargeable.DISCHARGE_STATE_OFF then
		spec.activeDischargeUnitIndex = spec.activeDischargeUnitIndex + 1;
		if spec.activeDischargeUnitIndex > #spec.dischargeFillUnits then
			spec.activeDischargeUnitIndex = 1;
		end;
		
		self:setDischargeFillUnit(spec.activeDischargeUnitIndex);
	end;
end;

function MultipleDischargeFillUnits:setDischargeFillUnit(unitIndex, noEventSend)
	local spec = self.spec_multipleDischargeFillUnits;

	if spec.usesMultipleDischargeFillUnits then
		spec.activeDischargeUnitIndex = unitIndex;
		
		local dischargeNode = self:getCurrentDischargeNode();
		dischargeNode.fillUnitIndex = spec.dischargeFillUnits[spec.activeDischargeUnitIndex].fillUnitIndex;
	
		local text = spec.dischargeFillUnits[spec.activeDischargeUnitIndex].displayName;
		g_inputBinding:setActionEventText(spec.actionEventId, text);
	end;
	
	if not noEventSend then
		MultipleDischargeFillUnitsEvent.sendEvent(self, spec.activeDischargeUnitIndex, noEventSend)
	end;
end;

function MultipleDischargeFillUnits:onDischargeStateChanged(dischargeState)
	g_inputBinding:setActionEventActive(self.spec_multipleDischargeFillUnits.actionEventId, dischargeState == Dischargeable.DISCHARGE_STATE_OFF);
end;

function MultipleDischargeFillUnits:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
	if self.isClient then
        local spec = self.spec_multipleDischargeFillUnits;
		if spec.usesMultipleDischargeFillUnits and self.spec_dischargeable.currentDischargeState == Dischargeable.DISCHARGE_STATE_OFF then
			self:clearActionEventsTable(spec.actionEvents);
			if isActiveForInputIgnoreSelection then 
				local _, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.IMPLEMENT_EXTRA2, self, MultipleDischargeFillUnits.changeDischargeFillUnit, false, true, false, true, nil)
				local text = spec.dischargeFillUnits[spec.activeDischargeUnitIndex].displayName;
				g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH)
				g_inputBinding:setActionEventText(actionEventId, text); 
				spec.actionEventId = actionEventId;
			end;
		end;
	end;
end;