--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 15.03.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 15.03.2018 - FS17 Release
V 1.1.0.0 @ 30.08.2019 - FS19 Release

Important:
No changes are to be made to this script without permission from GtX | Andy
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


HPS_SetEquipmentEvent = {}
HPS_SetEquipmentEvent_mt = Class(HPS_SetEquipmentEvent, Event)
InitEventClass(HPS_SetEquipmentEvent, "HPS_SetEquipmentEvent")

function HPS_SetEquipmentEvent:emptyNew()
    local self = Event:new(HPS_SetEquipmentEvent_mt)
    return self
end

function HPS_SetEquipmentEvent:new(object, equipmentInUse, currentUser)
    local self = HPS_SetEquipmentEvent:emptyNew()

    self.object = object
    self.equipmentInUse = equipmentInUse
    self.currentUser = currentUser

    return self
end

function HPS_SetEquipmentEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)
    self.equipmentInUse = streamReadBool(streamId)
    self.currentUser = NetworkUtil.readNodeObject(streamId)

    self:run(connection)
end

function HPS_SetEquipmentEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)
    streamWriteBool(streamId, self.equipmentInUse)
    NetworkUtil.writeNodeObject(streamId, self.currentUser)
end

function HPS_SetEquipmentEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.object)
    end

    self.object:setEquipmentUsed(self.equipmentInUse, self.currentUser, true)
end

function HPS_SetEquipmentEvent.sendEvent(object, equipmentInUse, currentUser, noEventSend)
    if equipmentInUse ~= object.equipmentInUse then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(HPS_SetEquipmentEvent:new(object, equipmentInUse, currentUser), nil, nil, object)
            else
                g_client:getServerConnection():sendEvent(HPS_SetEquipmentEvent:new(object, equipmentInUse, currentUser))
            end
        end
    end
end
