--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 15.03.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 15.03.2018 - FS17 Release
V 1.1.0.0 @ 30.08.2019 - FS19 Release

Important:
No changes are to be made to this script without permission from GtX | Andy
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


HPS_PalletInteractionEvent = {}
HPS_PalletInteractionEvent_mt = Class(HPS_PalletInteractionEvent, Event)
InitEventClass(HPS_PalletInteractionEvent, "HPS_PalletInteractionEvent")

function HPS_PalletInteractionEvent:emptyNew()
    local self = Event:new(HPS_PalletInteractionEvent_mt)
    return self
end

function HPS_PalletInteractionEvent:new(player, saplingPalletId, treeType)
    local self = HPS_PalletInteractionEvent:emptyNew()

    self.player = player
    self.saplingPalletId = saplingPalletId
    self.treeType = treeType

    return self
end

function HPS_PalletInteractionEvent:readStream(streamId, connection)
    self.player = NetworkUtil.readNodeObject(streamId)
    self.saplingPalletId = NetworkUtil.readNodeObjectId(streamId)
    self.treeType = streamReadInt8(streamId)

    self:run(connection)
end

function HPS_PalletInteractionEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.player)
    NetworkUtil.writeNodeObjectId(streamId, self.saplingPalletId)
    streamWriteInt8(streamId, self.treeType)
end

function HPS_PalletInteractionEvent:run(connection)
    if not connection:getIsServer() then
        local currentTool = self.player.baseInformation.currentHandtool
        if currentTool ~= nil and currentTool.isShovel then
            currentTool:setSaplingPalletLevel(self.saplingPalletId, self.treeType)
        end
    else
        print("  Error: [HPS_PalletInteractionEvent] This is a Client > Server event only!")
    end
end
