--
-- GlobalCompany - AddOn - Icons
--
-- @Interface: --
-- @Author: LS-Modcompany / aPuehri
-- @Date: 22.06.2019
-- @Version: 1.0.2.0
--
-- @Support: LS-Modcompany
--
-- Changelog:
--
-- 	v1.0.2.0 (22.06.2019)/(aPuehri):
-- 		- changed client detection
--		- raised modDesc version
--		- replaced some icons
--
-- 	v1.0.1.0 (31.05.2019)/(aPuehri):
-- 		- changed to only "Client-Side"
--
-- 	v1.0.0.0 (20.04.2019):
-- 		- initial Script Fs19 (aPuehri)
--		- Icons (Eribus)
--
-- Notes:
--
--
-- ToDo:
-- 
--
--

GC_AddOnIcon = {}

function GC_AddOnIcon:initGlobalCompany(customEnvironment, baseDirectory, xmlFile)
	if (g_company == nil) or (GC_AddOnIcon.isInitiated ~= nil) then
		return;
	end

	GC_AddOnIcon.debugIndex = g_company.debug:registerScriptName("GC_AddOnIcon");
	GC_AddOnIcon.modName = customEnvironment;
	GC_AddOnIcon.isInitiated = true;

	g_company.addInit(GC_AddOnIcon, GC_AddOnIcon.init);

	GC_AddOnIcon.defaultIconPath = baseDirectory .. "icons/";
	GC_AddOnIcon.userIconPath = getUserProfileAppPath() .. "GlobalCompany_UserIcon";
end

function GC_AddOnIcon:init()
	self.isServer = g_server ~= nil;
	self.isClient = g_dedicatedServerInfo == nil;
	self.isMultiplayer = g_currentMission.missionDynamicInfo.isMultiplayer;	

	if (g_company ~= nil) and self.isClient then
		self.debugData = g_company.debug:getDebugData(GC_AddOnIcon.debugIndex, nil, GC_AddOnIcon.modName);
	
		-- check if userHelpFile exist or create Folder
		local copiedUserHelpFile = Utils.getFilename("GC_AddOnIcon_Help.txt", GC_AddOnIcon.userIconPath .. "/");
		if not fileExists(copiedUserHelpFile) then
			g_company.debug:writeInformations(self.debugData, "create userIconPath = %s , please note GC_AddOnIcon_Help.txt !!", GC_AddOnIcon.userIconPath);
			createFolder(GC_AddOnIcon.userIconPath);
			local sourceUserHelpFile = Utils.getFilename("GC_AddOnIcon_Help.txt", GC_AddOnIcon.defaultIconPath);
			if fileExists(sourceUserHelpFile) then
				copyFile(sourceUserHelpFile, copiedUserHelpFile, true);
			end;
		end;

		-- check fillTypes
		for i=1, #g_currentMission.fillTypeManager.fillTypes do
			if (g_currentMission.fillTypeManager.fillTypes[i].hudOverlayFilename ~= nil) and (g_currentMission.fillTypeManager.fillTypes[i].hudOverlayFilenameSmall ~= nil) then
				local fillTypeName = string.lower(g_currentMission.fillTypeManager.fillTypes[i].name);
				local iconPath = GC_AddOnIcon:getHudOverlayFilename(fillTypeName);
				local iconPathSmall = GC_AddOnIcon:getHudOverlayFilenameSmall(fillTypeName);
				if (iconPath ~= nil) then
					g_currentMission.fillTypeManager.fillTypes[i].hudOverlayFilename = iconPath; -- replace hudOverlayFilename
				else
					if (fillTypeName ~= nil) and (fillTypeName ~= "unknown") then
						g_company.debug:writeInformations(self.debugData, "no icon found for filltype = %s !! -- iconname should be hud_fill_%s.dds", fillTypeName, fillTypeName);
					end;
				end;
				if (iconPathSmall ~= nil) then
					g_currentMission.fillTypeManager.fillTypes[i].hudOverlayFilenameSmall = iconPathSmall; -- replace hudOverlayFilenameSmall
				else
					if (fillTypeName ~= nil) and (fillTypeName ~= "unknown") then
						g_company.debug:writeInformations(self.debugData, "no small icon found for filltype = %s !! -- iconname should be hud_fill_%s_sml.dds", fillTypeName, fillTypeName);
					end;
				end;				
			end;
			-- gc_debugPrint(string.lower(g_currentMission.fillTypeManager.fillTypes[i].name), nil, nil, "GC_AddOnIcon - fruitname");
			-- gc_debugPrint(g_currentMission.fillTypeManager.fillTypes[i].hudOverlayFilename, nil, nil, "GC_AddOnIcon - hudOverlayFilename");
			-- gc_debugPrint(g_currentMission.fillTypeManager.fillTypes[i].hudOverlayFilenameSmall, nil, nil, "GC_AddOnIcon - hudOverlayFilenameSmall");			
		end;

		-- check Icons on Page Map Overview
		for i=1, #g_currentMission.inGameMenu.pageMapOverview.displayCropTypes do
			if (g_currentMission.inGameMenu.pageMapOverview.displayCropTypes[i].iconFilename ~= nil) then
				local index = g_currentMission.inGameMenu.pageMapOverview.displayCropTypes[i].fruitTypeIndex;
				if (index ~= nil) then
					local iconPathSmall = GC_AddOnIcon:getHudOverlayFilenameSmall(string.lower(g_currentMission.fruitTypeManager.indexToFruitType[index].name));
					if (iconPathSmall ~= nil) then
						g_currentMission.inGameMenu.pageMapOverview.displayCropTypes[i].iconFilename = iconPathSmall; -- replace Icon in Map Overview
					end;
				end;
			end;
			-- gc_debugPrint(g_currentMission.inGameMenu.pageMapOverview.displayCropTypes[i].iconFilename, nil, nil, "GC_AddOnIcon Map Overview - hudOverlayFilenameSmall");
		end;
		
		-- FillLevelsDisplay
		local fillLevelDisplay= g_currentMission.hud.fillLevelsDisplay;
		if (fillLevelDisplay ~= nil) then
			if (fillLevelDisplay.fillTypeFrames ~= nil) then
				for _, v in pairs(fillLevelDisplay.fillTypeFrames) do
					v:delete();
				end;
			end;			
			local posX, posY = fillLevelDisplay:getPosition();
			if (posX ~= nil) and (posY ~= nil) then
				fillLevelDisplay:createFillTypeFrames(g_currentMission.fillTypeManager, fillLevelDisplay.hudAtlasPath, posX, posY);
			end;
		end;
	end
end

function GC_AddOnIcon:getHudOverlayFilename(name)
	if (name ~= nil) then
		local fillTypeName= GC_AddOnIcon:changeFillTypeName(name);
		local defaultIconPath = Utils.getFilename("hud_fill_".. fillTypeName .. ".dds", GC_AddOnIcon.defaultIconPath);
		local userIconPath = Utils.getFilename("hud_fill_".. fillTypeName .. ".dds", GC_AddOnIcon.userIconPath .. "/");

		if fileExists(userIconPath) then
			return userIconPath;
		elseif fileExists(defaultIconPath) then
			return defaultIconPath;
		end;
	end;

	return nil;
end;

function GC_AddOnIcon:getHudOverlayFilenameSmall(name)
	if (name ~= nil) then
		local fillTypeName= GC_AddOnIcon:changeFillTypeName(name);
		local defaultIconPath = Utils.getFilename("hud_fill_".. fillTypeName .. "_sml.dds", GC_AddOnIcon.defaultIconPath);
		local userIconPath = Utils.getFilename("hud_fill_".. fillTypeName .. "_sml.dds", GC_AddOnIcon.userIconPath .. "/");

		if fileExists(userIconPath) then
			return userIconPath;
		elseif fileExists(defaultIconPath) then
			return defaultIconPath;
		end;
	end;

	return nil;	
end;

function GC_AddOnIcon:changeFillTypeName(name)
	--change fillTypeName for 'roundbale_ ...'
	if string.match(name, "roundbale_") ~= nil then
		return "roundbale"
	end;

	--change fillTypeName for 'squarebale_ ...'
	if string.match(name, "squarebale_") ~= nil then
		return "squarebale"
	end;

	--change fillTypeName for 'horse_ ...'
	if string.match(name, "horse_") ~= nil then
		return "horse"
	end;	
	
	--change fillTypeName for 'cow_ ...'
	if string.match(name, "cow_") ~= nil then
		return "cow"
	end;

	--change fillTypeName for 'sheep_ ...'
	if string.match(name, "sheep_") ~= nil then
		return "sheep"
	end;	

	--change fillTypeName for 'pig_ ...'
	if string.match(name, "pig_") ~= nil then
		return "pig"
	end;	

	--change fillTypeName for 'chicken_ ...'
	if string.match(name, "chicken_") ~= nil then
		return "chicken"
	end;	

	return name;
end;
