--
-- FS19 - Manual Cutting for Wood Harvester
-- @author:    	Ifko[nator], t0xic0m, kenny456 - FS19 conversion (kenny456@seznam.cz)
-- @history:	v1.0 - 2018-12-29 - converted to FS19
--
HarvesterAttachment = {};

function HarvesterAttachment.prerequisitesPresent(specializations)
	return true;
	-- return SpecializationUtil.hasSpecialization(WoodHarvester, specializations);
end

function HarvesterAttachment.initSpecialization()
end

function HarvesterAttachment.registerOverwrittenFunctions(vehicleType)
end

function HarvesterAttachment.registerFunctions(vehicleType)
end

function HarvesterAttachment.registerEvents(vehicleType)
end

function HarvesterAttachment:registerActionEventsPlayer()
end

function HarvesterAttachment:registerActionEventsMenu()
end
function HarvesterAttachment:onRegisterActionEvents(isSelected, isOnActiveVehicle)
end

function HarvesterAttachment.registerEventListeners(vehicleType)
    EL = vehicleType.eventListeners
    table.insert(EL.onLoad, HarvesterAttachment)
    table.insert(EL.onUpdate, HarvesterAttachment)
    table.insert(EL.onDraw, HarvesterAttachment)
    table.insert(EL.onRegisterActionEvents, HarvesterAttachment)
end

function HarvesterAttachment:onLoad(vehicle)
	self.onDelimbTree = Utils.overwrittenFunction(self.onDelimbTree, HarvesterAttachment.NEWonDelimbTree);
	self.readyCut = 0;
	--self.cutMaxRadius = 0.68;
	--self.cutLengthMin = 1.20;
	--self.cutLengthMax = 18.20;
	--self.cutLengthStep = 1;
end

function HarvesterAttachment:NEWonDelimbTree(onDelimbTree, state)
	if self.spec_woodHarvester then
		self.spec_woodHarvester.isAttachedSplitShapeMoving = state;
		if not state then
			if self.readyCut == 1 then
				self:cutTree(0);
				self.readyCut = 0;
			else
				self.readyCut = 1;
			end;
		end;
	end;
end;

function HarvesterAttachment:onUpdate()
	if self.spec_woodHarvester then
		if self.spec_woodHarvester.attachedSplitShape == nil and self.readyCut == 1 then
			self.readyCut = 0;
		end;
	end;
end

function HarvesterAttachment:onDraw()
end
