--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 15.03.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 15.03.2018 - FS17 Release
V 1.1.0.0 @ 30.08.2019 - FS19 Release

Important:
No changes are to be made to this script without permission from GtX | Andy
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


HPS_UpdateBackpackEvent = {}
HPS_UpdateBackpackEvent_mt = Class(HPS_UpdateBackpackEvent, Event)
InitEventClass(HPS_UpdateBackpackEvent, "HPS_UpdateBackpackEvent")

function HPS_UpdateBackpackEvent:emptyNew()
    local self = Event:new(HPS_UpdateBackpackEvent_mt)
    return self
end

function HPS_UpdateBackpackEvent:new(object, fillLevel, treeType)
    local self = HPS_UpdateBackpackEvent:emptyNew()

    self.object = object
    self.fillLevel = fillLevel
    self.treeType = treeType

    return self
end

function HPS_UpdateBackpackEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)
    self.fillLevel = streamReadInt8(streamId)
    self.treeType = streamReadInt8(streamId)

    self:run(connection)
end

function HPS_UpdateBackpackEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)
    streamWriteInt8(streamId, self.fillLevel)
    streamWriteInt8(streamId, self.treeType)
end

function HPS_UpdateBackpackEvent:run(connection)
    if self.object ~= nil then
        if not connection:getIsServer() then
            g_server:broadcastEvent(self, false, connection, self.object)
        end

        self.object:updateBackpack(self.fillLevel, self.treeType, true)
    end
end

function HPS_UpdateBackpackEvent.sendEvent(object, fillLevel, treeType, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(HPS_UpdateBackpackEvent:new(object, fillLevel, treeType), nil, nil, object)
        else
            g_client:getServerConnection():sendEvent(HPS_UpdateBackpackEvent:new(object, fillLevel, treeType))
        end
    end
end
