--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 15.03.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 15.03.2018 - FS17 Release
V 1.1.0.0 @ 30.08.2019 - FS19 Release

Important:
No changes are to be made to this script without permission from GtX | Andy
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


HPS_SetUserEvent = {}
HPS_SetUserEvent_mt = Class(HPS_SetUserEvent, Event)
InitEventClass(HPS_SetUserEvent, "HPS_SetUserEvent")

function HPS_SetUserEvent:emptyNew()
    local self = Event:new(HPS_SetUserEvent_mt)
    return self
end

function HPS_SetUserEvent:new(object, adminOnly)
    local self = HPS_SetUserEvent:emptyNew()

    self.object = object
    self.adminOnly = adminOnly

    return self
end

function HPS_SetUserEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)
    self.adminOnly = streamReadBool(streamId)

    self:run(connection)
end

function HPS_SetUserEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)
    streamWriteBool(streamId, self.adminOnly)
end

function HPS_SetUserEvent:run(connection)
    if self.object ~= nil then
        if not connection:getIsServer() then
            g_server:broadcastEvent(self, false, connection, self.object)
        end

        self.object.adminUsersOnly = self.adminOnly
    end
end
