--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 15.03.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 15.03.2018 - FS17 Release
V 1.1.0.0 @ 30.08.2019 - FS19 Release

Important:
No changes are to be made to this script without permission from GtX | Andy
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


HPS_PlantSaplingEvent = {}
HPS_PlantSaplingEvent_mt = Class(HPS_PlantSaplingEvent, Event)
InitEventClass(HPS_PlantSaplingEvent, "HPS_PlantSaplingEvent")

function HPS_PlantSaplingEvent:emptyNew()
    local self = Event:new(HPS_PlantSaplingEvent_mt)
    return self
end

function HPS_PlantSaplingEvent:new(player, treeType, x, y, z, backpackFillLevel)
    local self = HPS_PlantSaplingEvent:emptyNew()

    self.player = player
    self.treeType = treeType
    self.x = x
    self.y = y
    self.z = z
    self.backpackFillLevel = backpackFillLevel

    return self
end

function HPS_PlantSaplingEvent:readStream(streamId, connection)
    self.player = NetworkUtil.readNodeObject(streamId)
    self.treeType = streamReadInt8(streamId)
    self.x = streamReadFloat32(streamId)
    self.y = streamReadFloat32(streamId)
    self.z = streamReadFloat32(streamId)
    self.backpackFillLevel = streamReadInt8(streamId)

    self:run(connection)
end

function HPS_PlantSaplingEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.player)
    streamWriteInt8(streamId, self.treeType)
    streamWriteFloat32(streamId, self.x)
    streamWriteFloat32(streamId, self.y)
    streamWriteFloat32(streamId, self.z)
    streamWriteInt8(streamId, self.backpackFillLevel)
end

function HPS_PlantSaplingEvent:run(connection)
    if g_server ~= nil and self.player ~= nil then
        local currentTool = self.player.baseInformation.currentHandtool
        if currentTool ~= nil and currentTool.isShovel then
            if currentTool.storageArea ~= nil then
                currentTool:plantSapling(self.treeType, self.x, self.y, self.z, self.backpackFillLevel)
            else
                print("  Warning: [HPS_PlantSaplingEvent] No 'storageArea' found or given. Planting failed!")
            end
        end
    else
        if g_server == nil then
            print("  Error: [HPS_PlantSaplingEvent] This is a Client > Server event only!")
        else
            print("  Warning: [HPS_PlantSaplingEvent] No 'shovel' player found or given. Planting failed!")
        end
    end
end
