--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 28.08.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 28.08.2019 - FS19 Release

Important:
No changes are to be made to this script without permission from GtX | Andy
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]

local modName = g_currentModName
local modDir = g_currentModDirectory
local placeablePath = modDir .. "scripts/HandPlantSaplings.lua"

local sourceFiles = {
    "scripts/HandPlantSaplingsShovel.lua",
    "scripts/events/HPS_PalletInteractionEvent.lua",
    "scripts/events/HPS_PlantSaplingEvent.lua",
    "scripts/events/HPS_SetEquipmentEvent.lua",
    "scripts/events/HPS_SetUserEvent.lua",
    "scripts/events/HPS_UpdateBackpackEvent.lua",
    "scripts/events/HPS_UpdateStorageEvent.lua"
}

function init()
    if fileExists(placeablePath) then
        local xmlFile = loadXMLFile("TempModDesc", modDir .. "modDesc.xml")
        if xmlFile ~= 0 then
            local handToolPath = getXMLString(xmlFile, "modDesc.handPlantSaplings#handToolPath")
            if handToolPath ~= nil then
                local handToolFilename = modDir .. handToolPath

                g_placeableTypeManager:addPlaceableType("handPlantSaplings", "HandPlantSaplings", placeablePath)

                for i = 1, #sourceFiles do
                    source(modDir .. sourceFiles[i])
                end

                -- Only good solution. Giants do not share any of the 'Farm.lua' code so I can not ignore on save as I would want.
                -- Only an issue if saved when shovel is being carried, so this is a backup fix anyway just to be sure.
                if g_handPlantSaplingsTools == nil then
                    getfenv(0)["g_handPlantSaplingsTools"] = {[handToolFilename] = modName}

                    Farm.loadFromXMLFile = Utils.overwrittenFunction(Farm.loadFromXMLFile, farmLoadFromXMLFile)
                    FSBaseMission.delete = Utils.appendedFunction(FSBaseMission.delete, missionDelete)
                else
                    g_handPlantSaplingsTools[handToolFilename] = modName
                end
            end

            delete(xmlFile)
            xmlFile = nil
        end
    else
        local path = modDir .. "scripts/"
        print("  Error: [" .. modName .. "] HandPlantSaplings.lua was not found at %s ", path)
    end
end

function farmLoadFromXMLFile(farm, superFunc, xmlFile, key)
    local success = superFunc(farm, xmlFile, key)

    if success and g_handPlantSaplingsTools ~= nil then
        if farm.handTools ~= nil and #farm.handTools > 0 then
            for key, xmlFilename in pairs (farm.handTools) do
                if g_handPlantSaplingsTools[xmlFilename] ~= nil then
                    -- table.remove(farm.handTools, key)
                    farm:removeHandTool(xmlFilename)
                end
            end
        end
    end

    return success
end

function missionDelete(mission)
    if g_handPlantSaplingsTools ~= nil then
        getfenv(0)["g_handPlantSaplingsTools"] = nil
    end
end

init()
