--[[
Interface: 1.5.1.0 b6732

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 12.11.2018
Version: 1.0.0.0

History:
V 1.0.0.0 @ 12.11.2018 - Release Version
V 1.0.1.0 @ 07.09.2019 - Add support for hand 'poseId'.

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy


Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


UP_Creator = {}
local UP_Creator_mt = Class(UP_Creator)

-- Use my own 'keyEvent' so no inputBindings need to be created for these functions.
UP_Creator.inputKeys = {
    [270] = "NUM+",
    [269] = "NUM-",
    [260] = "NUM_LEFT",
    [262] = "NUM_RIGHT",
    [264] = "NUM_UP",
    [258] = "NUM_DOWN",
    [265] = "NUMPAD_9",
    [263] = "NUMPAD_7",
    [256] = "NUMPAD_0",
    [268] = "NUMPAD_MULTIPLY",
    [267] = "NUMPAD_DIVIDE"
}

UP_Creator.poseIdToIndex = {
    ["narrowFingers"] = 1,
    ["wideFingers"] = 2,
    ["flatFingers"] = 3
}

UP_Creator.poseIndexToId = {
    "narrowFingers",
    "wideFingers",
    "flatFingers"
}

UP_Creator.activeInputKeys = {}
UP_Creator.activeInputKeysCounter = {}

function UP_Creator:new()
    if g_universalPassenger == nil or g_universalPassenger.creator ~= nil then
        return
    end

    local self = {}
    setmetatable(self, UP_Creator_mt)

    self.isDev = false
    self.listActive = false
    self.infoActive = false

    self.active = false
    self.firstTimeRun = true
    self.charMovementActive = false
    self.actionEventsRegistered = false

    return self
end

function UP_Creator:load()
    addConsoleCommand("upEnablePassengerCommands", "Enable / Disable 'Universal Passenger' development commands. ", "consoleCommandEnablePassengerCommands", self)

    self.raycastNodeErrors = 0

    self.updateMode = 1
    self.movmentFactor = 0.005
    self.transPassengerMode = true
    self.transCameraMode = true
    self.transPassengerPartsMode = true
    self.bodyPart = 1

    self.bodyPartName = {"rightFoot", "leftFoot", "rightArm", "leftArm"}
    self.oppositePartName = {["rightFoot"] = "leftFoot", ["leftFoot"] = "rightFoot", ["rightArm"] = "leftArm", ["leftArm"] = "rightArm"}

    self.vehicles = {}

    return true
end

function UP_Creator:consoleCommandEnablePassengerCommands()
    if g_currentMission:getIsServer() and not g_currentMission.missionDynamicInfo.isMultiplayer then
        if self.active then
            self:removeConsoleCommands(false)
            self.vehicleList = nil

            local returnText = ""
            if self.charMovementActive then
                self.currentVehicle = nil
                self.currentSeatId = nil
                self.charMovementActive = false
                returnText = "CAUTION: Any movement to your passenger vehicles passenger indoor camera will affect your XML save if it is not already completed.\n"
            end

            self.active = false

            return returnText .. "'Universal Passenger' development commands disabled."
        else
            self.active = true

            if self.firstTimeRun then
                self.firstTimeRun = false
                Enterable.onLoad = Utils.prependedFunction(Enterable.onLoad, UP_Creator.collectXmlData)
            end

            addConsoleCommand("upClearAllStoredSeats", "Clear all saved seat data.", "consoleCommandClearVehicleInfoTable", self)
            addConsoleCommand("upActivateSetupMovement", "Enable / Disable movement controls.", "consoleCommandActivateSetupMovement", self)

            addConsoleCommand("upReloadVehicleFiles", "Reload Base Vehicle XML file. [reloadAddonFiles]", "consoleCommandReloadGlobalVehicleFiles", self)

            addConsoleCommand("upStorePassengerSeats", "Store the passenger and camera position information for the current vehicle. [forceCreateXML] [cameraFromSeatPosition] [useSeatZ]", "consoleCommandStorePassengerSeats", self)
            addConsoleCommand("upCreateXmlFromStoredPassengerSeats", "Create XML from saved seat data. Warning: Possible Heavy PC Load!", "consoleCommandCreatePassengerSeatsXML", self)

            if false and UniversalPassenger.LOG_LEVEL[4] == true then
                self.isDev = true
                self:loadVehicleList()

                addConsoleCommand("upCreateXmlFromList", "(Dev Control) Create XML from list. [useSeatZ]", "consoleCommandCreatePassengerSeatsFromList", self)
                addConsoleCommand("upReloadVehicleList", "(Dev Control) Reload the standard vehicle list.", "consoleCommandReloadStandardVehicleList", self)
                addConsoleCommand("upCreateListFromSpawnedVehicles", "(Dev Control) Create new list from spawned steerable vehicles 'passenger will be in driver position'. [forceCreateXML] [useSeatZ]", "consoleCommandCreateListFromSpawnedVehicles", self)
                addConsoleCommand("upStoreAllSpawnedVehiclesPassengerSeats", "(Dev Control) Store the passenger and camera position information for all vehicles. [forceCreateXML] [cameraFromSeatPosition] [useSeatZ]", "consoleCommandStoreAllVehiclesPassengerSeats", self)
            end

            return "'Universal Passenger' development commands enabled."
        end
    end

    return
end

function UP_Creator:registerActionEvents()
    local actionEventId

    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.TOGGLE_BEACON_LIGHTS, self, UP_Creator.actionEventPrintSeatData, false, true, false, true, nil)
    g_inputBinding:setActionEventText(actionEventId, "Print seat & camera2 XYZ data")
    g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    self.doPrintSeatData = actionEventId

    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.ATTACH, self, UP_Creator.actionEventUpdateMode, false, true, false, true, nil)
    g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    self.setUpdateMode = actionEventId

    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.TOGGLE_TURNLIGHT_RIGHT, self, UP_Creator.actionEventMovmentSpeed, false, true, false, true, nil)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.TOGGLE_TURNLIGHT_LEFT, self, UP_Creator.actionEventMovmentSpeed, false, true, false, true, nil)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)


    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.IMPLEMENT_EXTRA4, self, UP_Creator.actionEventAdjustPassenger, false, true, false, true, nil)
    g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    self.adjustPassenger = actionEventId

    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.IMPLEMENT_EXTRA3, self, UP_Creator.actionEventAdjustPassengerPart, false, true, false, true, nil)
    g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    self.adjustPassengerPart = actionEventId

    self.actionEventsRegistered = true
end

function UP_Creator.actionEventPrintSeatData(self, actionName, inputValue, callbackState, isAnalog)
    if self.currentVehicle ~= nil and self.currentSeatId ~= nil then
        local spec = self.currentVehicle.spec_universalPassenger
        local seat = spec.passengerSeats[self.currentSeatId]

        local storeItem = g_storeManager:getItemByXMLFilename(self.currentVehicle.configFileName:lower())
        local printData = string.format("\n - Giants Editor Data  ( %s - %s ) -", g_brandManager:getBrandByIndex(storeItem.brandIndex).name, storeItem.name)
        local core = self:getTransRotXYZPrint(seat)

        printData = printData .. core

        local changesTable = self:getCharacterChanges(self.currentVehicle.configFileName, seat, self.currentSeatId, true)
        if changesTable ~= nil then
            printData = printData .. "\n - Passenger Body Parts - \n"
            for name, change in pairs (changesTable) do
                if (change.poseId == nil) or (change.poseId == "") then
                    printData = printData .. string.format("Passenger %s ( %s ) Position = %s  |  Rotation = %s \n", seat.id, name, change.position, change.rotation)
                else
                    printData = printData .. string.format("Passenger %s ( %s ) Position = %s  |  Rotation = %s  |  Finger Pose Id = %s\n", seat.id, name, change.position, change.rotation, change.poseId)
                end
            end
        end

        print(printData .. "\n - Giants Editor Data  ( END ) - \n")
    end
end

function UP_Creator.actionEventUpdateMode(self, actionName, inputValue, callbackState, isAnalog)
    if self.currentVehicle ~= nil and self.currentSeatId ~= nil then
        self.updateMode = self.updateMode + 1
        if self.updateMode > 3 then
            self.updateMode = 1
        end
    end
end

function UP_Creator.actionEventMovmentSpeed(self, actionName, inputValue, callbackState, isAnalog)
    if self.currentVehicle ~= nil and self.currentSeatId ~= nil then
        if actionName == "TOGGLE_TURNLIGHT_RIGHT" then
            if self.movmentFactor == 0.001 then self.movmentFactor = 0.0 end
            local new = self.movmentFactor + 0.005
            self.movmentFactor = math.min(new, 0.1)
        elseif actionName == "TOGGLE_TURNLIGHT_LEFT" then
            local new = self.movmentFactor - 0.005
            self.movmentFactor = math.max(new, 0.001)
        end
    end
end

function UP_Creator.actionEventAdjustPassenger(self, actionName, inputValue, callbackState, isAnalog)
    if self.currentVehicle ~= nil and self.currentSeatId ~= nil then
        if self.updateMode == 1 then
            self.transPassengerMode = not self.transPassengerMode;
        elseif self.updateMode == 2 then
            self.transPassengerPartsMode = not self.transPassengerPartsMode;
        elseif self.updateMode == 3 then
            self.transCameraMode = not self.transCameraMode;
        end;
    end
end

function UP_Creator.actionEventAdjustPassengerPart(self, actionName, inputValue, callbackState, isAnalog)
    if self.currentVehicle ~= nil and self.currentSeatId ~= nil then
        self.bodyPart = self.bodyPart + 1

        if self.bodyPart > 4 then
            self.bodyPart = 1
        end
    end
end

function UP_Creator.inputHasEvent(eventName, ignorePress)
    if UP_Creator.activeInputKeys[eventName] == true then
        UP_Creator.activeInputKeysCounter[eventName] = UP_Creator.activeInputKeysCounter[eventName] + 1

        if UP_Creator.activeInputKeysCounter[eventName] == 1 or UP_Creator.activeInputKeysCounter[eventName] > 40 then
            if ignorePress then
                UP_Creator.activeInputKeys[eventName] = false
            end

            return true
        end
    end

    return false
end

function UP_Creator:keyEvent(unicode, sym, modifier, isDown)
    if not g_currentMission:getIsServer() or (self.currentVehicle == nil or self.currentSeatId == nil) then
        return
    end

    local eventName = UP_Creator.inputKeys[sym]
    if eventName ~= nil and self.charMovementActive then
        if isDown then
            UP_Creator.activeInputKeys[eventName] = true
            UP_Creator.activeInputKeysCounter[eventName] = 0
        else
            UP_Creator.activeInputKeys[eventName] = false
        end
    end
end

function UP_Creator:update(dt)
    self.currentVehicle = g_universalPassenger.currentPassengerVehicle
    self.currentSeatId = g_universalPassenger.currentPassengerSeatId

    if self.currentVehicle ~= nil and self.currentSeatId ~= nil then
        if not self.actionEventsRegistered then
            self:registerActionEvents()
        end

        local spec = self.currentVehicle.spec_universalPassenger
        local seat = spec.passengerSeats[self.currentSeatId]

        if self.updateMode == 1 or self.updateMode == 2 then
            -- Allow zoom to go in further so we can move player easy.
            if seat.cameras[1].oldTransMin == nil then
                seat.cameras[1].oldTransMin = seat.cameras[1].transMin
                seat.cameras[1].transMin = 0
            end

            if seat.passengerCharacter.oldCharacterCameraMinDistance == nil then
                seat.passengerCharacter.oldCharacterCameraMinDistance = seat.passengerCharacter.characterCameraMinDistance
                seat.passengerCharacter.characterCameraMinDistance = 0
            end

            if seat.cameraIndex ~= 1 then
                self.currentVehicle:setPassengerCameraIndex(seat, 1)
            end

            spec.normalCamMode = true

            local camSet = false
            if seat.oldCameraData == nil then
                local trans = {getTranslation(seat.cameras[1].rotateNode)}
                local rot = {getRotation(seat.cameras[1].rotateNode)}
                seat.oldCameraData = {trans = trans, rot = rot}
                camSet = true
            end

            g_currentMission:addExtraPrintText("Use NumPad / to target 'Character Node'")

            if UP_Creator.inputHasEvent("NUMPAD_DIVIDE", false) then
                setTranslation(seat.cameras[1].rotateNode, getTranslation(seat.i3dCharacterNode))
                setRotation(seat.cameras[1].rotateNode, getTranslation(seat.i3dCharacterNode))
            end
        else
            if seat.passengerCharacter.oldCharacterCameraMinDistance ~= nil then
                seat.passengerCharacter.characterCameraMinDistance = seat.passengerCharacter.oldCharacterCameraMinDistance
                seat.passengerCharacter.oldCharacterCameraMinDistance = nil
            end
        end

        local factor = self.movmentFactor
        if self.updateMode == 1 then -- Passenger Adjustment
            g_inputBinding:setActionEventText(self.setUpdateMode, "Activate Passenger Part Adjustment")

            if self.transPassengerMode then
                g_inputBinding:setActionEventText(self.adjustPassenger, "Activate Passenger Rotation")
                g_currentMission:addExtraPrintText("Use NumPad Arrows and + - to move.")

                local x, y, z = getTranslation(seat.i3dCharacterNode)
                if UP_Creator.inputHasEvent("NUM+") then
                    setTranslation(seat.i3dCharacterNode, x, y + factor, z)
                end

                if UP_Creator.inputHasEvent("NUM-") then
                    setTranslation(seat.i3dCharacterNode, x, y - factor, z)
                end

                if UP_Creator.inputHasEvent("NUM_UP") then
                    setTranslation(seat.i3dCharacterNode, x, y, z + factor)
                end

                if UP_Creator.inputHasEvent("NUM_DOWN") then
                    setTranslation(seat.i3dCharacterNode, x, y, z - factor)
                end

                if UP_Creator.inputHasEvent("NUM_LEFT") then
                    setTranslation(seat.i3dCharacterNode, x + factor, y, z)
                end

                if UP_Creator.inputHasEvent("NUM_RIGHT") then
                    setTranslation(seat.i3dCharacterNode, x - factor, y, z)
                end

                x, y, z = UP_Creator.getRoundedTable({x, y, z}, 3, false)
                g_currentMission:addExtraPrintText("X Y Z = " .. tostring(x) .. " | " .. tostring(y) .. " | " .. tostring(z))
            else
                g_inputBinding:setActionEventText(self.adjustPassenger, "Activate Passenger Translation")
                g_currentMission:addExtraPrintText("Use NumPad Arrows to rotate.")

                local rx, ry, rz = getRotation(seat.i3dCharacterNode)
                if UP_Creator.inputHasEvent("NUM_UP") then
                    rx = UP_Creator.getCorrectedRotation(rx, factor, true)
                    setRotation(seat.i3dCharacterNode, rx, ry, rz)
                end

                if UP_Creator.inputHasEvent("NUM_DOWN") then
                    rx = UP_Creator.getCorrectedRotation(rx, factor, false)
                    setRotation(seat.i3dCharacterNode, rx, ry, rz)
                end

                if UP_Creator.inputHasEvent("NUM_LEFT") then
                    ry = UP_Creator.getCorrectedRotation(ry, factor, true)
                    setRotation(seat.i3dCharacterNode, rx, ry, rz)
                end

                if UP_Creator.inputHasEvent("NUM_RIGHT") then
                    ry = UP_Creator.getCorrectedRotation(ry, factor, false)
                    setRotation(seat.i3dCharacterNode, rx, ry, rz)
                end

                rx, ry, rz = UP_Creator.getRoundedTable({rx, ry, rz}, 3, true)
                g_currentMission:addExtraPrintText("RX RY RZ = " .. tostring(rx) .. " | " .. tostring(ry) .. " | " .. tostring(rz))
            end
        elseif self.updateMode == 2 then -- Passenger Part Adjustment
            g_inputBinding:setActionEventText(self.setUpdateMode, "Activate Inside Camera Adjustment")

            self:storeCharacterTargetNodes(self.currentVehicle.configFileName, seat, self.currentSeatId)

            local pushChanges = false
            local part = self.bodyPartName[self.bodyPart]

            if self.transPassengerPartsMode then
                g_inputBinding:setActionEventText(self.adjustPassenger, "Activate Body Part Rotation")
                g_currentMission:addExtraPrintText("Use NumPad Arrows and + - to move.")
                g_currentMission:addExtraPrintText("Use NumPad * to copy " .. self.oppositePartName[part] .. " translation.")

                if UP_Creator.inputHasEvent("NUMPAD_MULTIPLY", false) then
                    local cx, cy, cz = getTranslation(seat.passengerCharacter.ikChainTargets[self.oppositePartName[part]].targetNode)
                    setTranslation(seat.passengerCharacter.ikChainTargets[part].targetNode, -cx, cy, cz)
                    pushChanges = true
                end

                local x, y, z = getTranslation(seat.passengerCharacter.ikChainTargets[part].targetNode)
                if UP_Creator.inputHasEvent("NUM+") then
                    setTranslation(seat.passengerCharacter.ikChainTargets[part].targetNode, x, y + factor, z)
                    pushChanges = true
                end

                if UP_Creator.inputHasEvent("NUM-") then
                    setTranslation(seat.passengerCharacter.ikChainTargets[part].targetNode, x, y - factor, z)
                    pushChanges = true
                end

                if UP_Creator.inputHasEvent("NUM_UP") then
                    setTranslation(seat.passengerCharacter.ikChainTargets[part].targetNode, x, y, z + factor)
                    pushChanges = true
                end

                if UP_Creator.inputHasEvent("NUM_DOWN") then
                    setTranslation(seat.passengerCharacter.ikChainTargets[part].targetNode, x, y, z - factor)
                    pushChanges = true
                end

                if UP_Creator.inputHasEvent("NUM_LEFT") then
                    setTranslation(seat.passengerCharacter.ikChainTargets[part].targetNode, x + factor, y, z)
                    pushChanges = true
                end

                if UP_Creator.inputHasEvent("NUM_RIGHT") then
                    setTranslation(seat.passengerCharacter.ikChainTargets[part].targetNode, x - factor, y, z)
                    pushChanges = true
                end

                x, y, z = UP_Creator.getRoundedTable({x, y, z}, 3, false)
                g_currentMission:addExtraPrintText("X Y Z = " .. tostring(x) .. " | " .. tostring(y) .. " | " .. tostring(z))
            else
                g_inputBinding:setActionEventText(self.adjustPassenger, "Activate Body Part Translation")
                g_currentMission:addExtraPrintText("Use NumPad Arrows and + - to rotate.")
                -- g_currentMission:addExtraPrintText("Use NumPad * to copy " .. self.oppositePartName[part] .. " rotation.")
                g_currentMission:addExtraPrintText("Use NumPad 7 & 9 for Z Spine Rotation")

                if UP_Creator.inputHasEvent("NUMPAD_9") then
                    seat.passengerCharacter.characterSpineRotation[3] = seat.passengerCharacter.characterSpineRotation[3] + math.rad(1)
                    pushChanges = true
                elseif UP_Creator.inputHasEvent("NUMPAD_7") then
                    seat.passengerCharacter.characterSpineRotation[3] = seat.passengerCharacter.characterSpineRotation[3] - math.rad(1)
                    pushChanges = true
                end

                -- if UP_Creator.inputHasEvent("NUMPAD_MULTIPLY", false) then
                    -- local crx, cry, crz = getRotation(seat.passengerCharacter.ikChainTargets[self.oppositePartName[part]].targetNode)
                    -- setRotation(seat.passengerCharacter.ikChainTargets[part].targetNode, crx, cry, crz)
                    -- pushChanges = true
                -- end

                local rx, ry, rz = getRotation(seat.passengerCharacter.ikChainTargets[part].targetNode)
                if UP_Creator.inputHasEvent("NUM+") then
                    rz = UP_Creator.getCorrectedRotation(rz, factor, true)
                    setRotation(seat.passengerCharacter.ikChainTargets[part].targetNode, rx, ry, rz)
                    pushChanges = true
                end

                if UP_Creator.inputHasEvent("NUM-") then
                    rz = UP_Creator.getCorrectedRotation(rz, factor, false)
                    setRotation(seat.passengerCharacter.ikChainTargets[part].targetNode, rx, ry, rz)
                    pushChanges = true
                end

                if UP_Creator.inputHasEvent("NUM_UP") then
                    rx = UP_Creator.getCorrectedRotation(rx, factor, true)
                    setRotation(seat.passengerCharacter.ikChainTargets[part].targetNode, rx, ry, rz)
                    pushChanges = true
                end

                if UP_Creator.inputHasEvent("NUM_DOWN") then
                    rx = UP_Creator.getCorrectedRotation(rx, factor, false)
                    setRotation(seat.passengerCharacter.ikChainTargets[part].targetNode, rx, ry, rz)
                    pushChanges = true
                end

                if UP_Creator.inputHasEvent("NUM_LEFT") then
                    ry = UP_Creator.getCorrectedRotation(ry, factor, true)
                    setRotation(seat.passengerCharacter.ikChainTargets[part].targetNode, rx, ry, rz)
                    pushChanges = true
                end

                if UP_Creator.inputHasEvent("NUM_RIGHT") then
                    ry = UP_Creator.getCorrectedRotation(ry, factor, false)
                    setRotation(seat.passengerCharacter.ikChainTargets[part].targetNode, rx, ry, rz)
                    pushChanges = true
                end

                rx, ry, rz = UP_Creator.getRoundedTable({rx, ry, rz}, 3, true)
                g_currentMission:addExtraPrintText("RX RY RZ = " .. tostring(rx) .. " | " .. tostring(ry) .. " | " .. tostring(rz))

                local spineZ = UP_Creator.getTrueZero(MathUtil.round(math.deg(seat.passengerCharacter.characterSpineRotation[3], 0)))
                g_currentMission:addExtraPrintText("Spine - RX RY RZ = -90" .. " | 0" .. " | " .. tostring(spineZ))
            end

            if (part == "rightArm") or (part == "leftArm") then
                local poseId = seat.passengerCharacter.poseIds[part]
                if poseId == "" then
                    poseId = "narrowFingers"
                end
                g_currentMission:addExtraPrintText("NumPad 0: Finger position = " .. tostring(poseId))

                if UP_Creator.inputHasEvent("NUMPAD_0", false) then
                    local currentIndex = UP_Creator.poseIdToIndex[poseId] or 1

                    currentIndex = currentIndex + 1
                    if currentIndex > 3 then
                        currentIndex = 1
                    end

                    local newPoseId = UP_Creator.poseIndexToId[currentIndex]
                    local chain = IKUtil.getIKChainByTarget(seat.passengerCharacter.ikChains, seat.passengerCharacter.ikChainTargets[part].targetNode)
                    if chain ~= nil then
                        IKUtil.setIKChainPose(seat.passengerCharacter.ikChains, chain.id, newPoseId)
                    end

                    seat.passengerCharacter.poseIds[part] = newPoseId
                    seat.passengerCharacter.ikChainTargets[part].poseId = newPoseId -- Change so setting is kept if 'pushChanges' is true.
                end
            end

            if pushChanges then
                local playerStyle = g_currentMission.player.visualInformation
                local playerModel = g_playerModelManager:getPlayerModelByIndex(playerStyle.selectedModelIndex)
                seat.passengerCharacter:delete()
                seat.passengerCharacter:loadCharacter(playerModel.xmlFilename, playerStyle)
                seat.passengerCharacter:updateIKChains()
            end

            g_inputBinding:setActionEventText(self.adjustPassengerPart, "Selected Body Part ( " .. self.bodyPartName[self.bodyPart] .. " )")
        elseif self.updateMode == 3 then -- Indoor Camera Adjustment
            g_inputBinding:setActionEventText(self.setUpdateMode, "Activate Passenger Adjustment")

            if seat.cameraIndex ~= 2 then
                self.currentVehicle:setPassengerCameraIndex(seat, 2)
            end
            spec.normalCamMode = false

            if self.transCameraMode then
                g_inputBinding:setActionEventText(self.adjustPassenger, "Activate Camera Rotation")
                g_currentMission:addExtraPrintText("Use NumPad Arrows and + - to move.")
                g_currentMission:addExtraPrintText("Use NumPad * to reset camera translation.")

                if UP_Creator.inputHasEvent("NUMPAD_MULTIPLY", false) then
                    local x, y, z = getTranslation(seat.i3dCharacterNode)
                    setTranslation(seat.cameras[2].rotateNode, x, y + 0.7, z)
                    seat.cameras[2]:onActivate()
                end

                local x, y, z = getTranslation(seat.cameras[2].rotateNode)
                if UP_Creator.inputHasEvent("NUM+") then
                    setTranslation(seat.cameras[2].rotateNode, x, y + factor, z)
                    seat.cameras[2]:onActivate()
                end

                if UP_Creator.inputHasEvent("NUM-") then
                    setTranslation(seat.cameras[2].rotateNode, x, y - factor, z)
                    seat.cameras[2]:onActivate()
                end

                if UP_Creator.inputHasEvent("NUM_UP") then
                    setTranslation(seat.cameras[2].rotateNode, x, y, z + factor)
                    seat.cameras[2]:onActivate()
                end

                if UP_Creator.inputHasEvent("NUM_DOWN") then
                    setTranslation(seat.cameras[2].rotateNode, x, y, z - factor)
                    seat.cameras[2]:onActivate()
                end

                if UP_Creator.inputHasEvent("NUM_LEFT") then
                    setTranslation(seat.cameras[2].rotateNode, x + factor, y, z)
                    seat.cameras[2]:onActivate()
                end

                if UP_Creator.inputHasEvent("NUM_RIGHT") then
                    setTranslation(seat.cameras[2].rotateNode, x - factor, y, z)
                    seat.cameras[2]:onActivate()
                end

                x, y, z = UP_Creator.getRoundedTable({x, y, z}, 3, false)
                g_currentMission:addExtraPrintText("X Y Z = " .. tostring(x) .. " | " .. tostring(y) .. " | " .. tostring(z))
            else
                g_inputBinding:setActionEventText(self.adjustPassenger, "Activate Camera Translation")
                g_currentMission:addExtraPrintText("Use NumPad Arrows to rotate.")
                g_currentMission:addExtraPrintText("Use NumPad * to reset inside camera rotation.")

                if UP_Creator.inputHasEvent("NUMPAD_MULTIPLY", false) then
                    local _, y, _ = getRotation(seat.i3dCharacterNode)
                    local degY = MathUtil.round(math.deg(y), 0)
                    if degY > 0 then
                        degY = UP_Creator.getTrueZero(MathUtil.round(degY - 180, 0))
                    elseif degY < 0 then
                        degY = UP_Creator.getTrueZero(MathUtil.round(degY + 180, 0))
                    else
                        degY = 180
                    end

                    setRotation(seat.cameras[2].rotateNode, math.rad(-14), math.rad(degY), math.rad(0))
                    seat.cameras[2]:onActivate()
                end

                local rx, ry, rz = getRotation(seat.cameras[2].rotateNode)
                if UP_Creator.inputHasEvent("NUM_UP") then
                    rx = UP_Creator.getCorrectedRotation(rx, factor, true)
                    setRotation(seat.cameras[2].rotateNode, rx, ry, rz)
                    seat.cameras[2]:onActivate()
                end

                if UP_Creator.inputHasEvent("NUM_DOWN") then
                    rx = UP_Creator.getCorrectedRotation(rx, factor, false)
                    setRotation(seat.cameras[2].rotateNode, rx, ry, rz)
                    seat.cameras[2]:onActivate()
                end

                if UP_Creator.inputHasEvent("NUM_LEFT") then
                    ry = UP_Creator.getCorrectedRotation(ry, factor, true)
                    setRotation(seat.cameras[2].rotateNode, rx, ry, rz)
                    seat.cameras[2]:onActivate()
                end

                if UP_Creator.inputHasEvent("NUM_RIGHT") then
                    ry = UP_Creator.getCorrectedRotation(ry, factor, false)
                    setRotation(seat.cameras[2].rotateNode, rx, ry, rz)
                    seat.cameras[2]:onActivate()
                end

                rx, ry, rz = UP_Creator.getRoundedTable({rx, ry, rz}, 3, true)
                g_currentMission:addExtraPrintText("RX RY RZ = " .. tostring(rx) .. " | " .. tostring(ry) .. " | " .. tostring(rz))
            end
        end

        g_currentMission:addExtraPrintText("Use NumPad 1 & 3 - Movement Speed = " .. tostring(self.movmentFactor))

        if seat.passengerCharacter ~= nil and seat.passengerCharacter.ikChainTargets ~= nil then
            UP_Creator.debugRenderTargetNodes(seat.passengerCharacter.ikChainTargets, dt)
        end

        g_inputBinding:setActionEventTextVisibility(self.setUpdateMode, true)
        g_inputBinding:setActionEventTextVisibility(self.doPrintSeatData, true)
        g_inputBinding:setActionEventTextVisibility(self.adjustPassenger, true)
        g_inputBinding:setActionEventTextVisibility(self.adjustPassengerPart, self.updateMode == 2)
    else
        if self.actionEventsRegistered then
            g_inputBinding:setActionEventTextVisibility(self.setUpdateMode, false)
            g_inputBinding:setActionEventTextVisibility(self.doPrintSeatData, false)
            g_inputBinding:setActionEventTextVisibility(self.adjustPassenger, false)
            g_inputBinding:setActionEventTextVisibility(self.adjustPassengerPart, false)

            g_inputBinding:removeActionEventsByTarget(self)
            self.actionEventsRegistered = false
        end
    end
end

function UP_Creator.debugRenderTargetNodes(ikChainTargets, dt)
    DebugUtil.drawDebugNode(ikChainTargets["rightFoot"].targetNode, nil, false)
    DebugUtil.drawDebugNode(ikChainTargets["leftFoot"].targetNode, nil, false)
    DebugUtil.drawDebugNode(ikChainTargets["rightArm"].targetNode, nil, false)
    DebugUtil.drawDebugNode(ikChainTargets["leftArm"].targetNode, nil, false)
end

function UP_Creator:removeConsoleCommands(isDelete)
    if isDelete then
        removeConsoleCommand("upEnablePassengerCommands")
    end

    if self.active then
        removeConsoleCommand("upReloadVehicleFiles")
        removeConsoleCommand("upClearAllStoredSeats")
        removeConsoleCommand("upStorePassengerSeats")
        removeConsoleCommand("upActivateSetupMovement")
        removeConsoleCommand("upCreateXmlFromStoredPassengerSeats")

        -- removeConsoleCommand("upClearVehicleInfoTable")
        -- removeConsoleCommand("upVerifyAddonXMLFilesLoaded")

        if self.isDev then
            removeConsoleCommand("upReloadVehicleList")
            removeConsoleCommand("upCreateXmlFromList")
            removeConsoleCommand("upCreateListFromSpawnedVehicles")
            removeConsoleCommand("upStoreAllSpawnedVehiclesPassengerSeats")
        end
    end

    if self.charMovementActive and self.actionEventsRegistered then
        g_inputBinding:removeActionEventsByTarget(self)
        self.actionEventsRegistered = false
    end
end

function UP_Creator:consoleCommandActivateSetupMovement()
    self.charMovementActive = not self.charMovementActive

    if self.charMovementActive then
        self.updateMode = 1
        self:registerActionEvents()

        self.currentVehicle = nil
        self.currentSeatId = nil

        return "INFO: Setup movement is enabled."
    else
        self.updateMode = 1
        self.actionEventsRegistered = false
        g_inputBinding:removeActionEventsByTarget(self)

        self.currentVehicle = nil
        self.currentSeatId = nil

        for _, veh in pairs (g_universalPassenger.passengerVehicles) do
            if not veh.spec_universalPassenger.normalCamMode then
                veh.spec_universalPassenger.normalCamMode = true
            end

            for _, seat in pairs (veh.spec_universalPassenger.passengerSeats) do
                if seat.passengerCharacter.oldCharacterCameraMinDistance ~= nil then
                    seat.passengerCharacter.characterCameraMinDistance = seat.passengerCharacter.oldCharacterCameraMinDistance
                    seat.passengerCharacter.oldCharacterCameraMinDistance = nil
                end

                if seat.cameras[1].oldTransMin ~= nil then
                    seat.cameras[1].transMin = seat.cameras[1].oldTransMin
                    seat.cameras[1].oldTransMin = nil
                end

                if seat.oldCameraData ~= nil then
                    if seat.oldCameraData.trans ~= nil then
                        local x, y, z = unpack(seat.oldCameraData.trans)
                        setTranslation(seat.cameras[1].rotateNode, x, y, z)
                    end

                    if seat.oldCameraData.rot ~= nil then
                        local rx, ry, rz = unpack(seat.oldCameraData.rot)
                        setRotation(seat.cameras[1].rotateNode, rx, ry, rz)
                    end
                end
            end
        end

        return "CAUTION: (Global XML Only) Any movement to your passenger vehicle indoor camera will affect your XML save data if XML is not already saved.\n Setup movement is disabled."
    end
end

function UP_Creator:consoleCommandStorePassengerSeats(forceCreateXML, cameraFromSeatPosition, useSeatZ)
    if g_currentMission:getIsServer() and not g_currentMission.missionDynamicInfo.isMultiplayer then
        if self.vehicleInfo == nil then
            self.vehicleInfo = {}
        end

        cameraFromSeatPosition = Utils.stringToBoolean(cameraFromSeatPosition)

        local vehicle = g_universalPassenger.currentPassengerVehicle
        if vehicle ~= nil and vehicle.spec_universalPassenger.passengerSeats ~= nil then

            -- Create No duplicates. Clear old entries first if they exist.
            local oldId = nil
            for v = 1, #self.vehicleInfo do
                if self.vehicleInfo[v].xmlFilename == vehicle.configFileName then
                    oldId = v
                    table.remove(self.vehicleInfo, v)
                    break
                end
            end

            local vehicleInfo = {}
            vehicleInfo.seats = {}
            vehicleInfo.xmlFilename = vehicle.configFileName
            vehicleInfo.useSeatZ = Utils.stringToBoolean(useSeatZ)

            for s = 1, #vehicle.spec_universalPassenger.passengerSeats do
                vehicleInfo.seats[s] = {}

                if vehicle.spec_universalPassenger.passengerSeats[s].i3dCharacterNode ~= nil then
                    if vehicle.spec_universalPassenger.passengerSeats[s].i3dCharacterNode ~= nil then
                        vehicleInfo.seats[s].position = UP_Creator.getRoundedTrans(vehicle.spec_universalPassenger.passengerSeats[s].i3dCharacterNode, 3, true)

                        local rx, ry, rz = UP_Creator.getRoundedRot(vehicle.spec_universalPassenger.passengerSeats[s].i3dCharacterNode, 3)
                        if rx ~= 0 or ry ~= 0 or rz ~= 0 then
                            vehicleInfo.seats[s].rotation = string.format("%s %s %s", rx, ry, rz)
                        end
                    end
                end

                vehicleInfo.seats[s].isInside = Utils.getNoNil(vehicle.spec_universalPassenger.passengerSeats[s].cameras[2].isInside, true)

                if not cameraFromSeatPosition and not vehicle.spec_universalPassenger.passengerSeats[s].cameras[2].hasExtraRotationNode then
                    vehicleInfo.seats[s].insideCamera = {}
                    vehicleInfo.seats[s].insideCamera.position = UP_Creator.getRoundedTrans(vehicle.spec_universalPassenger.passengerSeats[s].cameras[2].rotateNode, 3, true)
                    vehicleInfo.seats[s].insideCamera.rotation = UP_Creator.getRoundedRot(vehicle.spec_universalPassenger.passengerSeats[s].cameras[2].rotateNode, nil, true)
                end

                local characterChanges = self:getCharacterChanges(vehicle.configFileName, vehicle.spec_universalPassenger.passengerSeats[s], s, false)
                if characterChanges ~= nil then
                    vehicleInfo.seats[s].passengerCharacter = characterChanges
                end

                vehicleInfo.seats[s].zSpineRotation = MathUtil.round(math.deg(vehicle.spec_universalPassenger.passengerSeats[s].passengerCharacter.characterSpineRotation[3]))

                if vehicle.spec_universalPassenger.passengerSeats[s].partChange ~= nil then
                    local partChange = vehicle.spec_universalPassenger.passengerSeats[s].partChange
                    vehicleInfo.seats[s].partChange = self:collectPartsInfo(partChange)
                end

                if vehicle.spec_universalPassenger.passengerSeats[s].passengerEnterAnimation ~= nil then
                    vehicleInfo.seats[s].enterAnimation = vehicle.spec_universalPassenger.passengerSeats[s].passengerEnterAnimation
                end
            end

            if oldId ~= nil then
                table.insert(self.vehicleInfo, oldId, vehicleInfo)
            else
                table.insert(self.vehicleInfo, vehicleInfo)
            end

            forceCreateXML = Utils.stringToBoolean(forceCreateXML)
            if forceCreateXML then
                local returnText = "INFO: Force creating XML now. Please wait."
                return self:consoleCommandCreatePassengerSeatsXML(returnText)
            else
                return "INFO: This vehicles passenger seat(s) data have been saved."
            end
        else
            return "INFO: You must first enter a vehicle as a passenger."
        end
    end
end

function UP_Creator:consoleCommandStoreAllVehiclesPassengerSeats(forceCreateXML, cameraFromSeatPosition, useSeatZ)
    if g_currentMission:getIsServer() and not g_currentMission.missionDynamicInfo.isMultiplayer then

        self.vehicleInfo = {}
        cameraFromSeatPosition = Utils.stringToBoolean(cameraFromSeatPosition)

        for _, vehicle in pairs (g_universalPassenger.passengerVehicles) do
            local vehicleInfo = {}
            vehicleInfo.seats = {}
            vehicleInfo.xmlFilename = vehicle.configFileName
            vehicleInfo.useSeatZ = Utils.stringToBoolean(useSeatZ)

            for s = 1, #vehicle.spec_universalPassenger.passengerSeats do
                vehicleInfo.seats[s] = {}

                if vehicle.spec_universalPassenger.passengerSeats[s].i3dCharacterNode ~= nil then
                    vehicleInfo.seats[s].position = UP_Creator.getRoundedTrans(vehicle.spec_universalPassenger.passengerSeats[s].i3dCharacterNode, 3, true)

                    local rx, ry, rz = UP_Creator.getRoundedRot(vehicle.spec_universalPassenger.passengerSeats[s].i3dCharacterNode, 3)
                    if rx ~= 0 or ry ~= 0 or rz ~= 0 then
                        vehicleInfo.seats[s].rotation = string.format("%s %s %s", rx, ry, rz)
                    end
                end

                if not cameraFromSeatPosition and vehicle.spec_universalPassenger.passengerSeats[s].cameras[2].isInside then
                    vehicleInfo.seats[s].insideCamera = {}
                    vehicleInfo.seats[s].insideCamera.position = UP_Creator.getRoundedTrans(vehicle.spec_universalPassenger.passengerSeats[s].cameras[2].rotateNode, 3, true)
                    vehicleInfo.seats[s].insideCamera.rotation = UP_Creator.getRoundedRot(vehicle.spec_universalPassenger.passengerSeats[s].cameras[2].rotateNode, nil, true)
                end

                local characterChanges = self:getCharacterChanges(vehicle.configFileName, vehicle.spec_universalPassenger.passengerSeats[s], s, false)
                if characterChanges ~= nil then
                    vehicleInfo.seats[s].passengerCharacter = characterChanges
                end

                vehicleInfo.seats[s].zSpineRotation = MathUtil.round(math.deg(vehicle.spec_universalPassenger.passengerSeats[s].passengerCharacter.characterSpineRotation[3]))

                if vehicle.spec_universalPassenger.passengerSeats[s].partChange ~= nil then
                    local partChange = vehicle.spec_universalPassenger.passengerSeats[s].partChange
                    vehicleInfo.seats[s].partChange = self:collectPartsInfo(partChange)
                end

                if vehicle.spec_universalPassenger.passengerSeats[s].passengerEnterAnimation ~= nil then
                    vehicleInfo.seats[s].enterAnimation = vehicle.spec_universalPassenger.passengerSeats[s].passengerEnterAnimation
                end
            end

            table.insert(self.vehicleInfo, vehicleInfo)
        end

        forceCreateXML = Utils.stringToBoolean(forceCreateXML)
        if forceCreateXML then
            local returnText = "INFO: Force creating XML now. Please wait."
            return self:consoleCommandCreatePassengerSeatsXML(returnText)
        else
            return "INFO: Vehicle passenger seat(s) have been saved for (" .. tostring(#self.vehicleInfo) .. ") vehicles."
        end
    end
end

function UP_Creator:consoleCommandClearVehicleInfoTable()
    self.vehicleInfo = nil
    return "INFO: Vehicle Info Table has been cleared."
end

function UP_Creator:consoleCommandReloadStandardVehicleList()
    self:loadVehicleList()
    return "INFO: List reloaded successfully."
end

function UP_Creator:consoleCommandReloadGlobalVehicleFiles(loadAddons)
    local doAddonReload = Utils.stringToBoolean(loadAddons)
    g_universalPassenger:loadGlobalXMLFiles(doAddonReload, true)

    return
end

function UP_Creator:consoleCommandCreateListFromSpawnedVehicles(forceCreateXML, useSeatZ)
    self.vehicleList = {}

    local dupCount = 0
    for _, enterable in pairs(g_currentMission.enterables) do
        local vehicle = {}

        local canAdd = true
        for _, addedVehicle in pairs (self.vehicleList) do
            if addedVehicle.xmlFilename == enterable.configFileName then
                canAdd = false
                dupCount = dupCount + 1
                break
            end
        end

        if canAdd then
            vehicle.xmlFilename = enterable.configFileName

            -- Move the camera `z` position in line with the player TG if true.
            vehicle.useSeatZ = Utils.stringToBoolean(useSeatZ)

            table.insert(self.vehicleList, vehicle)
        end
    end

    local returnText = ""
    if dupCount > 0 then
        returnText = returnText .. "\nWARNING: " .. tostring(dupCount) .. " duplicate spawned steerable vehicle(s) skipped."
    end

    forceCreateXML = Utils.stringToBoolean(forceCreateXML)
    if forceCreateXML then
        returnText = returnText .. "\nINFO: Force creating XML now. Please wait."
        return self:consoleCommandCreatePassengerSeatsFromList(nil, returnText)
    else
        returnText = returnText .. "\n" .. tostring(#self.vehicleList) .. " steerable vehicles added to the list."
        return returnText
    end
end

function UP_Creator:consoleCommandCreatePassengerSeatsFromList(useSeatZ, returnText)
    if g_currentMission:getIsServer() and not g_currentMission.missionDynamicInfo.isMultiplayer then
        if returnText == nil then
            returnText = ""
        end

        if self.vehicleList == nil or #self.vehicleList <= 0 then
            returnText = returnText .. "\nINFO: Vehicle List table is nil or empty!"
            return returnText
        end

        self.content = ''
        self.raycastNodeErrors = 0
        self.listActive = true

        local rot = MathUtil.degToRad(180)
        local field = g_fieldManager:getFieldByIndex(1)
        for i = 1, #self.vehicleList do
            if self.vehicleList[i].useSeatZ == nil then
                self.vehicleList[i].useSeatZ = Utils.stringToBoolean(useSeatZ)
            end

            local storeItem = self.vehicleList[i].xmlFilename
            -- filename, x, y, z, yOffset, yRot, save, price, propertyState, ownerFarmId, configurations, savegameData, asyncCallbackFunction, asyncCallbackObject, asyncCallbackArguments
            self.currentVehicle = g_currentMission:loadVehicle(storeItem, field.posX, 0.5, field.posZ, 0, rot, true, 0, Vehicle.PROPERTY_STATE_NONE, nil, nil, nil)
            if self.currentVehicle ~= nil then
                g_currentMission:removeVehicle(self.currentVehicle)
                self.currentVehicle = nil
            end
        end

        self:writeXML(g_modsDirectory .. "universalPassengerCreator.xml")

        returnText = returnText .. "\nINFO: Success! XML has been saved at " .. g_modsDirectory
        return returnText
    end
end

function UP_Creator:consoleCommandCreatePassengerSeatsXML(returnText)
    if g_currentMission:getIsServer() and not g_currentMission.missionDynamicInfo.isMultiplayer then
        if returnText == nil then
            returnText = ""
        end

        if self.vehicleInfo == nil then
            return returnText .. "\nINFO: No vehicle info has been saved. This can be done using 'upStorePassengerSeat' or 'upStoreAllPassengerSeats' \nSupport: https://forum.giants-software.com  or  https://github.com/GtX-Andy"
        end

        self.content = ''
        self.raycastNodeErrors = 0
        self.infoActive = true

        local rot = MathUtil.degToRad(180)
        local field = g_fieldManager:getFieldByIndex(1)
        for i = 1, #self.vehicleInfo do
            local storeItem = self.vehicleInfo[i].xmlFilename
            self.currentVehicle = g_currentMission:loadVehicle(storeItem, field.posX, 0.5, field.posZ, 0, rot, true, 0, Vehicle.PROPERTY_STATE_NONE, nil, nil, nil)
            if self.currentVehicle ~= nil then
                g_currentMission:removeVehicle(self.currentVehicle)
                self.currentVehicle = nil
            end
        end

        self:writeXML(g_modsDirectory .. "universalPassengerCreator.xml")

        return returnText .. "\nINFO: Success! XML has been saved at " .. g_modsDirectory
    end
end

function UP_Creator:collectXmlData()
    if g_universalPassenger == nil or g_universalPassenger.creator == nil or
        not g_universalPassenger.creator.active then
        return
    end

    local upc = g_universalPassenger.creator
    if upc.listActive or upc.infoActive then
        local gp, canCollect = nil, false

        if upc.listActive then
            for v = 1, #upc.vehicleList do
                if self.configFileName == upc.vehicleList[v].xmlFilename then
                    if upc.vehicleList[v].seats == nil then
                        upc.vehicleList[v].seats = {}

                        local seat = {}
                        if upc.vehicleList[v].position == nil then
                            seat = upc:getDriverPosition(self, self.xmlFile)
                        else
                            seat.position = upc.vehicleList[v].position
                            if upc.vehicleList[v].rotation ~= nil then
                                seat.rotation = upc.vehicleList[v].rotation
                            end
                        end
                        table.insert(upc.vehicleList[v].seats, seat)
                    end

                    gp = upc.vehicleList[v]

                    canCollect = true
                    break
                end
            end
        elseif upc.infoActive then
            for v = 1, #upc.vehicleInfo do
                if self.configFileName == upc.vehicleInfo[v].xmlFilename then
                    if upc.vehicleInfo[v].seats == nil then
                        if upc.vehicleInfo[v].position ~= nil then
                            local seat = {}
                            seat.position = upc.vehicleInfo[v].position
                            if upc.vehicleInfo[v].rotation ~= nil then
                                seat.rotation = upc.vehicleInfo[v].rotation
                            end

                            table.insert(upc.vehicleInfo[v], seat)
                        else
                            canCollect = false
                        end
                    end

                    gp = upc.vehicleInfo[v]
                    canCollect = true
                    break
                end
            end
        end

        if canCollect then
            local content = '    <vehicle xmlFilename="' .. gp.xmlFilename .. '">\n'

            if self.customEnvironment ~= nil then
                local xmlFilename = gp.xmlFilename
                local s, e = xmlFilename:find("/[^/]*$")
                xmlFilename = xmlFilename:sub(s + 1)

                content = '    <vehicle xmlFilename="' .. xmlFilename .. '" modName="' .. self.customEnvironment .. '">\n'
            end

            for index, seat in pairs (gp.seats) do
                local positionToTable = StringUtil.splitString(" ", seat.position)
                local gpx, gpy, gpz = positionToTable[1], positionToTable[2], positionToTable[3]

                local xmlFile = self.xmlFile
                content = content .. '        <passenger>\n'

                local rotationContent = ''
                if seat.rotation ~= nil then
                    rotationContent = ' rotation="' .. seat.rotation .. '"'
                end

                local spineRotation = ' spineRotation="-90 0 90"'
                if seat.zSpineRotation ~= nil then
                    spineRotation = ' spineRotation="-90 0 ' .. seat.zSpineRotation ..'"'
                end

                local passengerCharacter = ''
                if seat.passengerCharacter ~= nil then
                    content = content .. '            <passengerNode position="' .. seat.position .. '"' .. rotationContent .. spineRotation ..' customTargets="true">\n'
                    for _, xmlProp in pairs (seat.passengerCharacter) do
                        content = content .. xmlProp
                    end
                    content = content .. '            </passengerNode>\n\n'
                else
                    content = content .. '            <passengerNode position="' .. seat.position .. '"' .. rotationContent .. spineRotation ..' customTargets="false"/>\n\n'
                end

                content = content .. '            <cameras>\n'

                local cam = 0
                while true do
                    local key = string.format("vehicle.enterable.cameras.camera(%d)", cam)
                    if not hasXMLProperty(xmlFile, key) then
                        break
                    end

                    local node = I3DUtil.indexToObject(self.components, getXMLString(xmlFile, key .. "#node"), self.i3dMappings)

                    if cam == 0 then
                        local cameraRotation = ''
                        local rx, ry, rz = UP_Creator.getRoundedRot(node, 0)
                        if rx ~= 0 or ry ~= 0 or rz ~= 0 then
                            cameraRotation = ' cameraRotation="' .. rx .. ' ' .. ry .. ' ' .. rz .. '"'
                        end

                        content = content .. '                <camera cameraPosition="' .. UP_Creator.getRoundedTrans(node, 3, true) .. '"' .. cameraRotation

                        local rotateNode = I3DUtil.indexToObject(self.components, getXMLString(xmlFile, key .. "#rotateNode"), self.i3dMappings)
                        local rotateNodeRotation = ' rotateNodeRotation="' .. UP_Creator.getRoundedRot(rotateNode, 0, true) .. '"'

                        local isRotatable = tostring(Utils.getNoNil(getXMLBool(xmlFile, key .. "#rotatable"), true))
                        local limit = tostring(Utils.getNoNil(getXMLBool(xmlFile, key .. "#limit"), true))

                        local useWorldXZRotation = getXMLBool(xmlFile, key .. "#useWorldXZRotation")
                        local worldXZRotation = ""
                        if useWorldXZRotation ~= nil then
                            worldXZRotation = ' useWorldXZRotation="' .. tostring(useWorldXZRotation) .. '"'
                        end

                        local rotMinX = UP_Creator.noNilRound(getXMLFloat(xmlFile, key .. "#rotMinX"), 3, -1.4)
                        local rotMaxX = UP_Creator.noNilRound(getXMLFloat(xmlFile, key .. "#rotMaxX"), 3, 1)
                        local transMin = UP_Creator.noNilRound(getXMLFloat(xmlFile, key .. "#transMin"), 3, 4)
                        local transMax = UP_Creator.noNilRound(getXMLFloat(xmlFile, key .. "#transMax"), 3, 35)

                        content = content .. ' rotateNodePosition="' .. UP_Creator.getRoundedTrans(rotateNode, 3, true) .. '"' .. rotateNodeRotation .. ' rotatable="' .. isRotatable .. '" limit="' .. limit .. '"'
                        content = content .. worldXZRotation .. ' rotMinX="' .. rotMinX .. '" rotMaxX="' .. rotMaxX .. '" transMin="' .. transMin .. '" transMax="' .. transMax .. '">\n'

                        local hasNodes = false
                        local c = 0
                        while true do
                            local raycastKey = string.format("%s.raycastNode(%d)", key, c)
                            if not hasXMLProperty(xmlFile, raycastKey) then
                                break
                            end

                            local raycastNode = I3DUtil.indexToObject(self.components, getXMLString(xmlFile, raycastKey .. "#node"), self.i3dMappings)
                            if raycastNode ~= nil then
                                if not hasNodes then
                                    hasNodes = true
                                end

                                local Nx, Ny, Nz = UP_Creator.getRoundedTrans(raycastNode, 3)
                                local NxR, NyR, NzR = UP_Creator.getRoundedRot(raycastNode, 3)

                                if Nx == 0 and Ny == 0 and Nz == 0 then
                                    content = '\n' .. content .. '                    <!-- IMPORTANT: Check positions, 0 0 0 is not a suitable entry for a raycastNode. -->\n'
                                    upc.raycastNodeErrors = upc.raycastNodeErrors + 1
                                end

                                if NxR == 0 and NyR == 0 and NzR == 0 then
                                    content = content .. '                    <raycastNode position="' .. Nx .. ' ' .. Ny .. ' ' .. Nz .. '"/>\n'
                                else
                                    content = content .. '                    <raycastNode position="' .. Nx .. ' ' .. Ny .. ' ' .. Nz .. '" rotation="' .. NxR .. ' ' .. NyR .. ' ' .. NzR .. '"/>\n'
                                end
                            end

                            c = c + 1
                        end

                        if hasNodes then
                            content = '\n' .. content .. '                </camera>\n'
                        else
                            content = content .. '/>\n'
                        end
                    else
                        local x, y, z = UP_Creator.getRoundedTrans(node, 3)
                        if gp.useSeatZ then
                            z = gpz
                        end

                        local position = 'cameraPosition="' .. gpx .. ' ' .. y .. ' ' .. z .. '"'

                        local rx, ry, rz = UP_Creator.getRoundedRot(node, 0)
                        if rz ~= 0 then
                            local insideCamRotation = getXMLString(xmlFile, key .. "#rotation")
                            if insideCamRotation ~= nil then
                                rotation = ' cameraRotation="' .. insideCamRotation .. '"'
                            else
                                rotation = ' cameraRotation="-15 180 0"'
                            end
                        else
                            rotation = ' cameraRotation="' .. rx .. ' ' .. ry .. ' ' .. rz .. '"'
                        end

                        if seat.insideCamera ~= nil then
                            if seat.insideCamera.position ~= nil then
                                position = 'cameraPosition="' .. seat.insideCamera.position .. '"'
                                if seat.insideCamera.rotation ~= nil then
                                    rotation = ' cameraRotation="' .. seat.insideCamera.rotation .. '"'
                                end
                            end
                        end

                        local isRotatable = tostring(Utils.getNoNil(getXMLBool(xmlFile, key .. "#rotatable"), true))
                        local limit = tostring(Utils.getNoNil(getXMLBool(xmlFile, key .. "#limit"), true))

                        local useWorldXZRotation = getXMLBool(xmlFile, key .. "#useWorldXZRotation")
                        local worldXZRotation = ""
                        if useWorldXZRotation ~= nil then
                            worldXZRotation = ' useWorldXZRotation="' .. tostring(useWorldXZRotation) .. '"'
                        end

                        local rotMinX = UP_Creator.noNilRound(getXMLFloat(xmlFile, key .. "#rotMinX"), 3, -1.4)
                        local rotMaxX = UP_Creator.noNilRound(getXMLFloat(xmlFile, key .. "#rotMaxX"), 3, 0.4)
                        local transMin = UP_Creator.noNilRound(getXMLFloat(xmlFile, key .. "#transMin"), 3, 0)
                        local transMax = UP_Creator.noNilRound(getXMLFloat(xmlFile, key .. "#transMax"), 3, 0)

                        local isInside = ' useMirror="true" isInside="true"'
                        if not seat.isInside then
                            isInside = ' useMirror="false" allowHeadTracking="true"'
                        end

                        content = content .. '                <camera ' .. position .. rotation .. ' rotatable="' .. isRotatable .. '" limit="' .. limit .. '"'
                        content = content .. worldXZRotation .. ' rotMinX="' .. rotMinX .. '" rotMaxX="' .. rotMaxX .. '" transMin="' .. transMin .. '" transMax="' .. transMax .. '"' .. isInside .. '/>\n'


                        break
                    end

                    cam = cam + 1
                end

                content = content .. '            </cameras>\n'

                if seat.partChange ~= nil then
                    content = content .. seat.partChange
                end

                if seat.enterAnimation ~= nil then
                    content = content .. '\n            <enterAnimation name="' ..seat.enterAnimation.. '"/>\n'
                end

                content = content .. '        </passenger>\n'
            end
            content = content .. '    </vehicle>\n'

            upc.content = upc.content .. content
        end
    end
end

function UP_Creator:getTransRotXYZPrint(seat)
    local spineRotZ = MathUtil.round(math.deg(seat.passengerCharacter.characterSpineRotation[3]), 3)
    local passengerTrans = string.format("Passenger %s NodePosition = %s", seat.id, UP_Creator.getRoundedTrans(seat.i3dCharacterNode, 3, true))
    local passengerRot = string.format("Passenger %s NodeRotation = %s", seat.id, UP_Creator.getRoundedRot(seat.i3dCharacterNode, 3, true))
    local passengerSpineRot = string.format("Passenger %s XML SpineRotation = -90 0 %s", seat.id, spineRotZ)
    local cameraTrans = string.format("Passenger %s Camera(2) Position = %s", seat.id, UP_Creator.getRoundedTrans(seat.cameras[2].rotateNode, 3, true))
    local cameraRot = string.format("Passenger %s Camera(2) Rotation = %s", seat.id, UP_Creator.getRoundedRot(seat.cameras[2].rotateNode, 0, true))

    return string.format("\n%s\n%s\n%s\n\n%s\n%s\n", passengerTrans, passengerRot, passengerSpineRot, cameraTrans, cameraRot)
end

function UP_Creator:getCharacterChanges(filename, seat, seatId, printReturn)
    local changed = false
    local changesTable = nil

    if filename ~= nil and seat ~= nil then
        filename = filename:lower()
        if self.vehicles[filename] ~= nil then
            for targetId, target in pairs (seat.passengerCharacter.ikChainTargets) do
                if self.vehicles[filename][seatId] ~= nil and self.vehicles[filename][seatId].targetNodes[targetId] ~= nil then
                    local x, y, z = getTranslation(target.targetNode)
                    local position = string.format("%s %s %s", x, y, z)
                    local rx, ry, rz = getRotation(target.targetNode)
                    local rotation = string.format("%s %s %s", rx, ry, rz)

                    if position ~= self.vehicles[filename][seatId].targetNodes[targetId].trans or
                        rotation ~= self.vehicles[filename][seatId].targetNodes[targetId].rot then
                        changed = true
                        break
                    end
                end
            end
        end
    end

    if changed or seat.passengerCharacter.hasCustomTargets then
        changesTable = {}
        for targetId, target in pairs (seat.passengerCharacter.ikChainTargets) do
            local position = UP_Creator.getRoundedTrans(target.targetNode, 3, true)
            local rotation = UP_Creator.getRoundedRot(target.targetNode, 3, true)

            local poseId = ""
            if seat.passengerCharacter.poseIds ~= nil then
                poseId = seat.passengerCharacter.poseIds[targetId] or ""
                if poseId == "narrowFingers" then
                    poseId = ""
                end
            end

            if printReturn then
                changesTable[targetId] = {position = position, rotation = rotation, poseId = poseId}
            else
                if poseId ~= "" then
                    poseId = ' poseId="' .. poseId .. '"'
                end

                changesTable[targetId] = '                <' .. targetId .. ' position="' .. position .. '" rotation="' .. rotation .. '"' .. poseId ..'/>\n'
            end
        end
    end

    return changesTable
end

function UP_Creator:collectPartsInfo(partChange)
    if partChange ~= nil then
        local part = '\n            <partChange index="' .. partChange.indexString .. '"'

        local x1, y1, z1 = UP_Creator.getRoundedTable(partChange.transMin, 3, false)
        local x2, y2, z2 = UP_Creator.getRoundedTable(partChange.transMax, 3, false)
        if x1 ~= x2 or y1 ~= y2 or z1 ~= z2 then
            part = part .. ' transMin="' .. x1 .. ' ' .. y1 .. ' ' .. z1 .. '" transMax="' .. x2 .. ' ' .. y2 .. ' ' .. z2 .. '"'
        end

        x1, y1, z1 = UP_Creator.getRoundedTable(partChange.rotMin, 3, true)
        x2, y2, z2 = UP_Creator.getRoundedTable(partChange.rotMax, 3, true)
        if x1 ~= x2 or y1 ~= y2 or z1 ~= z2 then
            part = part .. ' rotMin="' .. x1 .. ' ' .. y1 .. ' ' .. z1 .. '" rotMax="' .. x2 .. ' ' .. y2 .. ' ' .. z2 .. '"'
        end

        x1, y1, z1 = UP_Creator.getRoundedTable(partChange.scaleMin, 3, false)
        x2, y2, z2 = UP_Creator.getRoundedTable(partChange.scaleMax, 3, false)
        if x1 ~= x2 or y1 ~= y2 or z1 ~= z2 then
            part = part .. ' scaleMin="' .. x1 .. ' ' .. y1 .. ' ' .. z1 .. '" scaleMax="' .. x2 .. ' ' .. y2 .. ' ' .. z2 .. '"'
        end

        part = part .. '/>\n'

        return part
    end

    return nil
end

function UP_Creator:storeCharacterTargetNodes(filename, seat, seatId)
    if filename ~= nil and seat ~= nil then
        filename = filename:lower()

        if self.vehicles[filename] == nil then
            self.vehicles[filename] = {}
        end

        if self.vehicles[filename][seatId] == nil then
            self.vehicles[filename][seatId] = {targetNodes = {}}
        end

        for targetId, target in pairs (seat.passengerCharacter.ikChainTargets) do
            if self.vehicles[filename][seatId].targetNodes[targetId] == nil then
                local x, y, z = getTranslation(target.targetNode)
                local rx, ry, rz = getRotation(target.targetNode)
                self.vehicles[filename][seatId].targetNodes[targetId] = {trans = string.format("%s %s %s", x, y, z), rot = string.format("%s %s %s", rx, ry, rz)}
            end
        end
    end
end

function UP_Creator:getDriverPosition(vehicle, xmlFile)
    local driverTG = I3DUtil.indexToObject(vehicle.components, getXMLString(xmlFile, "vehicle.enterable.characterNode#node"), vehicle.i3dMappings)
    local position = UP_Creator.getRoundedTrans(driverTG, 3, true)
    local rotation = UP_Creator.getRoundedRot(driverTG, 3, true)

    return {position = position, rotation = rotation}
end

function UP_Creator:writeXML(xmlPath)
    local file = io.open (xmlPath, "w")

    if file ~= nil then
        if self.raycastNodeErrors ~= nil and self.raycastNodeErrors > 0 then
            file:write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n\n<!-- IMPORTANT: ( ' ..tostring(self.raycastNodeErrors).. ' ) RaycastNode(s) have a position of "0 0 0" and these should be fixed. -->\n\n<universalPassengerVehicles>\n')
        else
            file:write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n\n<universalPassengerVehicles>\n')
        end

        file:write(self.content .. '\n</universalPassengerVehicles>')

        file:close()
    end

    self.listActive = false
    self.infoActive = false
end

function UP_Creator:loadVehicleList()
    self.vehicleList = {}
    --self:setupSeats()

    -- Read directly from game folder.
    -- Removed as only needed by GtX :-)
end

function UP_Creator.getRoundedTrans(var, prec, toString)
    local x, y, z = getTranslation(var)
    local precision = prec or 0

    if toString == true then
        x = UP_Creator.getTrueZero(MathUtil.round(x, precision))
        y = UP_Creator.getTrueZero(MathUtil.round(y, precision))
        z = UP_Creator.getTrueZero(MathUtil.round(z, precision))
        return string.format("%s %s %s", x, y, z)

        --return string.format("%." .. precision .. "f %." .. precision .. "f %." .. precision .. "f", x, y, z)
    else
        x = UP_Creator.getTrueZero(MathUtil.round(x, precision))
        y = UP_Creator.getTrueZero(MathUtil.round(y, precision))
        z = UP_Creator.getTrueZero(MathUtil.round(z, precision))

        return x, y, z
    end
end

function UP_Creator.getRoundedRot(var, prec, toString)
    local rx, ry, rz = getRotation(var)
    local precision = prec or 0

    if toString == true then
        rx = UP_Creator.getTrueZero(MathUtil.round(math.deg(rx), precision))
        ry = UP_Creator.getTrueZero(MathUtil.round(math.deg(ry), precision))
        rz = UP_Creator.getTrueZero(MathUtil.round(math.deg(rz), precision))
        return string.format("%s %s %s", rx, ry, rz)

        --return string.format("%." .. precision .. "f %." .. precision .. "f %." .. precision .. "f", math.deg(rx), math.deg(ry), math.deg(rz))
    else
        rx = UP_Creator.getTrueZero(MathUtil.round(math.deg(rx), prec))
        ry = UP_Creator.getTrueZero(MathUtil.round(math.deg(ry), prec))
        rz = UP_Creator.getTrueZero(MathUtil.round(math.deg(rz), prec))
        return rx, ry, rz
    end
end

function UP_Creator.getRoundedTable(tab, prec, degree)
    local x, y, z = tab[1], tab[2], tab[3]

    if degree then
        x = UP_Creator.getTrueZero(MathUtil.round(math.deg(x), prec))
        y = UP_Creator.getTrueZero(MathUtil.round(math.deg(y), prec))
        z = UP_Creator.getTrueZero(MathUtil.round(math.deg(z), prec))
    else
        x = UP_Creator.getTrueZero(MathUtil.round(x, prec))
        y = UP_Creator.getTrueZero(MathUtil.round(y, prec))
        z = UP_Creator.getTrueZero(MathUtil.round(z, prec))
    end

    return x, y, z
end

function UP_Creator.noNilRound(val, prec, cons)
    if val ~= nil then
        return MathUtil.round(val, prec)
    end

    return cons or 0
end

function UP_Creator.getCorrectedRotation(rot, factor, normal)
    local pi = math.pi

    if rot > pi then
        rot = -pi
    elseif rot < -pi then
        rot = pi
    end

    if rot > pi then
        if normal then
            rot = rot - factor
        else
            rot = rot + factor
        end
    else
        if normal then
            rot = rot + factor
        else
            rot = rot - factor
        end
    end

    return rot
end

function UP_Creator.getTrueZero(value)
    -- We do not want to see a -0 just for XML looks.
    if value == 0.0 then
        return 0
    end

    return value
end
