--[[
Interface: 1.5.1.0 b6732

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 08.10.2018
Version: 1.0.0.0

History:
V 0.9.0.0 @ 08.10.2018 - FS17 Version (Not Released)
V 1.0.0.0 @ 31.07.2019 - Beta Version

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy


Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


UP_ChangedFunctions = {}

function UP_ChangedFunctions.initFunctions()
    FSBaseMission.delete = Utils.appendedFunction(FSBaseMission.delete, UP_ChangedFunctions.finalDelete)
    FSBaseMission.registerActionEvents = Utils.appendedFunction(FSBaseMission.registerActionEvents, UP_ChangedFunctions.registerActionEvents)
    FSBaseMission.onConnectionFinishedLoading = Utils.appendedFunction(FSBaseMission.onConnectionFinishedLoading, UP_ChangedFunctions.onConnectionFinishedLoading)
    FSBaseMission.onConnectionClosed = Utils.prependedFunction(FSBaseMission.onConnectionClosed, UP_ChangedFunctions.onConnectionClosed)

    BaseMission.requestToEnterVehicle = Utils.prependedFunction(BaseMission.requestToEnterVehicle, UP_ChangedFunctions.requestToEnterVehicle)
    BaseMission.unregisterActionEvents = Utils.appendedFunction(BaseMission.unregisterActionEvents, UP_ChangedFunctions.unregisterActionEvents)

    Player.getPositionData = Utils.overwrittenFunction(Player.getPositionData, UP_ChangedFunctions.getPositionData)
    IngameMap.drawEnterableArrows = Utils.appendedFunction(IngameMap.drawEnterableArrows, UP_ChangedFunctions.drawPassengerNames)
    StoreItemUtil.getConfigurationsFromXML = Utils.overwrittenFunction(StoreItemUtil.getConfigurationsFromXML, UP_ChangedFunctions.getConfigurationsFromXML)
end

function UP_ChangedFunctions:registerActionEvents()
    if g_universalPassenger ~= nil then
        g_universalPassenger:registerActionEvents()
    end
end

function UP_ChangedFunctions:unregisterActionEvents()
    if g_universalPassenger ~= nil then
        g_universalPassenger:unregisterActionEvents()
    end
end

function UP_ChangedFunctions:finalDelete()
    if g_universalPassenger ~= nil then
        g_universalPassenger:finalDelete()
    end
end

function UP_ChangedFunctions:requestToEnterVehicle(vehicleToEnter)
    if g_universalPassenger == nil then
        return
    end

    local vehicle, seatId = g_universalPassenger:getVehicleAndSeatId()
    if vehicle ~= nil then
        if g_server ~= nil then
            vehicle:exitPassengerSeat(seatId, UniversalPassengerSpec.ENTER_DRIVER)
            g_server:broadcastEvent(UniversalPassengerExitEvent:new(vehicle, seatId, UniversalPassengerSpec.ENTER_DRIVER))
        else
            g_client:getServerConnection():sendEvent(UniversalPassengerExitEvent:new(vehicle, seatId, UniversalPassengerSpec.ENTER_DRIVER))
            vehicle:exitPassengerSeat(seatId, UniversalPassengerSpec.ENTER_DRIVER)
        end
    end
end

function UP_ChangedFunctions:getPositionData(superFunc)
    if g_universalPassenger ~= nil and g_universalPassenger.enteredVehicles[self] ~= nil then
        local vehicle = g_universalPassenger.enteredVehicles[self]
        local posX, posY, posZ = getTranslation(vehicle.rootNode)
        local dx, _, dz = localDirectionToWorld(vehicle.rootNode, 0, 0, 1)

        local yRot
        if vehicle.spec_drivable ~= nil and vehicle.spec_drivable.reverserDirection == -1 then
            yRot = MathUtil.getYRotationFromDirection(dx, dz)
        else
            yRot = MathUtil.getYRotationFromDirection(dx, dz) + math.pi
        end

        return posX, posY, posZ, yRot

    end

    return superFunc(self)
end

function UP_ChangedFunctions:drawPassengerNames(showNames, leftBorderReached, rightBorderReached, topBorderReached, bottomBorderReached)
    if not g_currentMission.missionDynamicInfo.isMultiplayer then
        return
    end

    local resetNameCount = true
    for player, vehicle in pairs(g_universalPassenger.enteredVehicles) do
        if player ~= nil and vehicle ~= nil then
            if player ~= g_currentMission.player and player.visualInformation ~= nil then
                local spec = vehicle.spec_universalPassenger
                if resetNameCount then
                    spec.mapNameCount = 1
                end

                local posX, _, posZ, rotY = player:getPositionData()
                posX = (math.floor(posX) + self.worldCenterOffsetX) / self.worldSizeX
                posZ = (math.floor(posZ) + self.worldCenterOffsetZ) / self.worldSizeZ

                local positionVisible = self:setMapObjectOverlayPosition(self.mapArrowRedOverlay, posX, posZ,
                    self.mapArrowRedOverlay.width, self.mapArrowRedOverlay.height, true, showNames,
                    leftBorderReached, rightBorderReached, topBorderReached, bottomBorderReached)

                if positionVisible then
                    local r,g,b,a = self:colorForFarm(player.farmId)

                    -- Only show this overlay when there is no driver so it is not a mess of arrows.
                    if not vehicle:getIsControlled() then
                        self:setMapObjectOverlayRotation(self.mapArrowRedOverlay, rotY)
                        self.mapArrowRedOverlay:setColor(r, g, b, a)
                        self.mapArrowRedOverlay:render()
                    end

                    if showNames then
                        setTextBold(false)
                        setTextColor(r, g, b, a)
                        setTextAlignment(RenderText.ALIGN_LEFT)

                        local textWidth = getTextWidth(self.playerFontSize, player.visualInformation.playerName)
                        posX = MathUtil.clamp(self.mapArrowRedOverlay.x + self.mapArrowRedOverlay.width * 0.5 + self.playerNameOffsetX - textWidth * 0.5, self.mapPosX, self.mapPosX + self.mapWidth - textWidth)

                        local text = tostring(player.visualInformation.playerName)
                        local textHeight = getTextHeight(self.playerFontSize, text)
                        renderText(posX, self.mapArrowRedOverlay.y + self.playerNameOffsetY - (textHeight + self.playerNameOffsetY) * spec.mapNameCount, self.playerFontSize, text)

                        spec.mapNameCount = spec.mapNameCount + 1
                    end
                end
            end
        end
    end
end

function UP_ChangedFunctions:onConnectionFinishedLoading(connection, x, y, z, viewDistanceCoeff)
    if self:getIsServer() and g_universalPassenger ~= nil then
        g_universalPassenger:onConnectionFinishedLoading(connection)
    end
end

function UP_ChangedFunctions:onConnectionClosed(connection)
    if self:getIsServer() and g_universalPassenger ~= nil then
        for _, passengerVehicle in pairs(g_universalPassenger.passengerVehicles) do
            local spec = passengerVehicle.spec_universalPassenger
            if spec ~= nil and spec.connectionToSeatId[connection] ~= nil then
                local seatId = spec.connectionToSeatId[connection]

                local seat = spec.passengerSeats[seatId]
                g_universalPassenger:logPrint(UniversalPassenger.LOG_DEV_DEBUG, "Kicking %s from seat id %d!", seat.passengerName, seatId)

                spec.connectionToSeatId[connection] = nil
                passengerVehicle:exitPassengerSeat(seatId, UniversalPassengerSpec.EXIT)
                g_server:broadcastEvent(UniversalPassengerExitEvent:new(passengerVehicle, seatId, UniversalPassengerSpec.EXIT))
            end
        end
    end
end

function UP_ChangedFunctions.getConfigurationsFromXML(xmlFile, superFunc, baseXMLName, baseDir, customEnvironment, isMod, storeItem)
    local vehicleConfigurations = superFunc(xmlFile, baseXMLName, baseDir, customEnvironment, isMod, storeItem)

    if g_universalPassenger ~= nil and baseXMLName == "vehicle" and vehicleConfigurations ~= nil then
        -- This is only for mods with Universal Passenger positions pre-added.
        if hasXMLProperty(xmlFile, "vehicle.universalPassenger") then
            if vehicleConfigurations["universalPassenger"] == nil then
                local texts = g_universalPassenger.texts
                vehicleConfigurations["universalPassenger"] = {
                    {desc = "", price = 0, dailyUpkeep = 0, isDefault = true, index = 1, name = texts.configurationOne},
                    {desc = "", price = 0, dailyUpkeep = 0, isDefault = false, index = 2, name = texts.configurationTwo},
                    {desc = "", price = 0, dailyUpkeep = 0, isDefault = false, index = 3, name = texts.configurationThree}
                }
            end
        end
    end

    return vehicleConfigurations
end
