--[[
Interface: 1.5.1.0 b6732

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 25.08.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 25.08.2019 - Release Version

Important:
No changes are to be made to this script without permission from GtX | Andy
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


ObjectStorageSpawnEvent = {}
local ObjectStorageSpawnEvent_mt = Class(ObjectStorageSpawnEvent, Event)

InitEventClass(ObjectStorageSpawnEvent, "ObjectStorageSpawnEvent")

function ObjectStorageSpawnEvent:emptyNew()
    local self = Event:new(ObjectStorageSpawnEvent_mt)

    return self
end

function ObjectStorageSpawnEvent:new(storage, fillTypeIndex, numberToSpawn)
    local self = ObjectStorageSpawnEvent:emptyNew()

    self.storage = storage
    self.fillTypeIndex = fillTypeIndex
    self.numberToSpawn = numberToSpawn

    return self
end

function ObjectStorageSpawnEvent:writeStream(streamId, connection)
    assert(connection:getIsServer())

    NetworkUtil.writeNodeObject(streamId, self.storage)
    streamWriteUIntN(streamId, self.fillTypeIndex, FillTypeManager.SEND_NUM_BITS)
    streamWriteInt8(streamId, self.numberToSpawn)
end

function ObjectStorageSpawnEvent:readStream(streamId, connection)
    assert(g_currentMission:getIsServer())

    self.storage = NetworkUtil.readNodeObject(streamId)
    self.fillTypeIndex = streamReadUIntN(streamId, FillTypeManager.SEND_NUM_BITS)
    self.numberToSpawn = streamReadInt8(streamId)

    self:run(connection)
end

function ObjectStorageSpawnEvent:run(connection)
    if g_server ~= nil and self.storage ~= nil then
        self.storage:spawnSelectedObject(self.fillTypeIndex, self.numberToSpawn)
    else
        if g_server == nil then
            print("  Error: [ObjectStorageSpawnEvent] This is a Client > Server event only!")
        else
            print("  Warning: [ObjectStorageSpawnEvent] No 'storage' object found or given. Update failed!")
        end
    end
end
