--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 09.12.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 0.1.0.0 @ 09.12.2018 - Internal Beta
V 0.1.1.0 @ 17.02.2019 - Test Version
V 1.0.0.0 @ 02.05.2019 - Release Version

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


MilkSaleDialog = {}
local MilkSaleDialog_mt = Class(MilkSaleDialog, YesNoDialog)

MilkSaleDialog.MILK_TRUCK_BACKUP_FEE = 1089 -- backup
MilkSaleDialog.MILK_TRUCK_VOLUME = 32000 -- mks32 size

MilkSaleDialog.CONTRACTOR_TRUCKS = {
    "data/vehicles/lizard/truckS/store_truckS.dds",
    "data/vehicles/man/tgs18500/store_tgs18500.dds",
    "data/vehicles/lizard/truckL/store_truckL.dds",
    "data/vehicles/tatra/tatraPhoenix/store_tatraPhoenix.dds",
    "data/vehicles/lizard/truckM/store_truckM.dds"
}

MilkSaleDialog.CONTROLS = {
    MESSAGE_BACKGROUND = "messageBackground",
    DESCRIPTION_TEXT = "descriptionText",
    AMOUNT_TEXT = "amountText",
    CAPACITY_TEXT = "capacityText",
    MARKET_VALUE_TEXT = "marketValueText",
    SALE_PRICE_VALUE = "salePriceValue",
    FEE_VALUE = "feeValue",
    TOTAL_VALUE = "totalValue",
    LITRES_TO_SELL_ELEMENT = "litresToSellElement",
    INFO_BOX_TEXT = "infoBoxText",
    TRUCK_IMAGE_ELEMENT = "truckImageElement",
    TRAILER_IMAGE_ELEMENT = "trailerImageElement"
}

function MilkSaleDialog:new(target, texts, customMt)
    local self = YesNoDialog:new(target, customMt or MilkSaleDialog_mt)

    self:registerControls(MilkSaleDialog.CONTROLS)

    self.texts = texts
    self.target = target
    self.litresToSell = 0
    self.buttonsDisabled = false
    self.sellPointUpdateTimer = 600

    return self
end

function MilkSaleDialog:setData(fillLevel, capacity)
    self.lastLitresToSell = -1
    self.lastCurrentMarketValue = -1

    self.availableSellPoints = {}
    for _, unloadingStation in pairs (g_currentMission.storageSystem.unloadingStations) do
        if unloadingStation.isSellingPoint and unloadingStation.fillTypePrices[FillType.MILK] ~= nil and unloadingStation.fillTypePrices[FillType.MILK] > 0 then
            table.insert(self.availableSellPoints, unloadingStation)
        end
    end

    self.bestSellPoint, self.currentMarketValue = self:getSellPointData()

    self.litresToSellTable = {0}
    local litresToSellMapping = {g_i18n:formatFluid(0, 0)};
    if fillLevel < 1000 then
        self.litresToSellTable[2] = fillLevel
        litresToSellMapping[2] = g_i18n:formatFluid(fillLevel, 0)
    else
        local mapping = 0
        while mapping < fillLevel do
            mapping = mapping + math.min(1000, (fillLevel - mapping))
            table.insert(self.litresToSellTable, mapping)

            local text = g_i18n:formatFluid(mapping, 0)
            table.insert(litresToSellMapping, text)
        end
    end

    self.litresToSellElement:setTexts(litresToSellMapping)
    self.litresToSellElement:setState(1, true)

    self.amountText:setText(self.texts.amount)
    self.descriptionText:setText(self.texts.description)
    self.capacityText:setText(string.format(self.texts.milkCapacity, g_i18n:formatFluid(capacity, 0)))
    self.marketValueText:setText(string.format(self.texts.marketValue, g_i18n:formatMoney((self.currentMarketValue * 1000), 0, true, false)))

    if self.bestSellPoint ~= nil then
        local truckId = math.random(1, 5)
        self.truckImageElement:setImageFilename(MilkSaleDialog.CONTRACTOR_TRUCKS[truckId])
        self.trailerImageElement:setImageFilename("data/vehicles/lizard/mks32/store_mks32.dds")
        self.truckImageElement:setVisible(true)
        self.trailerImageElement:setVisible(true)
        self.litresToSellElement:setDisabled(false)
    else
        self.truckImageElement:setVisible(false)
        self.trailerImageElement:setVisible(false)
        self.infoBoxText:setText(self.texts.noMilkSellPointWarning)
        self.infoBoxText:setTextColor(0.8069, 0.0097, 0.0097, 1)
        self.litresToSellElement:setDisabled(true)
    end
end

function MilkSaleDialog:getSellPointData()
    local bestSellPoint
    local highestValue = 0
    local numSellPoints = #self.availableSellPoints
    if numSellPoints > 0 then
        for i = 1, numSellPoints do
            local sellPoint = self.availableSellPoints[i]
            local price = sellPoint:getEffectiveFillTypePrice(FillType.MILK)
            if price ~= nil and price > highestValue then
                highestValue = price
                bestSellPoint = sellPoint
            end
        end

        if bestSellPoint ~= nil then
            return bestSellPoint, highestValue
        end
    end

    return nil, 0.0
end

function MilkSaleDialog:getContractorFee(numTrips, marketValue)
    local difficultyMultiplier = math.max(EconomyManager.PRICE_MULTIPLIER[g_currentMission.missionInfo.difficulty], 1)
    local feePerTrip = ((0.05 * (marketValue * MilkSaleDialog.MILK_TRUCK_VOLUME)) / difficultyMultiplier)
    if feePerTrip > 0 then
        return math.floor(feePerTrip * numTrips)
    end

    return MilkSaleDialog.MILK_TRUCK_BACKUP_FEE
end

function MilkSaleDialog:update(dt)
    MilkSaleDialog:superClass().update(self, dt)

    self.sellPointUpdateTimer = self.sellPointUpdateTimer - dt
    if self.sellPointUpdateTimer < 0 then
        self.bestSellPoint, self.currentMarketValue = self:getSellPointData()
        self:updatePrices(true)
        self.sellPointUpdateTimer = 600
    end
end

function MilkSaleDialog:onClickSellAmount(id)
    self.litresToSell = self.litresToSellTable[id]
    self:updatePrices(false)
end

function MilkSaleDialog:updatePrices(isUpdate)
    if (self.litresToSell ~= self.lastLitresToSell) or (self.currentMarketValue ~= self.lastCurrentMarketValue) then
        self.lastLitresToSell = self.litresToSell
        self.lastCurrentMarketValue = self.currentMarketValue

        if isUpdate then
            self.marketValueText:setText(string.format(self.texts.marketValue, g_i18n:formatMoney((self.currentMarketValue * 1000), 0, true, false)))
        end

        if self.litresToSell > 0 then
            self:setButtonDisabled(false)
            local numTrips = math.ceil((self.litresToSell / MilkSaleDialog.MILK_TRUCK_VOLUME))
            local salePrice = self.litresToSell * self.currentMarketValue
            self.contractorFee = self:getContractorFee(numTrips, self.currentMarketValue)

            self.salePriceValue:setText(g_i18n:formatMoney(salePrice, 0, true, false))
            self.feeValue:setText(g_i18n:formatMoney(-self.contractorFee, 0, true, false))
            self.totalValue:setText(g_i18n:formatMoney((salePrice - self.contractorFee), 0, true, false))
        else
            self:setButtonDisabled(true)
            local setZeroMoney = g_i18n:formatMoney(0, 0, true, false)
            self.salePriceValue:setText(setZeroMoney)
            self.feeValue:setText(setZeroMoney)
            self.totalValue:setText(setZeroMoney)

            self.contractorFee = 0
        end
    end
end

function MilkSaleDialog:onClickOk()
    self:close()
    if not self.buttonsDisabled then
        if self.callback ~= nil and self.target ~= nil then
            self.callback(self.target, self.litresToSell, self.contractorFee, self.bestSellPoint)
        end
    end
end

function MilkSaleDialog:onClickBack()
    self:close()
end

function MilkSaleDialog:loadCallback(callback, target)
    self.callback = callback
    self.target = target
end

function MilkSaleDialog:setButtonDisabled(state)
    if self.buttonsDisabled ~= state then
        self.buttonsDisabled = state
        self.yesButton:setDisabled(state)
    end
end
