--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 09.12.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 0.1.0.0 @ 09.12.2018 - Internal Beta
V 0.1.1.0 @ 17.02.2019 - Test Version
V 1.0.0.0 @ 02.05.2019 - Release Version

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


AnimalPenExtensionSellMilkEvent = {}
AnimalPenExtensionSellMilkEvent_mt = Class(AnimalPenExtensionSellMilkEvent, Event)
InitEventClass(AnimalPenExtensionSellMilkEvent, "AnimalPenExtensionSellMilkEvent")

function AnimalPenExtensionSellMilkEvent:emptyNew()
    local self = Event:new(AnimalPenExtensionSellMilkEvent_mt)
    return self
end

function AnimalPenExtensionSellMilkEvent:new(animalPen, amountToSell, contractorFee, sellPoint)
    local self = AnimalPenExtensionSellMilkEvent:emptyNew()
    self.animalPen = animalPen
    self.amountToSell = amountToSell
    self.contractorFee = contractorFee
    self.sellPoint = sellPoint
    return self
end

function AnimalPenExtensionSellMilkEvent:readStream(streamId, connection)
    local animalPen = NetworkUtil.readNodeObject(streamId)
    local amountToSell = streamReadFloat32(streamId)
    local contractorFee = streamReadFloat32(streamId)
    local sellPoint = NetworkUtil.readNodeObject(streamId)

    if animalPen ~= nil and sellPoint ~= nil then
        if g_server ~= nil then
            animalPen:sellMilkCallback(amountToSell, contractorFee, sellPoint)
        else
            print("Client > Server only event!")
        end
    end
end

function AnimalPenExtensionSellMilkEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.animalPen)
    streamWriteFloat32(streamId, self.amountToSell)
    streamWriteFloat32(streamId, self.contractorFee)
    NetworkUtil.writeNodeObject(streamId, self.sellPoint)
end
