--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 09.12.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 0.1.0.0 @ 09.12.2018 - Internal Beta
V 0.1.1.0 @ 17.02.2019 - Test Version
V 1.0.0.0 @ 02.05.2019 - Release Version

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


AnimalPenExtensionJoinGameEvent = {}
AnimalPenExtensionJoinGameEvent_mt = Class(AnimalPenExtensionJoinGameEvent, Event)
InitEventClass(AnimalPenExtensionJoinGameEvent, "AnimalPenExtensionJoinGameEvent")

function AnimalPenExtensionJoinGameEvent:emptyNew()
    local self = Event:new(AnimalPenExtensionJoinGameEvent_mt)
    return self
end

function AnimalPenExtensionJoinGameEvent:new(purchaseState, waterPriceScale, maintenancePerDay, chanceOfDelay, waterActive, milkActive, chickenActive, randomDelayActive, delayTextId)
    local self = AnimalPenExtensionJoinGameEvent:emptyNew()
    self.purchaseState = purchaseState
    self.waterPriceScale = waterPriceScale
    self.maintenancePerDay = maintenancePerDay
    self.chanceOfDelay = chanceOfDelay
    self.waterActive = waterActive
    self.milkActive = milkActive
    self.chickenActive = chickenActive
    self.randomDelayActive = randomDelayActive
    self.delayTextId = delayTextId

    return self
end

function AnimalPenExtensionJoinGameEvent:readStream(streamId, connection)
    if connection:getIsServer() then
        local purchaseState = streamReadBool(streamId)
        local waterPriceScale = streamReadFloat32(streamId)
        local maintenancePerDay = streamReadInt8(streamId)
        local chanceOfDelay = streamReadUInt8(streamId)
        local waterActive = streamReadBool(streamId)
        local milkActive = streamReadBool(streamId)
        local chickenActive = streamReadBool(streamId)

        local delayTextId = 1
        local randomDelayActive = streamReadBool(streamId)
        if randomDelayActive then
            delayTextId = streamReadUInt8(streamId)
        end

        if g_animalPenExtensionManager ~= nil then
            g_animalPenExtensionManager.chickenAddonActive = chickenActive
            g_animalPenExtensionManager.milkAddonActive = milkActive
            g_animalPenExtensionManager.chanceOfDelay = chanceOfDelay
            g_animalPenExtensionManager.waterAddonActive = waterActive
            g_animalPenExtensionManager.purchaseOverride = purchaseState
            g_animalPenExtensionManager.waterPriceScaleOverride = waterPriceScale
            g_animalPenExtensionManager.maintenancePerDayOverride = maintenancePerDay

            g_animalPenExtensionManager:setDelayData(randomDelayActive, delayTextId, false)
        end
    end
end

function AnimalPenExtensionJoinGameEvent:writeStream(streamId, connection)
    if not connection:getIsServer() then
        streamWriteBool(streamId, self.purchaseState)
        streamWriteFloat32(streamId, self.waterPriceScale)
        streamWriteInt8(streamId, self.maintenancePerDay)
        streamWriteUInt8(streamId, self.chanceOfDelay)
        streamWriteBool(streamId, self.waterActive)
        streamWriteBool(streamId, self.milkActive)
        streamWriteBool(streamId, self.chickenActive)

        if streamWriteBool(streamId, self.randomDelayActive) then
            streamWriteUInt8(streamId, self.delayTextId)
        end
    end
end
