--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 09.12.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 0.1.0.0 @ 09.12.2018 - Internal Beta
V 0.1.1.0 @ 17.02.2019 - Test Version
V 1.0.0.0 @ 02.05.2019 - Release Version

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


AnimalPenExtensionDelayEvent = {}
AnimalPenExtensionDelayEvent_mt = Class(AnimalPenExtensionDelayEvent, Event)
InitEventClass(AnimalPenExtensionDelayEvent, "AnimalPenExtensionDelayEvent")

function AnimalPenExtensionDelayEvent:emptyNew()
    local self = Event:new(AnimalPenExtensionDelayEvent_mt)
    return self
end

function AnimalPenExtensionDelayEvent:new(randomDelayActive, delayTextId, forceUpdate)
    local self = AnimalPenExtensionDelayEvent:emptyNew()
    self.randomDelayActive = randomDelayActive
    self.delayTextId = delayTextId
    self.forceUpdate = forceUpdate

    return self
end

function AnimalPenExtensionDelayEvent:readStream(streamId, connection)
    if connection:getIsServer() then
        local randomDelayActive = streamReadBool(streamId)

        local delayTextId = 1
        if randomDelayActive then
            delayTextId = streamReadUInt8(streamId)
        end

        local forceUpdate = streamReadBool(streamId)

        if g_animalPenExtensionManager ~= nil then
            g_animalPenExtensionManager:setDelayData(randomDelayActive, delayTextId, false, self.forceUpdate)
        end
    end
end

function AnimalPenExtensionDelayEvent:writeStream(streamId, connection)
    if not connection:getIsServer() then
        if streamWriteBool(streamId, self.randomDelayActive) then
            streamWriteUInt8(streamId, self.delayTextId)
        end

        streamWriteBool(streamId, self.forceUpdate)
    end
end
