--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 09.12.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 0.1.0.0 @ 09.12.2018 - Internal Beta
V 0.1.1.0 @ 17.02.2019 - Test Version
V 1.0.0.0 @ 02.05.2019 - Release Version

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


AnimalPenExtensionBuildHourEvent = {}
AnimalPenExtensionBuildHourEvent_mt = Class(AnimalPenExtensionBuildHourEvent, Event)
InitEventClass(AnimalPenExtensionBuildHourEvent, "AnimalPenExtensionBuildHourEvent")

function AnimalPenExtensionBuildHourEvent:emptyNew()
    local self = Event:new(AnimalPenExtensionBuildHourEvent_mt)
    return self
end

function AnimalPenExtensionBuildHourEvent:new(animalPen, buildHour)
    local self = AnimalPenExtensionBuildHourEvent:emptyNew()
    self.animalPen = animalPen
    self.buildHour = buildHour

    return self
end

function AnimalPenExtensionBuildHourEvent:readStream(streamId, connection)
    local animalPen = NetworkUtil.readNodeObject(streamId)
    local buildHour = streamReadInt8(streamId)

    if animalPen ~= nil then
        animalPen:setWaterAddonBuildHour(buildHour)
    end
end

function AnimalPenExtensionBuildHourEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.animalPen)
    streamWriteInt8(streamId, self.buildHour)
end
