--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 09.12.2018
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 0.1.0.0 @ 09.12.2018 - Internal Beta
V 0.1.1.0 @ 17.02.2019 - Test Version
V 1.0.0.0 @ 02.05.2019 - Release Version
V 1.1.0.0 @ 17.07.2019 - Add support to position 'waterAddon' parts on unsupported mods.

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


AnimalPenExtensionManager = {}
local AnimalPenExtensionManager_mt = Class(AnimalPenExtensionManager)

local manager
AnimalPenExtensionManager.buildId = 1
AnimalPenExtensionManager.versionString = "1.1.0.2"

function AnimalPenExtensionManager:new(isServer, isClient, customEnvironment, baseDirectory, xmlFilename)
    if g_animalPenExtensionManager ~= nil then
        return
    end

    local self = {}
    setmetatable(self, AnimalPenExtensionManager_mt)

    self.isServer = isServer
    self.isClient = isClient

    self.customEnvironment = customEnvironment
    self.baseDirectory = baseDirectory

    self.baseBuildings = {}
    self.baseBuildingsLoaded = 0
    self.baseBuildingsXMLFilename = xmlFilename

    self.universalPartsXMLFilename = baseDirectory .. "xml/UniversalParts.xml"

    self.chickenAddonActive = true
    self.waterAddonActive = true
    self.milkAddonActive = true
    self.purchaseOverride = false
    self.waterPriceScaleOverride = -1
    self.maintenancePerDayOverride = -1

    self.texts = {
        water = g_i18n:getText("fillType_water"),
        waterFillLevel = g_i18n:getText("info_waterFillLevel"),
        stopFilling = g_i18n:getText("action_siloStopFilling"),
        startFilling = g_i18n:getText("action_siloStartFilling"),
        noAnimalsWarning = g_i18n:getText("animalPenExtension_noAnimalsWarning"),
        callMilkContractor = g_i18n:getText("animalPenExtension_callMilkContractor"),
        dialogHeader = g_i18n:getText("animalPenExtension_dialogHeader"),
        milkCapacity = g_i18n:getText("animalPenExtension_milkCapacity"),
        marketValue = g_i18n:getText("animalPenExtension_marketValue"),
        description = g_i18n:getText("animalPenExtension_description"),
        amount = g_i18n:getText("animalPenExtension_amount"),
        salesClosed = g_i18n:getText("animalPenExtension_salesClosed"),
        noMilkSellPointWarning = g_i18n:getText("animalPenExtension_noMilkSellPointWarning"),
        requiredPermissions = g_i18n:getText("animalPenExtension_requiredPermissions"),
        doPurchase = g_i18n:getText("animalPenExtension_doPurchase"),
        checkBuildState= g_i18n:getText("animalPenExtension_checkBuildState"),
        bought = g_i18n:getText("animalPenExtension_bought"),
        startedBuild = g_i18n:getText("animalPenExtension_startedBuild"),
        startedBuildNoPlumber = g_i18n:getText("animalPenExtension_startedBuildNoPlumber"),
        purchase = g_i18n:getText("animalPenExtension_purchase"),
        chickenWaterAddon = g_i18n:getText("animalPenExtension_chickenWaterAddon")
    }

    self.randomDelayTexts = {}
    self.randomDelayTextsUsed = {}
    for i = 1, 6 do
        local text = string.format("animalPenExtension_randomDelay_%d", i)
        if g_i18n:hasText(text) then
            self.randomDelayTextsUsed[text] = true
            table.insert(self.randomDelayTexts, g_i18n:getText(text))
        end
    end

    self.delayTextId = 1
    self.randomDelayActive = false

    self.totalDelays = 0
    self.previousDelayIds = {0, 0, 0}

    self.showFirstStart = false
    self.firstStartUpdateTime = 2000

    self.debugActive = false -- Dev Only

    return self
end

function AnimalPenExtensionManager:load()
    local success, numLoaded = self:loadBaseBuildings()

    if success then
        if self.isServer then
            if g_currentMission ~= nil then
                if g_currentMission.environment ~= nil then
                    g_currentMission.environment:addDayChangeListener(g_animalPenExtensionManager)
                end

                local firstTimeRun = true
                if g_currentMission.missionInfo ~= nil then
                    if g_currentMission.missionInfo.savegameDirectory ~= nil then
                        local path = g_currentMission.missionInfo.savegameDirectory .. "/animalPenExtension.xml"
                        if fileExists(path) then
                            local xmlFile = loadXMLFile("AnimalPenExtensionXML", path)
                            if xmlFile ~= nil then
                                self:loadFromXML(xmlFile)
                                delete(xmlFile)
                                xmlFile = nil

                                firstTimeRun = false
                            end
                        end
                    end
                end

                if firstTimeRun then
                    self.chanceOfDelay = self:getDefaultDelayChance()

                    self.showFirstStart = not g_currentMission.missionDynamicInfo.isMultiplayer
                    self:setDelayData(false, 1, false, false)

                    if self.showFirstStart then
                        g_currentMission:addUpdateable(g_animalPenExtensionManager)
                    end
                end
            end
        end

        if self.chickenAddonActive then
            if self:initChickenWaterSupport() then
                -- Best I can do with no reference on GDN like many things :-(
                if InGameMenuAnimalsFrame.getFoodDescription ~= nil then
                    InGameMenuAnimalsFrame.getFoodDescription = Utils.overwrittenFunction(InGameMenuAnimalsFrame.getFoodDescription, function (self, superFunc, forAnimalType)
                        if forAnimalType == "CHICKEN" then
                            if self.selectedHusbandry ~= nil then
                                local waterModule = self.selectedHusbandry:getModuleByName("water")
                                if waterModule ~= nil then
                                    if g_animalPenExtensionManager ~= nil then
                                        local extraText = g_animalPenExtensionManager.texts.chickenWaterAddon
                                        local foodDescription = superFunc(self, forAnimalType)
                                        return string.format("%s\n\n%s", foodDescription, extraText)
                                    end
                                end
                            end
                        end

                        return superFunc(self, forAnimalType)
                    end)
                end
            else
                self.chickenAddonActive = false
                self:logPrint(1, "Chicken Addon failed to initiate! This mode is now unavailable.")
            end
        end

        g_animalPenExtensionManager.consoleCommands:load()

        self:logPrint(1, "Version: %s loaded into %s Default Animal Husbandry building type(s).", AnimalPenExtensionManager.versionString, numLoaded)

        return true
    end
end

function AnimalPenExtensionManager:delete()
    g_currentMission:removeUpdateable(self)
end

function AnimalPenExtensionManager:update(dt)
    if self.isServer then
        if self.showFirstStart then
            if self.firstStartUpdateTime > 0 then
                self.firstStartUpdateTime = self.firstStartUpdateTime - dt
            else
                if not g_gui:getIsGuiVisible() then
                    self.showFirstStart = false

                    if g_currentMission.hud ~= nil and g_currentMission.hud.popupMessage ~= nil then
                        local savegameIndex = g_currentMission.missionInfo.savegameIndex

                        --local endText = "\n\nRegards,\nGtX"
                        --if g_languageShort == "de" then
                            --endText = "\n\nGrüße,\nGtX"
                        --end

                        local title = "Animal Pen Extension - Version " .. AnimalPenExtensionManager.versionString
                        local message = string.format(g_i18n:getText("animalPenExtension_firstTimeRun"), g_currentMission.missionInfo:getSavegameDirectory(savegameIndex))
                        g_currentMission.hud.popupMessage:showMessage(title, message, -1, nil, nil, nil)
                    end
                end
            end
        else
            g_currentMission:removeUpdateable(self)
        end
    end
end

function AnimalPenExtensionManager:finalDelete()
    if g_animalPenExtensionManager.universalPlacement ~= nil then
        g_animalPenExtensionManager.universalPlacement:delete()
        g_animalPenExtensionManager.universalPlacement = nil
    end

    if g_currentMission ~= nil and g_currentMission:getIsServer() then
        if g_currentMission.environment ~= nil then
            g_currentMission.environment:removeDayChangeListener(g_animalPenExtensionManager)
        end
    end

    g_animalPenExtensionManager.consoleCommands:delete()

    getfenv(0)["g_animalPenExtensionManager"] = nil
    manager = nil
end

function AnimalPenExtensionManager:loadFromXML(xmlFile)
    self.chickenAddonActive = Utils.getNoNil(getXMLBool(xmlFile, "animalPenExtension.settings.chickenAddon#active"), true)
    self.milkAddonActive = Utils.getNoNil(getXMLBool(xmlFile, "animalPenExtension.settings.milkAddon#active"), true)
    self.chanceOfDelay = math.min(Utils.getNoNil(getXMLInt(xmlFile, "animalPenExtension.settings.milkAddon#chanceOfDelayPercent"), self:getDefaultDelayChance()), 100)

    self.waterAddonActive = Utils.getNoNil(getXMLBool(xmlFile, "animalPenExtension.settings.waterAddon#active"), true)
    self.purchaseOverride = Utils.getNoNil(getXMLBool(xmlFile, "animalPenExtension.settings.waterAddon#purchaseOverride"), true)
    self.waterPriceScaleOverride = Utils.getNoNil(getXMLFloat(xmlFile, "animalPenExtension.settings.waterAddon#waterPriceScaleOverride"), -1)
    self.maintenancePerDayOverride = Utils.getNoNil(getXMLInt(xmlFile, "animalPenExtension.settings.waterAddon#maintenancePerDayOverride"), -1)

    local randomDelayActive = Utils.getNoNil(getXMLBool(xmlFile, "animalPenExtension.milkAddon.randomDelay#isActive"), false)
    local delayTextId = math.max(Utils.getNoNil(getXMLInt(xmlFile, "animalPenExtension.milkAddon.randomDelay#textId"), 1), 1)
    self:setDelayData(randomDelayActive, delayTextId, false, false)

    self.totalDelays = math.max(Utils.getNoNil(getXMLInt(xmlFile, "animalPenExtension.milkAddon.randomDelay#delayCounter"), 0), 0)
    local previousDelayIds = StringUtil.splitString(" ", getXMLString(xmlFile, "animalPenExtension.milkAddon.randomDelay#previousDelayIds"))
    for i = 1, 3 do
        self.previousDelayIds[i] = tonumber(Utils.getNoNil(previousDelayIds[i], "0"))
    end
end

function AnimalPenExtensionManager:saveToXMLFile(xmlFilename)
    local xmlFile = io.open (xmlFilename, "w")
    if xmlFile ~= nil then
        local language = g_languageShort
        local link = "mods.php?lang=en&country=be&title=fs2019&filter=org&org_id=129652&page=0"
        if language == "de" or language == "fr" then
            link = "mods.php?lang=" .. language .. "&country=be&title=fs2019&filter=org&org_id=129652&page=0"
        end

        local extension = g_animalPenExtensionManager
        local purchaseState = tostring(Utils.getNoNil(extension.purchaseOverride, false))
        local waterPriceScale = tostring(Utils.getNoNil(extension.waterPriceScaleOverride, 0))
        local maintenancePerDay = tostring(Utils.getNoNil(extension.maintenancePerDayOverride, 0))
        local chanceOfDelay = tostring(Utils.getNoNil(extension.chanceOfDelay, extension:getDefaultDelayChance()))
        local waterActive = tostring(Utils.getNoNil(extension.waterAddonActive, true))
        local milkActive = tostring(Utils.getNoNil(extension.milkAddonActive, true))
        local chickenActive = tostring(Utils.getNoNil(extension.chickenAddonActive, true))
        local delayActive = tostring(Utils.getNoNil(extension.randomDelayActive, false))
        local delayId = math.max(Utils.getNoNil(extension.delayTextId, 1), 1)
        local numTexts = #extension.randomDelayTexts
        local delayTextId = tostring(math.min(delayId, numTexts))

        local totalDelays = math.max(Utils.getNoNil(extension.totalDelays, 0), 0)
        local previousDelayIds = ' previousDelayIds="' .. table.concat(extension.previousDelayIds, " ") .. '"'

        local saveGameHelp = g_i18n:getText("animalPenExtension_saveGameHelp")
        local xmlText = '<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n\n' ..
            '<!-- [INFORMATION]\n    Support: https://forum.giants-software.com  or  https://github.com/GtX-Andy \n' .. saveGameHelp .. '\n-->\n\n' ..
            '<animalPenExtension build="' .. tostring(AnimalPenExtensionManager.buildId) .. '" version="' .. AnimalPenExtensionManager.versionString .. '">\n' ..
            '    <settings>\n        <waterAddon active="' .. waterActive .. '" purchaseOverride="' .. purchaseState .. '" waterPriceScaleOverride="' .. waterPriceScale .. '" maintenancePerDayOverride="' .. maintenancePerDay .. '"/>\n' ..
            '        <milkAddon active="' .. milkActive .. '" chanceOfDelayPercent="' .. chanceOfDelay .. '"/>\n' ..
            '        <chickenAddon active="' .. chickenActive .. '"/>\n    </settings>\n\n' ..
            '    <!-- No changes required past this point! This is save game data only. -->\n' ..
            '    <milkAddon>\n        <randomDelay isActive="' .. delayActive .. '" textId="' .. delayTextId .. '" delayCounter="' .. totalDelays .. '"' .. previousDelayIds .. '/>\n    </milkAddon>\n' ..
            '</animalPenExtension>'

        xmlFile:write(xmlText)
        xmlFile:close()
        xmlText = nil
    end
end

function AnimalPenExtensionManager:syncSettings(connection)
    local purchaseState = Utils.getNoNil(g_animalPenExtensionManager.purchaseOverride, false)
    local waterPriceScale = Utils.getNoNil(g_animalPenExtensionManager.waterPriceScaleOverride, -1)
    local maintenancePerDay = Utils.getNoNil(g_animalPenExtensionManager.maintenancePerDayOverride, -1)
    local chanceOfDelay = Utils.getNoNil(g_animalPenExtensionManager.chanceOfDelay, 25)
    local waterActive = Utils.getNoNil(g_animalPenExtensionManager.waterAddonActive, true)
    local milkActive = Utils.getNoNil(g_animalPenExtensionManager.milkAddonActive, true)
    local chickenActive = Utils.getNoNil(g_animalPenExtensionManager.chickenAddonActive, true)
    local randomDelayActive = Utils.getNoNil(g_animalPenExtensionManager.randomDelayActive, false)
    local delayTextId = Utils.getNoNil(g_animalPenExtensionManager.delayTextId, 1)

    connection:sendEvent(AnimalPenExtensionJoinGameEvent:new(purchaseState, waterPriceScale, maintenancePerDay, chanceOfDelay, waterActive, milkActive, chickenActive, randomDelayActive, delayTextId))
end

function AnimalPenExtensionManager:loadBaseBuildings()
    if self.baseBuildingsLoaded > 0 then
        self:logPrint(0, "Base game buildings are already loaded!")
        return false, self.baseBuildingsLoaded
    end

    local xmlFile = loadXMLFile("BaseBuildingsXML", self.baseBuildingsXMLFilename)
    if xmlFile == 0 then
        self:logPrint(0, "Failed to load BaseBuildings XML!")
        return false, 0
    end

    if hasXMLProperty(xmlFile, "animalPenExtension") then
        local i = 0
        while true do
            local key = string.format("animalPenExtension.baseBuilding(%d)", i)
            if not hasXMLProperty(xmlFile, key) then
                break
            end

            local i3dFilename = getXMLString(xmlFile, key .. "#filename")
            if i3dFilename ~= nil then
                if string.sub(i3dFilename, 1, 4) == "data" then
                    local i3dFilenameLower = i3dFilename:lower()
                    if self.baseBuildings[i3dFilenameLower] == nil then
                        self.baseBuildings[i3dFilenameLower] = key
                        self.baseBuildingsLoaded = self.baseBuildingsLoaded + 1
                    else
                        self:logPrint(0, "Trying to load duplicate 'baseBuilding' at ", key)
                    end
                else
                    self:logPrint(3, "Trying to load building that is not part of Giants Base Game! ( %s )", key)
                end
            else
                self:logPrint(0, "Filename is missing at %s", key)
            end

            i = i + 1
        end

        delete(xmlFile)

        if self.baseBuildingsLoaded > 0 then
            return true, self.baseBuildingsLoaded
        else
            self:logPrint(0, "Failed to load any base buildings!")
            return false, 0
        end
    else
        self:logPrint(0, "XML key 'animalPenExtension' was not found in %s", self.baseBuildingsXMLFilename)

        delete(xmlFile)
        return false, 0
    end
end

function AnimalPenExtensionManager:initChickenWaterSupport(waterPerDay)
    local subTypeAdded = 0

    if g_animalManager ~= nil and g_animalManager.typeToAnimal.CHICKEN ~= nil then
        if g_animalManager.typeToAnimal.CHICKEN.subTypes ~= nil then
            for _, subType in pairs (g_animalManager.typeToAnimal.CHICKEN.subTypes) do
                -- Chickens eat 5 litres a day so 7 litres of water is a good number.
                -- Animals drink more than they eat! Also accounts for evaporation and cleaning ;-)
                -- Only adjust if no other mod has done this already and water usage is 0.
                if subType.input ~= nil and subType.input.waterPerDay <= 0 then
                    subType.input.waterPerDay = 7
                    subTypeAdded = subTypeAdded + 1
                end
            end
        end
    end

    return subTypeAdded >= 4
end

function AnimalPenExtensionManager:getRandomTextId()
    local delyIndex = 1 + (self.totalDelays % 3)
    local availableDelayTexts = {}
    for i = 1, #self.randomDelayTexts do
        if self.previousDelayIds[1] ~= i and
            self.previousDelayIds[2] ~= i and
            self.previousDelayIds[3] ~= i then

            table.insert(availableDelayTexts, i)
        end
    end

    local delayTextId = math.random(1, #availableDelayTexts)
    self.previousDelayIds[delyIndex] = availableDelayTexts[delayTextId]

    return self.previousDelayIds[delyIndex] or 1
end

function AnimalPenExtensionManager:getNextRandomText()
    local delayTextId = 1

    if self.delayTextId ~= nil then
        local numTexts = #self.randomDelayTexts
        delayTextId = math.max(math.min(self.delayTextId, numTexts), 1)
    end

    return self.randomDelayTexts[delayTextId]
end

function AnimalPenExtensionManager:dayChanged()
    if self.isServer then
        local randomDelayActive = false
        local delayTextId = 1

        if not self.randomDelayActive and self.chanceOfDelay > 0 then
            if math.random(1, 100) <= self.chanceOfDelay then
                randomDelayActive = true
                delayTextId = self:getRandomTextId()
                self.totalDelays = self.totalDelays + 1
            end
        end

        if randomDelayActive ~= self.randomDelayActive or (delayTextId ~= self.delayTextId) then
            self:setDelayData(randomDelayActive, delayTextId, true, false)
        end
    end
end

function AnimalPenExtensionManager:setDelayData(randomDelayActive, delayTextId, sendEvent, forceUpdate)
    if self.isServer and sendEvent then
        if forceUpdate == nil then
            forceUpdate = false
        end

        g_server:broadcastEvent(AnimalPenExtensionDelayEvent:new(randomDelayActive, delayTextId, forceUpdate))
    end

    self.randomDelayActive = randomDelayActive
    self.delayTextId = delayTextId

    if forceUpdate then
        for _, husbandry in pairs (g_currentMission.husbandries) do
            if husbandry.animalPenExtension ~= nil and husbandry.animalPenExtension.milkAddon ~= nil then
                local state = not husbandry.animalPenExtension:getRandomDelayActive() and husbandry.animalPenExtension:getIsSalesOpen()
                if state ~= husbandry.animalPenExtension.milkAddon.salesSignState then
                    husbandry.animalPenExtension:setMilkSaleSigns(state)
                end
            end
        end
    end
end

function AnimalPenExtensionManager:getDefaultDelayChance()
    if g_currentMission ~= nil and g_currentMission.missionInfo ~= nil then
        return 10 + (10 * g_currentMission.missionInfo.difficulty)
    end

    return 20
end

function AnimalPenExtensionManager:logPrint(printLevel, text, ...)
    if printLevel > 0 then
        if printLevel == 1 then
            g_logManager:info(" [FS19_AnimalPenExtension]  " .. text, ...)
        elseif printLevel == 2 then
            g_logManager:warning(" [FS19_AnimalPenExtension]  " .. text, ...)
        elseif printLevel == 3 then
            g_logManager:error(" [FS19_AnimalPenExtension]  " .. text, ...)
        end
    else
        if g_animalPenExtensionManager.debugActive then
            print("  DEBUG: [FS19_AnimalPenExtension]  " .. string.format(text, ...))
        end
    end
end

function animalPenInit(name, c)
    if g_animalPenExtensionManager == nil then
        if (name == "FS19_AnimalPenExtension" or name == "FS19_AnimalPenExtension_update") and c:len() == 3 then
            local modDir = g_currentModDirectory
            local xmlFilename = modDir .. "xml/BaseBuildings.xml"
            if fileExists(xmlFilename) then
                manager = AnimalPenExtensionManager:new(g_server ~= nil, g_client ~= nil, name, modDir, xmlFilename)
                if manager ~= nil then
                    getfenv(0)["g_animalPenExtensionManager"] = manager

                    source(modDir .. "scripts/AnimalPenExtension.lua")

                    source(modDir .. "scripts/misc/APE_ConsoleCommands.lua")
                    source(modDir .. "scripts/misc/APE_ChangedFunctions.lua")
                    source(modDir .. "scripts/misc/APE_UniversalPlacement.lua")

                    source(modDir .. "scripts/events/AnimalPenExtensionFillEvent.lua")
                    source(modDir .. "scripts/events/AnimalPenExtensionDelayEvent.lua")
                    source(modDir .. "scripts/events/AnimalPenExtensionJoinGameEvent.lua")
                    source(modDir .. "scripts/events/AnimalPenExtensionSellMilkEvent.lua")
                    source(modDir .. "scripts/events/AnimalPenExtensionBuildHourEvent.lua")
                    source(modDir .. "scripts/events/AnimalPenExtensionUniversalPartsEvent.lua")

                    if g_gui ~= nil then
                        if g_gui.guis.MilkSaleDialog == nil then
                            source(modDir .. "scripts/gui/MilkSaleDialog.lua")
                            local milkSaleDialog = MilkSaleDialog:new(nil, manager.texts)
                            g_gui:loadGui(modDir .. "scripts/gui/MilkSaleDialog.xml", "MilkSaleDialog", milkSaleDialog)
                        end
                    end

                    g_animalPenExtensionManager.changedFunctions.initFunctions()
                    g_animalPenExtensionManager.universalPlacement = APE_UniversalPlacement:new(g_server ~= nil, g_dedicatedServerInfo == nil)

                    -- Giants have forgotten to allow 'WATER' to be used with MoneyTypes.
                    if MoneyType.PURCHASE_WATER == nil then
                        local globalMoneyType = getfenv(0).MoneyType
                        local nextId = globalMoneyType.LAST_ID + 1
                        globalMoneyType.PURCHASE_WATER = {statistic = "purchaseWater", title = "finance_purchaseWater", id = nextId}
                        globalMoneyType.LAST_ID = nextId
                    end
                end
            end
        else
            getfenv(0)["g_animalPenExtensionError"] = {c = c, name = name, startUpdateTime = 2000}

            g_animalPenExtensionError.update = function(g_animalPenExtensionError, dt)
                if g_animalPenExtensionError ~= nil then
                    if g_animalPenExtensionError.startUpdateTime > 0 then
                        g_animalPenExtensionError.startUpdateTime = g_animalPenExtensionError.startUpdateTime - dt
                    else
                        local title = "Animal Pen Extension - Version " .. AnimalPenExtensionManager.versionString
                        local text = string.format(g_i18n:getText("animalPenExtension_loadError"), g_animalPenExtensionError.name, g_animalPenExtensionError.c)
                        if g_dedicatedServerInfo == nil then
                            if not g_gui:getIsGuiVisible() then
                                g_gui:showYesNoDialog({
                                    title = title,
                                    text = text,
                                    dialogType = DialogElement.TYPE_LOADING,
                                    callback = g_animalPenExtensionError.openModHubLink,
                                    target = nil,
                                    yesText = g_i18n:getText("button_ok"),
                                    noText = g_i18n:getText("button_modHubDownload")
                                })
                            end
                        else
                            print(title .. "  " .. text .. "\n    - https://farming-simulator.com/mods.php?lang=en&country=be&title=fs2019&filter=org&org_id=129652&page=0")
                            g_animalPenExtensionError:openModHubLink(true)
                        end
                    end
                end
            end

            g_animalPenExtensionError.openModHubLink = function(isYes)
                if isYes == false then
                    local language = g_languageShort
                    local link = "mods.php?lang=en&country=be&title=fs2019&filter=org&org_id=129652&page=0"
                    if language == "de" or language == "fr" then
                        link = "mods.php?lang=" .. language .. "&country=be&title=fs2019&filter=org&org_id=129652&page=0"
                    end

                    openWebFile(link, "")
                end

                removeModEventListener(g_animalPenExtensionError)
                getfenv(0)["g_animalPenExtensionError"] = nil
            end

            g_animalPenExtensionError.delete = function()
                if g_animalPenExtensionError ~= nil then
                    removeModEventListener(g_animalPenExtensionError)
                    getfenv(0)["g_animalPenExtensionError"] = nil
                end
            end

            addModEventListener(g_animalPenExtensionError)
        end
    else
        g_animalPenExtensionManager:logPrint(3, "Trying to load mod twice! Only '1' copy is required in your mod folder. Please remove '%s'", name)
    end
end

animalPenInit(g_currentModName, g_modManager:getModByName(g_currentModName).author)
